/*	program to read a UNIX version 6 filesystem image and recreate
	under 4.2 filesystem
*/
#include "cpfs.h"
#include <errno.h>
#include <sys/file.h>
#include <sys/time.h>
#include <stdio.h>
extern int errno;

char buf[512];				/* temporary storage	       	   */
int fd;					/* file descriptor for image file  */
char pname[15];				/* name of file to create	   */
int pflag,mflag,vflag,tflag,fflag;	/* option flags		  	   */

main(argc,argv)
int	argc;
char *argv[];
{
int	 res;
int i,j;
char	*cp;
char *tmp;				/* points to ascii time rep         */
char *usefile = "image" ;		/* file to read file system image from*/


    argv[argc] = 0;
    argv++;
    for (cp = *argv++; *cp; cp++) 
	switch(*cp) {

  	    case 'f':
		if (*argv == 0) {
		    fprintf(stderr,
		    "cpfv: file system image must be specified with 'f' option\n");
		    exit(-1);
		}
		usefile = *argv++;
		fflag++;
		break;


	    case 'p':
		pflag++;
		break;
	
	    case 'v':
		vflag++;
		break;

	    case 't':
		tflag++;
		break;

	    case 'm':
		mflag++;
		break;


	    default:
		fprintf(stderr, "cpfs: %c: unknown option\n", *cp);
		exit(-1);
	}


    fd = open(usefile,O_RDONLY,0);
    if ( fd < 0 ) herror("main, image");

/* read in the super block */

    if ( sread(fd) ) exit(-1) ;

#ifdef DEBUG
/*	printf("buf\t:");
	for (i=0;i<52;i++) {
  	    for (j=0;j<10;j++) 
		printf("    %c",buf[i * 10+j]);
	    printf("\n\t");
	}
*/
	printf("\tSuperblock:\t\t\t(size = %d)\n\t==========\n\n",
	sizeof(struct t_sblock));
	printf("isize\t\t\t%d\n",s_isize);
	printf("fsize\t\t\t%d\n",s_fsize);
	printf("nfree\t\t\t%d\n",s_nfree);
	printf("free:\t");
	for (i=0;i<20;i++) {
	    for (j=0;j<5;j++) 
	    printf("    %d",s_free[i * 10+j]);
	    printf("\n\t");
	};
	printf("\nninode\t\t\t\t%d\n",s_ninode);
	for (i=0;i<20;i++) {
	    for (j=0;j<5;j++) 
		printf("    %d",s_inode[i*10+j]);
 	    printf("\n\t");
	};
	printf("\nflock\t\t\t%d\n",((int) s_flock));
	printf("ilock\t\t\t%d\n",((int) s_ilock));
	printf("fmod\t\t\t%d\n",((int) s_fmod));
	tmp = ctime(s_time);
	printf("time\t\t\t%s",tmp);
	printf("\n\n\n");
#endif DEBUG
	genesis(1);
}







herror(sp) 
char *sp;
{
	perror(sp);
	exit(-1);
}

sread(fd) 
int fd;
{
int	res;
	res = lseek(fd,SOFFSET,0) ;
	if (res <= 0 ) {
	    perror("sread seeking on image");
	    return(-1);
	}

	res = read(fd,buf,SBSIZE);
	if (res == -1 ) {
	    perror("main, sblock read bad");
	    return(-1);
	};
	cpy(buf,&s_isize,2);
	cpy(buf+2,&s_fsize,2);
	cpy(buf+4,&s_nfree,2);
	cpy(buf+6,s_free,100);
	cpy(buf+106,&s_ninode,2);
	cpy(buf+108,s_inode,100);
	cpy(buf+208,&s_flock,1);
	cpy(buf+209,&s_ilock,1);
	cpy(buf+210,&s_fmod,1);
	cpy(buf+211,s_time,4);
	return(0);
};

iread(src,dst) 
char *src;
struct t_inode *dst;
{
int	res;

	res = read(fd,buf,32);
	if (res == -1 ) {
	    perror("iread:, read bad");
	    return(-1);
	};
	cpy(buf,&dst->flags,2);
	cpy(buf+2,&dst->nlinks,1);
	cpy(buf+3,&dst->uid,1);
	cpy(buf+4,&dst->gid,1);
	cpy(buf+5,&dst->size0,1);
	cpy(buf+6,&dst->size1,2);
	cpy(buf+8,dst->addr,16);
	cpy(buf+24,dst->actime,8);
	return(0);
};

cpy(src,dst,cnt)
char *src,*dst;
int		cnt;
{
register i ;
for (i = cnt; i > 0; i--) 
	*dst++ = *src++;
return;
}


genesis(ino)
int	ino;
{
unsigned int nbytes,nblocks;
unsigned int fbytes;		/* number of bytes in last block of file  */
int nentry;			/* number of entrys in directory	  */
int i,j,k;
int skip;			/* index over . an .. and head of directory */
unsigned short *l;
char *tmp;
char ttt[2];
struct timeval tv[2];

struct t_inode  minode;		/* inode for ino    			  */
struct t_inode  inode;		/* current inode being twiddled		  */
struct t_dir	dirt[32];	/* block full of directory enteries       */

	j = lseek(fd,512 * ((ino + 31) / 16) +  32 * (( ino+ 31) % 16),0 ) ;
/* read the inode 	*/
	iread(buf,&minode.flags);
#ifdef DEBUG			/* printout inode crap			  */

	printf("size of inode = %d\n",sizeof (minode));
	printf("seeking to address: %d\n", j);
	printf("\n\tInode %d \n\t=====\n",ino);
	printf("flag\t%u\n",minode.flags);
	printf("nlinks\t%u\n",minode.nlinks);
	printf("uid\t%u\n",minode.uid);
	printf("gid\t%u\n",minode.gid);
	printf("size0\t%u\n",minode.size0);
	printf("size1\t%u\n", minode.size1);
	printf("addr:\t");
	for(i=0;i<8;i++) printf("%u\t",minode.addr[i]);
	tmp = ctime(minode.actime[0] * 65536 + minode.actime[1]);
	printf("\nactime:\t%s\n",tmp);
	tmp = ctime(minode.modtime[0] * 65536 + minode.modtime[1]);
	printf("modtime\t%s\n",tmp);
#endif DEBUG

/*
	check that the inode given to us is really a directory.
	If not lets get a bit upset
*/

	if (!(minode.flags & IDIREC))	{	
		printf("genesis: inode %d not directory\n",ino);
		return(-1);
	}

/*
 * 	All these magic numbers should be hidden away in an include file
 */
	nbytes = minode.size0 * 65536 + minode.size1;
	nblocks = nbytes / 512 ;
/*
 *	Should check that . and .. are present
 */
	nentry = nbytes / 16  - 2 ; 	/* -2 since we skip . and .. enteries */
	if ( (nbytes % 512) ) nblocks = nblocks + 1;
	fbytes = nbytes % 512;		/* number of bytes in last block     */

#	ifdef DEBUG
	printf("nblocks === %d\n",nblocks);
	printf("nbytes  === %d\n",nbytes);
#	endif DEBUG

/*	if directory file is small then go ahead and extract
	files recursively
*/

	if (nblocks < 8 ) {		/* small directory		*/
	  if ( nentry) 	{		/* check if directory is empty	*/
 	     skip = 2;		/* force skip over , and .. 	*/
	     for ( i = 0 ; i < nblocks && nentry > 0 ; i++ ) {
		lseek(fd,minode.addr[i] * 512 ,0);
		read(fd,dirt,512);		/* read in block of enteries */
		for ( j = 0 + skip ; j < 32 && nentry > 0; j++ ) {
		    skip = 0 ;		/* only skip on first block	*/
		   lseek(fd,512 * ((dirt[j].ip + 31) / 16) +	
		         32 * (( dirt[j].ip + 31) % 16),0 ) ;
		   iread(buf,&inode.flags);

/*	If file has been deleted then completly ignore it
 *	if file is unallocated then complain and let user
 *	know about it
 */
		    if (!dirt[j].ip) continue;
		    if (!(inode.flags &  IALLOC )) {
			sprintf(stderr,"Inode for file %s%.14s in dir inode",
			  "%d unallocated\n",dirt[j].fname, ino);
			continue;
		    }
				
		    switch( inode.flags & M_TYP) {

		    case IDIREC: 	/*  if directory new genesis phase */
			{
			cpy(dirt[j].fname,pname,14);
			pname[14] = '\0';
			mkdir(pname,inode.flags & 0777);
			chdir(pname);
			genesis(dirt[j].ip);
			if( mflag )  {
			    tv[0].tv_sec = inode.actime[0] * 65536 + inode.actime[1];
		 	    tv[0].tv_usec = 0;
			    tv[1].tv_sec = inode.modtime[0] * 65536 + inode.modtime[1];
			    tv[1].tv_usec = 0;
			    utimes(pname, tv);
			}
			break;
		    }
		    case M_SPL:
#		       ifdef DEBUG
			sprintf(stderr,"ignoring special file %.14s inode %d\n",
					dirt[j].fname,dirt[j].ip);
#			endif	DEBUG
			break;

			case IPLANE:
				cpy(dirt[j].fname,&pname[0],14);
				pname[14] = '\0';
	/*
			Generate file from inode
	*/
			genfile(dirt[j].ip,&inode.flags);
			break;
		    default:
			sprintf(stderr,"Mangled inode entry in dir inode %d\n",
			   ino);
		    }	/* case   */	
		    nentry -= 1;
#		   ifdef DEBUG
		   	printf("inode name:\t%.14s\n",dirt[j].fname);
#		   endif DEBUG
		}
	      }
	}
	chdir("..");		
    }

/* 
	Directory is large OH my i dont handle this situation	
	Then again i dont think v6 unix handles it either
*/
	if (nblocks >= 8 ) {
	  sprintf(stderr,"Warning: Dir inode %d is large, directory ignored\n",ino);	}
}



genfile(ino,inode)
int	ino;
struct t_inode *inode;
{
int i,j,m;
long	nbytes;
int		nblocks,fblocks,iblocks;
int		fbytes;
int k,l;
unsigned	short	iaddr[256];
struct timeval tv[2];



#ifdef DEBUG
	printf("File inode:\t%u\n",ino);
	printf("flags\t%o\n",inode->flags);
	printf("nlinks\t%u\n",inode->nlinks);
	printf("size0\t%u\n",inode->size0);
	printf("size1\t%u\n",inode->size1);
	printf("addr:\t\n");
	for ( i = 0;i < 4;i++ ) {
		for(j=0;j <2;j++) 
			printf("\t%d\t%d\n",inode->addr[i*2+j]);
	}
#endif

	i = open(pname,O_CREAT | O_WRONLY,0666);
	nbytes = inode->size0 * 65536 + inode->size1;
	fbytes = nbytes % 512;
	nblocks =  nbytes / 512 ;
	if (fbytes) nblocks++;
	if (!(inode->flags & ILARGE)) {	/* small file	*/
	    for (k = 0 ; k < nblocks ; k++ ) {
		lseek(fd,inode->addr[k] * 512 ,0);
		read(fd,buf,512);
		if (fbytes && k == nblocks-1 )
		    write(i,buf,fbytes);
		else write(i,buf,512);
	    }
	if ( mflag) {
	    tv[0].tv_sec = inode->actime[0] * 65536 + inode->actime[1];
	    tv[0].tv_usec = 0;
	    tv[1].tv_sec = inode->modtime[0] * 65536 + inode->modtime[1];
	    tv[1].tv_usec = 0;
	    utimes(pname, tv);
	}
	close(i);
	return(0);
    }
    if (! (inode->addr[7]))	{		/* large file but not huge	*/
	iblocks = nblocks / 256 ;
	fblocks = nblocks % 256 ;
	if (fblocks) iblocks++ ;
	    for (j = 0; j < iblocks ; j++ )	{
		lseek(fd,inode->addr[j] * 512 ,0);
		read(fd,iaddr,512);
#ifdef DEBUG
		printf("physical blocks read from indirect block %d:\n",inode->addr[j]);
		for(m=0 ; m < 8 ; m++ ) printf("\t%o",iaddr[m]);
		printf("\n");
#endif	DEBUG
		for( l = 0 ; l < 256 ; l++ ) {
	      	    if (fblocks && ( j == iblocks-1  && l >= fblocks)) continue;
		    lseek(fd,iaddr[l]*512,0) ;
		    read(fd,buf,512);
		    if (!(--nblocks)) 
			 write(i,buf,fbytes);
		    else write(i,buf,512);
		 }
	}
	if ( mflag ) {
	    tv[0].tv_sec = inode->actime[0] * 65536 + inode->actime[1];;
	    tv[0].tv_usec = 0;
	    tv[1].tv_sec = inode->modtime[0] * 65536 + inode->modtime[1];
	    tv[1].tv_usec = 0;
	    utimes(pname, tv);
	}
	close(i);
	return(0);
    }

	/*	Dont handle double indirect blocks yet sorry	*/
	printf("double indirect block file detected, file ignored\n");
	close(i);
	return(0);
}

