/* p11 - pdp11 emulator; Copyright (C) 1994 Hartmut Brandt, Joerg Micheel 
 * see the file LICENSE for further information */

# include "proc.h"

# ifdef HAS_S5_SIGNALS
/*
 * provide BSD-signal semantics trough posix interface
 */
typedef void	(*sigfunc_t)();

sigfunc_t
SIGNAL(int sig, sigfunc_t act)
{
	struct sigaction	sa, osa;
	sigset_t		set;

	sigemptyset(&set);
	sa.sa_mask = set;
	sa.sa_handler = act;
	sa.sa_flags = SA_RESTART;
	if(sigaction(sig, &sa, &osa))
		return (sigfunc_t)-1;
	return osa.sa_handler;
}
# endif

# ifndef HAS_CFMAKERAW
/*
 * make tty raw
 */
void
cfmakeraw(struct termios *t)
{
        t->c_iflag &= ~(IGNBRK | BRKINT | PARMRK | INPCK | ISTRIP | INLCR | IGNCR | ICRNL | IXON | IXOFF | IXANY);
	t->c_iflag |= IGNPAR;
        t->c_oflag &= ~OPOST;
        t->c_cflag &= ~(CSIZE | PARENB);
        t->c_cflag |= CS8;
        t->c_lflag &= ~(ECHO | ECHONL | ICANON | ISIG | IEXTEN);
	t->c_cc[VMIN] = 1;
	t->c_cc[VTIME] = 0;
}
# endif

/*
 * set file descriptor to receive signal on possible IO
 */
# ifdef HAS_ASYNC_STREAMS
# include <sys/stropts.h>

void
set_fd_async(int fd)
{
	if(ioctl(fd, I_SETSIG, S_RDNORM))
		panic("ioctl(I_SETSIG): %s", strerror(errno));
}

# else
# ifdef HAS_ASYNC_FCNTL

void
set_fd_async(int fd)
{
	int fl;

	if(fcntl(fd, F_SETOWN, getpid()))
		panic( "fcntl(F_SETOWN): %s", strerror(errno) );
	if((fl = fcntl(fd, F_GETFL, 0)) == -1)
		panic( "fcntl(F_GETFL): %s", strerror(errno) );
	if(fcntl(fd, F_SETFL, VAL_FASYNC | fl))
		panic( "fcntl(F_SETFL): %s", strerror(errno) );
}

# else
# error "Don't know how to enable SIGIO"
# endif
# endif
