#include <stdio.h>
#include <varargs.h>

/* extern XXX */ char **argvec;

#define NEED_NAME
#define NEED_OPFORMATS
#define NEED_DEFS
#define NEED_ALT_DEFS
#include "instrtbl.h"

unsigned char core[65536];
unsigned char wrotecore[65536];

char *initialfn;

#define DEF_UNKNOWN (N_INSTR_DEF+1)
#define DEF_UNUSED (N_INSTR_DEF+2)

short int deftbl[65536];

void bugchk(va_alist)
va_dcl
{
 va_list ap;
 char *fmt;

 va_start(ap);
 fmt = va_arg(ap,char *);
 fprintf(stderr,"%s: INTERNAL BUG: ",argvec[0]);
 vfprintf(stderr,fmt,ap);
 fprintf(stderr,"\n");
 va_end(ap);
 abort();
}

void initcore()
{
 bzero(&wrotecore[0],65536);
}

void loadcore(fn)
char *fn;
{
 FILE *f;
 unsigned long int addr;
 unsigned long int count;
 int value;

 f = fopen(fn,"r");
 if (f == 0)
  { fprintf(stderr,"%s: can't open %s for reading\n",argvec[0],fn);
    exit(1);
  }
 while (1)
  { if (fscanf(f,"%lx%lx",&addr,&count) != 2) break;
    for (;count>0;count--)
     { if (fscanf(f,"%x",&value) != 1) break;
       addr &= 0xffff;
       core[addr] = value & 0xff;
       wrotecore[addr] = 1;
       addr ++;
     }
  }
 fclose(f);
}

int idcmp(idcp1,idcp2)
char *idcp1;
char *idcp2;
{
 return( (0xffff&(int)((INSTR_DEF *)idcp1)->value) - (0xffff&(int)((INSTR_DEF *)idcp2)->value) );
}

void initinstrs()
{
 int i;
 char *idcp[N_INSTR_DEF];
 INSTR_DEF idarr[N_INSTR_DEF];

 for (i=0;i<N_INSTR_DEF;i++) idcp[i] = (char *) &instr_defs[i];
 heapsort(&idcp[0],N_INSTR_DEF,idcmp);
 for (i=0;i<N_INSTR_DEF;i++) idarr[i] = * (INSTR_DEF *) idcp[i];
 for (i=0;i<N_INSTR_DEF;i++) instr_defs[i] = idarr[i];
 for (i=0;i<65536;i++) deftbl[i] = DEF_UNKNOWN;
}

int get_deftbl(inst)
word inst;
{
 int l;
 int m;
 int h;

 if (deftbl[inst] != DEF_UNKNOWN) return(deftbl[inst]);
 l = 0;
 h = N_INSTR_DEF - 1;
 while (h-l > 1)
  { m = (h + l) / 2;
    if (inst >= instr_defs[m].value)
     { l = m;
     }
    else
     { h = m;
     }
  }
 if ((inst & instr_defs[l].mask) != instr_defs[l].value) l = DEF_UNUSED;
 deftbl[inst] = l;
 return(l);
}

static void dumpasm()
{
 unsigned long int addr;
 int addrinc;

 addrinc = 0;
 for (addr=0;addr<65536;addr+=2)
  { if (wrotecore[addr])
     { if (addrinc > 0)
	{ printf("%40s","");
	  disas((word)(addr&0xfffe));
	}
       else
	{ addrinc = disas((word)(addr&0xfffe));
	}
       printf("\n");
     }
    addrinc -= 2;
  }
}

void main(ac,av)
int ac;
char **av;
{
 int skip;
 int errs;
 int argno;

 argvec = av; /* XXX */
 if (0)
  {
usage:;
    fprintf(stderr,"Usage: %s initial-core-file\n",argvec[0]);
    exit(1);
  }
 skip = 0;
 errs = 0;
 argno = 0;
 for (ac--,av++;ac;ac--,av++)
  { if (skip > 0)
     { skip --;
       continue;
     }
    if (**av == '-')
     { for (++*av;**av;++*av)
	{ if (0)
	   {
needarg:;
	     fprintf(stderr,"%s: -%c needs another argument\n",argvec[0],**av);
	     errs ++;
	     continue;
	   }
	  switch (**av)
	   { default:
		fprintf(stderr,"%s: bad flag -%c\n",argvec[0],**av);
		errs ++;
		break;
	   }
	}
     }
    else
     { switch (argno++)
	{ default:
	     fprintf(stderr,"%s: extra argument %s\n",argvec[0],*av);
	     errs ++;
	     break;
	  case 0:
	     initialfn = *av;
	     break;
	}
     }
  }
 if (errs) goto usage;
 if (! initialfn) goto usage;
 initcore();
 initinstrs();
 loadcore(initialfn);
 dumpasm();
}

word fetchword(addr)
word addr;
{
 return(core[addr]|(core[addr+1]<<8));
}

void put(c)
int c;
{
 putchar(c);
}

static puts(s)
/* #define CONST const */
#define CONST 
CONST char *s;
{
 for (;*s;s++) put(*s);
}

static putx8(val)
unsigned long int val;
{
 int i;

 val &= 0xffffffff;
 for (i=28;i>=0;i-=4) put("0123456789abcdef"[(val>>i)&0xf]);
}

static put6(val)
word val;
{
 int i;

 val &= 0xffff;
 for (i=15;i>=0;i-=3) put('0'+((val>>i)&7));
}

static put3(val)
word val;
{
 put('0'+((val>>6)&3));
 put('0'+((val>>3)&7));
 put('0'+(val&7));
}

static put2(val)
word val;
{
 put('0'+((val>>3)&7));
 put('0'+(val&7));
}

#define MMAN_ISPACE 0

word fps = 0;
#define FPS_FD 0x0001

#include "disas-common"
