/* Copyright (c)1997 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */
/*
 * $Id: panic.c,v 1.7 1998/07/13 13:35:08 hbb Exp $
 */
# include <stdio.h>
# include <stdlib.h>
# include "begemot.h"
# include "private.h"

/*
 * Simple fatal exit.
 */
void
panic(const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	begemot_common_err("panic", "\n", fmt, ap);
	va_end(ap);

	if(getenv("BEGEMOT_ABORT"))
		abort();
	exit(1);
}
void
vpanic(const char *fmt, va_list ap)
{
	begemot_common_err("panic", "\n", fmt, ap);

	if(getenv("BEGEMOT_ABORT"))
		abort();
	exit(1);
}
