 b.nleft <= b.gotten */
		b.nextp = bbuf + b.gotten - b.nleft;
		lseek(0, bend, 0);	/* really at end ofbuffer */
	} else {
		b.nleft = b.gotten = 0;
		b.start = where;
		lseek(0, where, 0);
	}
	return;
}

/*	sname: simple name (last component) of file name */
char *sname(s)
register char *s;
{
	register char *p;
	for(p = s; *p;)
		if (*p++ == '/' && *p != '\0')
			s = p;
	return(s);
}

/*	setwhere: set up wherev for $w (1st component of pathname) */
char	wherev[6];
setwhere()
{
	register char *s, *w;
	register i;
	s = seta[S];
	seta[W] = w = wherev;
	i = 0;
	do {
		*w++ = *s++;
	} while (++i < 5 && *s != '/');
}

/*
 *	pexinit: fills in pathstr (seta[P]) and shellnam (seta[Z]).
 *	may be invoked before fork to avoid unnecessary .path opening.
 *	returns 0 if OK, -1 if any error.
 */
pexinit()
{
	char pathbuf[128 + 16];
	register n, f;
	char *newpath, *newshell;
	char *p;

	newshell = "/bin/sh";
	pcat(seta[S], ".path", pathbuf, sizeof pathbuf);
	if ((f = open(pathbuf, 0)) < 0)
		newpath = uid ? ":/bin:/usr/bin" : "/bin:/etc:/";
	else {
		n = read(f, pathbuf, sizeof pathbuf);
		close(f);
		if (n <= 0) {
			prs("cannot read .path"); prs("\n");
			return(-1);
		}
		if (pexline(pathbuf, pathbuf + n, 128, &newpath, &p)
		|| pexline(p, pathbuf + n, 16, &newshell, &p))
			return(-1);
	}
	seta[P] = rdval(0, 0, newpath);
	seta[Z] = rdval(0, 0, newshell);
	return(0);
}

/*
 *	pexline: scan for a line (if any) beginning at ptr,
 *	ending at ptrlim -1, for line up to psize bytes long.
 *	convert it to string, return beginning addr in pret
 *	and addr of next line in pnext
 *	return 0 if OK (or not present), -1 if runs off end in middle of line
 *	or if line too long.
 */
pexline(ptr, ptrlim, psize, pret, pnext)
register char *ptr, *ptrlim;
int psize;
char **pret, **pnext;
{
	if (ptr >= ptrlim)
		return(0);
	*pret = ptr;
	if (ptrlim > ptr + psize)
		ptrlim = ptr + psize;
	for (; ptr < ptrlim; ptr++)
		if (*ptr == '\n') {
			*ptr++ = '\0';
			*pnext = ptr;
			return(0);
		}
	prs(".path too long"); prs("\n");
	return(-1);
}
/*
 *	sh internal version of /etc/glob
 *	(from her