			prstr("cp write error.\n");
			exit(1);
		}
	}
	exit(0);
}
prstr(s)
char *s;
{
	register i;

	for(i=0;*s;i++)s++;
	write(2,s-i,i);
}
, buf+50) >= 0) {
		if (buf[0]==buf[50] && buf[1]==buf[51]) {
			prstr("cp: cannot copy file to itself.\n");
			exit(1);
		}
	}
	if ((fnew = creat(argv[2], mode)) < 0) {
		prstr("cp cannot create ");
		prstr(argv[2]);
		prstr("\n");
		exit(1);
	}
	while(n = read(fold,  buf,  512)) {
	if(n < 0) {
		prstr("cp read error\n");
		exit(1);
	} else
		if(write(fnew, buf, n) != n){
#include "stdio.h"
#include "stat.h"
#define EQ(x,y)	(strcmp(x,y)==0)
#define MAGIC	070707
#define IN	1
#define OUT	2
#define PASS	3
#define HDRSIZE	((sizeof Hdr)-256)
#define INPUT	0
#define OUTPUT	1

struct	statb	Statb, Xstatb;

struct header {
	int	h_magic,
		h_dev,
		h_ino,
		h_mode,
		h_uid,
		h_gid,
		h_nlink,
		h_majmin;
	long	h_mtime;
	int	h_namesize;
	long	h_filesize;
	char	h_name[256];
} Hdr;

int	Buf[256], Wbuf[256];
int	*Wp	Wbuf,
	Wct	256;

union { int	integ; };

int	Option,
	Mod_time,
	Dir,
	Uncond,
	Link,
	Rename,
	Toc,
	Verbose,
	Select;

int	Ifile,
	Ofile;
unsigned	Blocks;

char	Fullname[256],
	Name[128];

FILE	*Rtty,
	*Wtty;

char	*Pattern;
int	Dev;
int	Uid, Gid;
int	A_directory,
	A_special;

main(argc, argv)
char **argv;
{
	register ct;
	long	filesz;
	register char *fullp, *lastarg;
	long itol();

	if(argc < 2 || argc > 4) {
usage:
		fprintf(stderr,
		"Usage: cpio -o[v] <name-list >archive\n%s\n%s\n",
		"       cpio -i[dmrtuv] [pattern] <archive",
		"       cpio -p[dlmruv] [pattern] directory <name-list");
		exit(1);
	}
	lastarg = argv[argc-1];
	if(*argv[1] != '-')
		goto usage;
	Uid = getuid() & 0377;
	Gid = getgid() & 0377;

	while(*++argv[1]) {
		switch(*argv[1]) {
		case 'i':
			Option = IN;
			Pattern = argc == 2? "*": argv[2];
			break;
		case 'o':
			Option = OUT;
			break;
		case 'p':
			if(access(lastarg, 2) == -1) {
accerr:
				fprintf(stderr, "cannot write in <%s>\n",
					lastarg);
				exit(1);
			}
			strcpy(Fullname, lastarg);
			strcat(Fullname, "/");
			stat(Fullname, &Xstatb);
			if((Xstatb.i_mode&IFMT) != IFDIR)
				goto accerr;
			Option = PASS;
			Dev = Xstatb.i_dev;
			Pattern = argc == 3? "*": argv[2];
			break;
		case 'm':
			++Mod_time;
			break;
		case 'd':
			Dir++;
			break;
		case 'r':
			Rename++;
			Rtty = fopen("/dev/tty", "r");
			Wtty = fopen("/dev/tty", "w");
			break;
		case 't':
			Toc++;
			break;
		case 'u':
			Uncond++;
			break;
		case 'l':
			Link++;
			break;
		case 'v':
			Verbose++;
			break;
		default:
			goto usage;
		}
	}
	if(!Option) {
		fprintf(stderr, "Options must include o|i|p\n");
		exit(1);
	}

	switch(Option) {

	case OUT:
		while(getname()) {
			if(Hdr.h_filesize == 0L) {
				bwrite(OUTPUT, &Hdr, HDRSIZE+Hdr.h_namesize);
				continue;
			}
			if((Ifile = open(Hdr.h_name, 0)) < 0) {
				fprintf(stderr, "<%s> ?\n", Hdr.h_name);
				continue;
			}
			bwrite(OUTPUT, &Hdr, HDRSIZE+Hdr.h_namesize);
			for(filesz=Hdr.h_filesize; filesz>0; filesz-= 512){
				ct = filesz>512? 512: filesz;
				read(Ifile, Buf, ct);
				bwrite(OUTPUT, Buf, ct);
			}
			close(Ifile);
			if(Verbose)
				fprintf(stderr, "%s\n", Hdr.h_name);
		}
		strcpy(Hdr.h_name, "TRAILER!!!");
		Hdr.h_filesize = 0L;
		Hdr.h_namesize = strlen("TRAILER!!!") + 1;
		bwrite(OUTPUT, &Hdr, 600);
		break;

	case IN:
		while(gethdr()) {
			Ofile = ckname(Hdr.h_name)? openout(Hdr.h_name): 0;
			for(filesz=Hdr.h_filesize; filesz>0; filesz-= 512){
				ct = filesz>512? 512: filesz;
				bread(ct, Wbuf);
				if(Ofile)
					write(Ofile, &Wbuf, ct);
			}
			if(Ofile) {
				close(Ofile);
				set_time(Hdr.h_name, Hdr.h_mtime, Hdr.h_mtime);
			}
			if(!Select)
				continue;
			if(Verbose)
				if(Toc)
					pentry(Hdr.h_name);
				else
					puts(Hdr.h_name);
			else if(Toc)
				puts(Hdr.h_name);
		}
		break;

	case PASS:
		fullp = Fullname + strlen(Fullname);

		while(getname()) {
			if(!ckname(Hdr.h_name))
				continue;
			strcpy(fullp, Hdr.h_name);

			if(Link
			&& !A_directory
			&& Dev == Statb.i_dev
			&& (Uid == Statb.i_uid || !Uid)) {
				unlink(Fullname);
				if(link(Hdr.h_name, Fullname) < 0) {
					fprintf(stderr,
					 "Cannot link <%s> & <%s>\n",
					 Hdr.h_name, Fullname);
					continue;
				}
				set_time(Fullname, Hdr.h_mtime, Hdr.h_mtime);
				goto ckverbose;
			}
			if(!(Ofile = openout(Fullname)))
				continue;
			if((Ifile = open(Hdr.h_name, 0)) < 0) {
				fprintf(stderr, "<%s> ?\n", Hdr.h_name);
				close(Ofile);
				continue;
			}
			filesz = itol(Statb.i_size0 & 0377, Statb.i_size1);
			for(; filesz > 0; filesz -= 512) {
				ct = filesz>512? 512: filesz;
				read(Ifile, Buf, ct);
				if(Ofile)
					write(Ofile, Buf, ct);
				++Blocks;
			}
			close(Ifile);
			if(Ofile) {
				close(Ofile);
				set_time(Fullname, Statb.i_atime,
					Statb.i_mtime);
ckverbose:
				if(Verbose)
					puts(Fullname);
			}
		}
	}
	fprintf(stderr, "%l blocks\n", Blocks);
	exit(0);
}

getname()
{
	register char *namep  Name;

	for(;;) {
		if(gets(namep) == NULL)
			return 0;
		if(*namep == '.' && namep[1] == '/')
			strcpy(Hdr.h_name, namep+2);
		else
			strcpy(Hdr.h_name, namep);
		if(stat(Hdr.h_name, &Statb) < 0) {
			fprintf(stderr, "<%s> ?\n", Hdr.h_name);
			continue;
		}
		A_directory = (Statb.i_mode & IFMT) == IFDIR;
		A_special = Statb.i_mode & IFMT;
		Hdr.h_magic = MAGIC;
		Hdr.h_namesize = strlen(Hdr.h_name) + 1;
		Hdr.h_uid = Statb.i_uid;
		Hdr.h_gid = Statb.i_gid;
		Hdr.h_dev = Statb.i_dev;
		Hdr.h_ino = Statb.i_ino;
		Hdr.h_mode = Statb.i_mode;
		Hdr.h_mtime = Statb.i_mtime;
		Hdr.h_nlink = Statb.i_nlink;
		Hdr.h_filesize = Hdr.h_mode&IFMT? 0L:
			itol(Statb.i_size0 & 0377, Statb.i_size1);
		Hdr.h_majmin = Statb.i_addr[0];
		return 1;
	}
}

gethdr()
{

	bread(HDRSIZE, &Hdr);

	if(Hdr.h_magic != MAGIC) {
		fprintf(stderr,
		"Out of phase--get help (or try `_cpio' for old format)\n");
		exit(1);
	}
	bread(Hdr.h_namesize, &Hdr.h_name);
	if(EQ(Hdr.h_name, "TRAILER!!!"))
		return 0;
	A_directory = (Hdr.h_mode & IFMT) == IFDIR;
	A_special = Hdr.h_mode & IFMT;
	return 1;
}

ckname(namep)
register char *namep;
{
	++Select;
	if(!gmatch(namep, Pattern)) {
		Select = 0;
		return 0;
	}
	if(Rename) {
		fprintf(Wtty, "Rename <%s>\n", namep);
		fflush(Wtty);
		fgets(namep, 128, Rtty);
		if(feof(Rtty))
			exit(1);
		namep[strlen(namep) - 1] = '\0';
		if(EQ(namep, "")) {
			printf("Skipped\n");
			return 0;
		}
	}
	return !Toc;
}

openout(namep)
register char *namep;
{
	register f;

	if(A_directory) {
		if(!Dir
		|| Rename
		|| EQ(namep, ".")
		|| EQ(namep, "..")
		|| stat(namep, &Xstatb) == 0)
			return 0;

		makdir(namep);
ret:
		chmod(namep, Hdr.h_mode);
		if(Uid == 0)
			chown(namep, Hdr.h_uid.integ);
		return 0;
	}
	if(Hdr.h_nlink > 1)
		if(!postml(namep))
			return 0;
	if(A_special) {
		unlink(namep);
		if(mknod(namep, Hdr.h_mode, Hdr.h_majmin) < 0) {
			fprintf(stderr, "Cannot mknod <%s>\n", namep);
			return 0;
		}
		goto ret;
	}
	if(stat(namep, &Xstatb) == 0)
		if(!Uncond && (Hdr.h_mtime < Xstatb.i_mtime)) {
			fprintf(stderr, "current <%s> newer\n",
				namep);
			return 0;
		}
	if(Option == PASS
	&& Hdr.h_ino == Xstatb.i_ino
	&& Hdr.h_dev == Xstatb.i_dev) {
		fprintf(stderr, "Attempt to pass file to self!\n");
		exit(1);
	}
	if((f = creat(namep, 0600)) < 0) {
		if(Dir) {
			register char *np;
			register v;

			for(np = namep; *np; ++np) {
				if(*np == '/') {
					*np = '\0';
					if((v=stat(namep, &Xstatb))== -1) {
						makdir(namep);
						*np = '/';
					} else if((Xstatb.i_mode&IFMT)
						!= IFDIR) {
						*np = '/';
						break;
					}
					*np = '/';
				}
			}
		}
		if((f = creat(namep, 0600)) < 0) {
			fprintf(stderr, "Cannot create <%s>\n", namep);
			return 0;
		}
	}
	if(Uid == 0)
		chown(namep, Hdr.h_uid.integ);
	chmod(namep, Hdr.h_mode); /* move til after copy */
	return f;
}

bread(fct, b)
register fct, *b;
{
	static nleft;
	static *ip;

	fct = (fct+1)>>1;
	while(fct--) {
		if(!nleft) {
			if(read(INPUT, Buf, 512)!=512) {
				fprintf(stderr, "Read error\n");
				exit(1);
			}
			nleft = 256;
			ip = Buf;
			++Blocks;
		}
		*b++ = *ip++;
		--nleft;
	}
}

bwrite(f, rp, c)
register *rp;
register c;
{
	c = (c+1) >> 1;
	while(c--) {
		if(!Wct) {
			if(write(f, Wbuf, 512)<0) {
				fprintf(stderr, "Cannot write.\n");
				exit(1);
			}
			Wct = 256;
			Wp = Wbuf;
			++Blocks;
		}
		*Wp++ = *rp++;
		--Wct;
	}
}

postml(namep)
register char *namep;
{
	register i;

	static struct ml {
		int	m_dev,
			m_ino;
		char	m_name[2];
	} *ml[250];
	
	static	mlinks 0;

	for(i = 0; i < mlinks; ++i) {
		if(mlinks == 250) break;
		if(ml[i]->m_ino==Hdr.h_ino &&
			ml[i]->m_dev==Hdr.h_dev) {
			if(Verbose)
			  printf("%s linked to %s\n", ml[i]->m_name,
				Hdr.h_name);
			unlink(namep);
			if(link(ml[i]->m_name, namep) < 0) {
				fprintf(stderr, "Cannot link <%s>&<%s>.\n",
					ml[i]->m_name, namep);
			}
			set_time(namep, Hdr.h_mtime, Hdr.h_mtime);
			return 0;
		}
	}
	if(mlinks == 250
	|| (ml[mlinks] = alloc(strlen(namep) + sizeof(struct ml))) < 0) {
		fprintf(stderr, "Out of core for links\n");
		mlinks = 250;
		return 1;
	}
	ml[mlinks]->m_dev = Hdr.h_dev;
	ml[mlinks]->m_ino = Hdr.h_ino;
	strcpy(ml[mlinks]->m_name, namep);
	++mlinks;
	return 1;
}

pentry(namep)
register char *namep;
{

	register i;
	static lastid -1;
	static char nbuf[100], tbuf[32];

	printf("%-7o", Hdr.h_mode);
	if(lastid == Hdr.h_uid)
		printf("%-6s", nbuf);
	else {
		if(getpw(Hdr.h_uid&0377, nbuf)==0) {
			for(i=0; nbuf[i] != ':'; ++i);
			nbuf[i] = '\0';
			printf("%-6s", nbuf);
			lastid = Hdr.h_uid;
		} else
			printf("%-6d", Hdr.h_uid);
	}
	printf("%7D ", Hdr.h_filesize);
	strcpy(tbuf, ctime(&Hdr.h_mtime));
	tbuf[24] = '\0';
	printf(" %s  %s\n", &tbuf[4], namep);
}

gmatch(s, p)
register char *s, *p;
{
	register int c;
	int cc, ok, lc, scc;

	if(EQ(p, "*"))
		return 1;
	scc = *s;
	lc = 077777;
	switch (c = *p) {

	case '[':
		ok = 0;
		while (cc = *++p) {
			switch (cc) {

			case ']':
				if (ok)
					return(gmatch(++s, ++p));
				else
					return(0);

			case '-':
				ok =| lc <= scc & scc <= (cc=p[1]);
			}
			if (scc==(lc=cc)) ok++;
		}
		return(0);

	case '?':
	caseq:
		if(scc) return(gmatch(++s, ++p));
		return(0);
	case '*':
		return(umatch(s, ++p));
	case 0:
		return(!scc);
	}
	if (c==scc) goto caseq;
	return(0);
}

umatch(s, p)
register char *s, *p;
{
	if(*p==0) return(1);
	while(*s)
		if (gmatch(s++,p)) return(1);
	return(0);
}

makdir(namep)
register char *namep;
{
	if(fork())
		wait(0);
	else {
		execl("/bin/mkdir", "mkdir", namep, 0);
		fprintf(stderr, "mkdir <%s> failed\n", namep);
		exit(1);
	}
}

set_time(namep, atime, mtime)
register *namep;
long atime, mtime;
{
	static long timevec[2];

	if(!Mod_time)
		return;
	timevec[0] = atime;
	timevec[1] = mtime;
	utime(namep, timevec);
}
cc) goto caseq;
	return(0);
}

umatch(s, p)
register char *s, *p;
{
	i#
/*
 * Copy a file
 */
#include <stdio.h>
#include <stat.h>
#define MAGIC 076907
	long	itol();
	long	nbrchar, sumchar;
	struct statb statb,statb1;
	struct {
		int	magic;	/* always MAGIC */
		char	name[129];
		int	hflags;
		char	huid, hgid;
		char	null;
		long	hmtime;
		long	nbrchar;
		long	sumchar;
	} hdr;
main(argc, argv) char **argv; {
	int	f1, f2, i, ansflg;
	FILE *f1id, *f2id;
	char	c;
	f1=f2=ansflg=0;
	if(argc != 3) {
		fprintf(stderr,"Usage: cpx {file1 | -} {file2 | - | .}\n");
		exit(1);
	}
	if(argv[1][0] == '-') {
		f1++;
	}
	if(argv[1][0] == '+') {
		ansflg++; f1++;
	}
	if(argv[2][0] == '-') {
		f2++;
	}
	if(f1 == 0 && f2 == 0) {
		if(stat(argv[1],&statb) != 0) {
			fprintf(stderr,"stat error %s\n",argv[2]);
			exit(1);
		}
		if(stat(argv[2],&statb1) == 0) {
			if(statb.i_dev == statb1.i_dev && statb.i_ino == statb1.i_ino) {
				fprintf(stderr,"Copying file to itself\n");
				exit(1);
			}
		}

	}
/*
 * Setup input file
 */
	f1id = stdin;
	if(f1 == 0) {
		if((f1id=file(argv[1]))==1) {
			fprintf(stderr,"Can't copy directory.\n");
			exit(1);
		}
		if(f1id == -1) {
			fprintf(stderr,"File not found: %s\n", argv[1]);
			exit(1);
		}
		hdr.magic = MAGIC;
		strcpy(hdr.name, argv[1]);
		hdr.hflags = statb.i_mode;
		hdr.huid = statb.i_uid;
		hdr.hgid = statb.i_gid;
		hdr.hmtime = statb.i_mtime;
		fclose(stdin);
		if((f1id = fopen(argv[1],"r"))==NULL) {
			fprintf(stderr,"Can't open %s\n", argv[1]);
			exit(1);
		}
	}
	else {
		fread(&hdr, sizeof hdr, 1, f1id);
		if(ferror(f1id)) {
			fprintf("READ ERROR\n");
			exit(1);
		}
		if(hdr.magic != MAGIC) {
			fprintf(stderr,"Illegl input\n");
			exit(1);
		}
	}
/*
 * Setup output file
 */
	f2id = stdout;
	if(f2 == 0) {
		i = 0;
		if((f2id=file(argv[2]))==1) {
			if(chdir(argv[2])<0) {
				fprintf(stderr,"Can't use %s\n", argv[2]);
				exit(1);
			}
			else {
				i = findname(hdr.name);
				strcpy(hdr.name, &hdr.name[i]);
				if((f2id=file(hdr.name))==1) {
					fprintf(stderr,"%s/%s is a directory.\n",
						argv[2], hdr.name);
					exit(1);
				}
			}
		}
		else {
			strcpy(hdr.name, argv[2]);
		}
		fclose(stdout);
		if((f2id = fopen(hdr.name,"w")) == NULL) {
			fprintf(stderr,"Can't create new file %s\n", hdr.name);
			exit(1);
		}
}
/*
 * case 1:	cpx file1 file2
 */
	if(f1 == 0 && f2 == 0) {
		copyfile(f1id, f2id);
		chghdr();
		exit(0);
	}
/*
 * case 2:	cpx - file2
 */
	if(f1 == 1 && f2 == 0) {
		copyfile(f1id, f2id);
		chghdr();
		if(nbrchar != hdr.nbrchar || sumchar != hdr.sumchar) {
			fprintf(stderr,"Check output for error.\n");
			exit(1);
		}
		if(ansflg) {
			fprintf(stderr,"ok\n");
		}
		exit(0);
	}
/*
 * case 3*	cpx file1 -
 */
	if(f1 == 0 && f2 == 1) {
		while((c=getc(f1id)) != EOF) {
			if(ferror(f1id)) {
				fprintf(stderr,"Read error\n");
				exit(1);
			}
			hdr.nbrchar =+ 1;
			hdr.sumchar =+ c;
		}
		rewind(f1id);
		fwrite(&hdr, sizeof hdr, 1, f2id);
		if(ferror(f2id)) {
			fprintf("WRITE ERROR\n");
			exit(1);
		}
		copyfile(f1id, f2id);
		exit(0);
	}
/*
 * case 4:	cpx - -
 */
	exit(1);
}
/*
 * find file and determine type:
 *	-1 = file not found, 0 = ordinary file, 1 = directory.
 */
file(fname) {
	if(stat(fname, &statb) != 0)
		return(-1);
	if((statb.i_mode&IFMT)==IFDIR)
		return(1);
	return(0);
}
/*
 * Find lowest level file name in path
 */
findname(s)
char *s; {
	int n, i;
	for(i=n=0; *s != '\0'; n++) {
		if(*s++ == '/')
			i=n+1;
	}
	return(i);
}
/*
 * change header
 */
chghdr() {
	chown(hdr.name, hdr.huid);
	chmod(hdr.name, hdr.hflags);
}
/*
 * copy file
 */
copyfile(f1id, f2id) {
	char c;
	while((c=getc(f1id)) != EOF) {
		if(ferror(f1id)) {
			fprintf("Read error\n");
			exit(1);
		}
		nbrchar =+ 1;
		sumchar =+ c;
		putc(c, f2id);
		if(ferror(f2id)) {
			fprintf("Write error\n");
			exit(1);
		}
	}
}
nd lowest level file name in path
 */
findname(s)
char *s; {
	int n, i;
	for(i=n=0; *s != '\0'; n++) {
		if(*s++ == '/')
			i=n+1;
	}
	return(i);
}
/*
 * change header
 */
chghdr() {
	chown(hdr.name, hdr.huid);
	chmod(hdr.name, hdr.hflags);
}
/*
 * copy file
 */
copyfile(f1id, f2id) {
	char c;
	while((c=getc(f1id)) != EOF) {
		if(ferror(f1id)) {
		eacts.c        
  7#
# include "mcons.c"
# include "ccmn.c"
# define SKIP 0
# define COLLECT 1
# define SKIP2 2

int	cross	1;
int	order	1;
char	mone	-1;

coll()
{
	cs = COLLECT;
	temp[t1].beg = &line[l];
	return;
}

save()
{
	extern	wspace();

	line[l] = '\0';
	temp[t1].ct = &line[l] - temp[t1].beg;
	temp[t1].term = c;

	if((c == ' ' || c == '\t') && cflag) {
		gch[++fl] = mone;
		flag[fl] = &wspace;
	} else {
		sav1();
	}
	return;
}

sav1()
{
	extern	only;
	struct tempent	*ptr;
	int	a,tt,val;

	ptr = &temp[t1];
	val = search(ptr->beg,ptr->ct,&itab,0);
	if(cflag && c == '(' && level == 0 && hlevel == 0)
		csym();

	cs = SKIP;


	if(xsw) {
	    switch(val) {
		case 0:
			if((!level&&!hlevel)||(c == '(')||xtrn
				|| ssw) {
				search(ptr->beg,ptr->ct,&xtab,1);
				goto yes;
			} else {
				if(search(ptr->beg,ptr->ct,&xtab,0))
					goto yes;
			}
			goto no;

		case 1:
			break;

		case 2:
			xtrn = 1;
			goto no;

		case 3:
			if(hlevel)	type = 1;
			if(!level&&!hlevel)	ssw = 1;
			goto no;

		case 4:
			if(hlevel)	type = 1;
			goto no;

		case 5:
			goto no;
	    }
	}

	if(hlevel && (val == 4 || val == 3))	type = 1;
	if(!val == !only)	goto yes;
no:
	*(ptr->beg + ptr->ct) = ptr->term;
	return(0);
yes:
	tt = t1;
	while(tt)
		if(comp(ptr->beg,temp[--tt].beg))	goto no;
	t1++;
	return(1);
}

out()
{
	auto	i,ct;
	if(cs == COLLECT)	save();

	ct = t1;
	while(ct--)
		temp[ct].beg[temp[ct].ct] = temp[ct].term;

	while(t1--) {
/*printf("t1 = %d  beg = %d  ct = %d\n",t1,temp[t1].beg,temp[t1].ct); /* DEBUG */

		switch(order) {

			case 1:
				if(utmp)
					i = 0;
				else
					i = dfile(temp[t1].beg);

				if((ct = temp[t1].ct) >= 8) {
					ct = 8;
					*curf = -1;
				} else {
					*curf = '\t';
				}

				put(i,temp[t1].beg,ct);
				if(!single)
					put(i, curf, curfl);
				else
					put(i, curf, 1);
				if(cross)	put(i,curs,cursl);
				conf(lno,4,lbuf);
				put(i,lbuf,5);
				break;

			case 2:
				i = dfile(curf+1);
				put(i,curf+1,curfl-1);
				if(cross)	put(i,curs,cursl);
				else {
					conf(lno,4,lbuf);
					put(i,lbuf,5);
				}
				if((ct = temp[t1].ct) >= 8) {
					put(i,temp[t1].beg,8);
					put(i,&mone,1);
				} else {
					put(i,temp[t1].beg,ct);
					put(i,"\t",1);
				}
				if(cross) {
					conf(lno,4,lbuf);
					put(i,lbuf,5);
				}
				break;

			case 3:
				i = dfile(curs);
				put(i,curs,cursl);
				if((ct = temp[t1].ct) >= 8) {
					put(i,temp[t1].beg,8);
					*curf = -1;
				} else {
					put(i,temp[t1].beg,ct);
					*curf = '\t';
				}
				put(i,curf,curfl);
				conf(lno,4,lbuf);
				put(i,lbuf,5);
		}
		if(!nocont)
			put(i,line,l + 1);

	}
	t1 = 0;
	l = -1;
	lno++;
	cs = SKIP;

	return;
}


asym()
{
	int	i;
	char	*p;

	if(cs == COLLECT) {
		if(cross) {
			p = temp[t1].beg;
			cursl = &line[l] - p;
			cursl = cursl>8?8:cursl;
			i = -1;
			while(++i < cursl)
				curs[i] = *p++;
			if(cursl < 8)
				curs[cursl++] = '\t';
			else
				curs[cursl++] = -1;
		}
		save();
	}
	cs = SKIP;
}

asw()
{
	switch(gch[fl]) {

		case 0:
			if(cs == COLLECT)	save();
			cs = SKIP;
			flag[++fl] = &asw;
			gch[fl] = c;
			return(1);

		case '\'':
			if(c == '\\') {
				gch[fl] = c;
				return(1);
			}
			break;

		case '"':
			gch[fl] = '\'';

			if(c == '\\') {
				flag[++fl] = &asw;
				gch[fl] = c;
				return(1);
			}
			return(1);

		case '<':
			if(c == '\n')	out();
			if(c == '\\') {
				flag[++fl] = &asw;
				gch[fl] = c;
				return(1);
			}
			if(c != '>')	return(1);
			break;

		case '/':
			if(c != '\n')	return(1);

		case '\\': 
			if(c == '\n')	out();

	}
	fl--;
	return(1);

}

csw()
{
	if(cs == COLLECT)	save();

	switch(gch[fl]) {

		case 0:
			if(c == '*')
				if(line[l - 1] != '/')
					return(1);
			gch[++fl] = c;
			flag[fl] = &csw;
			return(1);

		case '*':
			if(c == '\n')	out();
			if(c == '/' && line[l - 1] == '*')
				break;
			return(1);

		case '\'':
		case '"':
			if(c == gch[fl])
				break;
			if(c == '\\') {
				gch[++fl] = c;
				flag[fl] = &csw;
			}
			return(1);

		case '\\':
			break;
		}
		fl--;
		return(1);
}

incl()
{
/*	printf("incl: l = %d hl = %d dl = %d\n",level,hlevel,dlevel);/*DEBUG*/
	if(cs == COLLECT)	save();
	if(hlevel) {
		hlevel = 0;
		level++;
	} else {
		dlevel++;
	}

	cs = SKIP;
}

decl()
{
/*	printf("decl: l = %d hl = %d dl = %d\n",level,hlevel,dlevel);/*DEBUG*/
	if(cs == COLLECT)	save();
	cs = SKIP;
	if(dlevel) {
		dlevel--;
		return;
	}
	if(--level > 0)	return;
	curs[0] = '_';
	curs[1] = '\t';
	cursl = 2;
	level = 0;
	return;
}

csym()
{
	int	i;
	char	*p;

/*	printf("csym: l = %d hl = %d dl = %d\n",level,hlevel,dlevel);/*DEBUG*/
/*	printf("%s\n", temp[t1].beg);	/*DEBUG */
	p = temp[t1].beg;
	if(cs == COLLECT && level == 0) {
		if(cross) {
			cursl = temp[t1].ct;
			cursl = cursl>8?8:cursl;
			i = -1;
			while(++i < cursl)
				curs[i] = *p++;
			if(cursl < 8)
				curs[cursl++] = '\t';
			else
				curs[cursl++] = -1;
		}
		hlevel = 1;
	}
	cs = SKIP;
}

dfile(a)
	char	*a;
{
	if(*a < 'c')	return(0);
	if(*a < 'h')	return(1);
	if(*a < 'r')	return(2);
	return(3);
}


sk2()
{
	cs = SKIP2;
}

sk()
{
	cs = SKIP;
}

tabs()
{
	if(l == 0)	l = -1;
}


search(symbol,length,params,install)
	char	*symbol;
	int	length;
	struct	htab	*params;
	int	install;
{
	char	*sp,*p;
	static	int	curb,*hptr,hsiz,nsym,ssiz;
	static	char	*symt;
	auto	h,i,j,k;

	if(hptr != params->hptr) {
		hptr = params->hptr;
		hsiz = params->hsiz;
		symt = params->symt;
		ssiz = params->ssiz;
		curb = params->curb;
		nsym = params->nsym;
	}

	symbol[length] = '\0';
	sp = symbol;

	i = length;
	h = 1;
	while(i--)
		h =* *sp++;

	if(h == 0100000) {
		h = 1;
	} else {
		h = h<0?(-h)%hsiz:h%hsiz;
	}
	if(h == 0)	h++;
/*		printf("%s %d\n",symbol,h);	/*DEBUG*/

	while((p = &symt[hptr[h]]) > symt) {
		j = length + 2;
		sp = symbol;
		while(--j) {
			if(*p++ != *sp++)	goto no;
		}
		return(*p);
no:
		h = (h + h)%hsiz;
	}
	if(install) {
		if(++nsym >= hsiz) {
			printf("Too many symbols.\n");
			dexit();
		}

		hptr[h] = curb;
		length++;
		if((curb + length) >= ssiz) {
			printf("Too many characters in symbols.\n");
			dexit();
		}

		while(length--)
			symt[curb++] = *symbol++;
		symt[curb++] = install;
		params->curb = curb;
		params->nsym = nsym;
	}
	return(0);
}

conf(n,width,buf) 
	char	*buf;
{
	auto	i,a;

	i = width;
	while(i--)	buf[i] = ' ';

	buf[(a = n/10)?conf(a,--width,buf):--width] = n%10 + '0';

	return(++width);
}


comp(a,b)
	char	*a;
	char	*b;
{
	a--;
	b--;
	while(*++a == *++b)
		if(*a == '\0')	return(1);
	return(0);
}

semi()
{
	if(cs == COLLECT)	save();
	if(only)	return;
	xtrn = 0;
	if(!level) {
		ssw = 0;
		if(!type) {
			hlevel = 0;
			curs[0] = '_';
			curs[1] = '\t';
			cursl = 2;
		}
		type = 0;
	}
	cs = SKIP;
}

wspace()
{
	if(c == ' ' || c == '\t')
		return(1);
	sav1();
	fl--;
	return(0);
}

=asym          
  .
..
r0
r1
r2
r3
r4
r5
sp
pc
csw
mov
movb
cmp
cmpb
bit
bitb
bic
bicb
bis
bisb
add
sub
br
bne
beq
bge
blt
bgt
ble
bpl
bmi
bhi
blos
bvc
bvs
bhis
bec
bcc
blo
bcs
bes
jbr
jne
jeq
jge
jlt
jgt
jle
jpl
jmi
jhi
jlos
jvc
jvs
jhis
jec
jcc
jlo
jcs
jes
clr
clrb
com
comb
inc
incb
dec
decb
neg
negb
adc
adcb
sbc
sbcb
tst
tstb
ror
rorb
rol
rolb
asr
asrb
asl
aslb
jmp
swab
jsr
rts
sys
clc
clv
clz
cln
sec
sev
sez
sen
cfcc
setf
setd
seti
setl
clrf
negf
absf
tstf
movf
movif
movfi
movof
movfo
addf
subf
mulf
divf
cmpf
modf
movie
movei
ldfps
stfps
fr0
fr1
fr2
fr3
fr4
fr5
als
alsc
mpy
mul
div
ash
ashc
dvd
xor
sxt
mark
sob
.byte
.even
.if
.endif
.globl
.text
.data
.bss
.comm
atable        
  skip
collect save
skip2 sk

cont coll save out asym agobl csym cgobl incl decl sk2 sk

collect/'/agobl;
collect/"/agobl;
collect/</agobl;
collect/\//agobl;
collect/\\/agobl;
collect/:/asym;
collect/a/cont;
collect/b/cont;
collect/c/cont;
collect/d/cont;
collect/e/cont;
collect/f/cont;
collect/g/cont;
collect/h/cont;
collect/i/cont;
collect/j/cont;
collect/k/cont;
collect/l/cont;
collect/m/cont;
collect/n/cont;
collect/o/cont;
collect/p/cont;
collect/q/cont;
collect/r/cont;
collect/s/cont;
collect/t/cont;
collect/u/cont;
collect/v/cont;
collect/w/cont;
collect/x/cont;
collect/y/cont;
collect/z/cont;
collect/A/cont;
collect/B/cont;
collect/C/cont;
collect/D/cont;
collect/E/cont;
collect/F/cont;
collect/G/cont;
collect/H/cont;
collect/I/cont;
collect/J/cont;
collect/K/cont;
collect/L/cont;
collect/M/cont;
collect/N/cont;
collect/O/cont;
collect/P/cont;
collect/Q/cont;
collect/R/cont;
collect/S/cont;
collect/T/cont;
collect/U/cont;
collect/V/cont;
collect/W/cont;
collect/X/cont;
collect/Y/cont;
collect/Z/cont;
collect/1/cont;
collect/2/cont;
collect/3/cont;
collect/4/cont;
collect/5/cont;
collect/6/cont;
collect/7/cont;
collect/8/cont;
collect/9/cont;
collect/0/cont;
collect/./cont;
collect/_/cont;
collect/
/out;
skip/'/agobl;
skip/"/agobl;
skip/</agobl;
skip/\//agobl;
skip/\\/agobl;
skip/
/out;
skip/./coll;
skip/_/coll;
skip/a/coll;
skip/b/coll;
skip/c/coll;
skip/d/coll;
skip/e/coll;
skip/f/coll;
skip/g/coll;
skip/h/coll;
skip/i/coll;
skip/j/coll;
skip/k/coll;
skip/l/coll;
skip/m/coll;
skip/n/coll;
skip/o/coll;
skip/p/coll;
skip/q/coll;
skip/r/coll;
skip/s/coll;
skip/t/coll;
skip/u/coll;
skip/v/coll;
skip/w/coll;
skip/x/coll;
skip/y/coll;
skip/z/coll;
skip/A/coll;
skip/B/coll;
skip/C/coll;
skip/D/coll;
skip/E/coll;
skip/F/coll;
skip/G/coll;
skip/H/coll;
skip/I/coll;
skip/J/coll;
skip/K/coll;
skip/L/coll;
skip/M/coll;
skip/N/coll;
skip/O/coll;
skip/P/coll;
skip/Q/coll;
skip/R/coll;
skip/S/coll;
skip/T/coll;
skip/U/coll;
skip/V/coll;
skip/W/coll;
skip/X/coll;
skip/Y/coll;
skip/Z/coll;
skip/0/sk2;
skip/1/sk2;
skip/2/sk2;
skip/3/sk2;
skip/4/sk2;
skip/5/sk2;
skip/6/sk2;
skip/7/sk2;
skip/8/sk2;
skip/9/sk2;
skip2/a/cont;
skip2/b/cont;
skip2/c/cont;
skip2/d/cont;
skip2/e/cont;
skip2/f/cont;
skip2/g/cont;
skip2/h/cont;
skip2/i/cont;
skip2/j/cont;
skip2/k/cont;
skip2/l/cont;
skip2/m/cont;
skip2/n/cont;
skip2/o/cont;
skip2/p/cont;
skip2/q/cont;
skip2/r/cont;
skip2/s/cont;
skip2/t/cont;
skip2/u/cont;
skip2/v/cont;
skip2/w/cont;
skip2/x/cont;
skip2/y/cont;
skip2/z/cont;
skip2/A/cont;
skip2/B/cont;
skip2/C/cont;
skip2/D/cont;
skip2/E/cont;
skip2/F/cont;
skip2/G/cont;
skip2/H/cont;
skip2/I/cont;
skip2/J/cont;
skip2/K/cont;
skip2/L/cont;
skip2/M/cont;
skip2/N/cont;
skip2/O/cont;
skip2/P/cont;
skip2/Q/cont;
skip2/R/cont;
skip2/S/cont;
skip2/T/cont;
skip2/U/cont;
skip2/V/cont;
skip2/W/cont;
skip2/X/cont;
skip2/Y/cont;
skip2/Z/cont;
skip2/0/cont;
skip2/1/cont;
skip2/2/cont;
skip2/3/cont;
skip2/4/cont;
skip2/5/cont;
skip2/6/cont;
skip2/7/cont;
skip2/8/cont;
skip2/9/cont;
skip2/
/out;
skip2/\//agobl;
ccmn.c        
  uint	nocont;
struct	tempent {
		char	*beg;
		int	ct;
		char	term;
	} temp[30];

char	lbuf[5];
int	cflag;
int	t1;

int	level;
int	hlevel;
int	dlevel;
int	xtrn;

int	tp[5];

struct	{
		int	cl[NUMC];
	} tab[NUMS];

int	coll();
int	save();
int	out();
int	asym();
int	asw();
int	csym();
int	csw();
int	incl();
int	decl();
int	sk2();
int	sk();
int	tabs();
int	semi();

char	line[132];
int	l;
int	lno;
char	c;
int	cursl;
char	curs[9];
int	curfl;
char	curf[10];

int	usw;
int	xsw;
int	only;
int	cross;
int	file;
int	cs;
int	(*flag[8])();
int	fl;
char	gch[8];

struct	htab	{
		int	hsiz;
		int	ssiz;
		int	nsym;
		int	curb;
		int	*hptr;
		char	*symt;
		};

struct	htab	itab;
struct	htab	xtab;

int	ipsp[PTRI];
char	issp[CHARI];
int	xpsp[PTRX];
char	xssp[CHARX];

int	ib1[259];
int	ib2[259];

char	*ibuf;
char	*ibuf1;
char	*ibuf2;

char	mone;
int	single;
int	order;
int	ssw;
int	type;
char	*utmp;
3crpost.c      
  
/*int	mbuf[1024];	/*INSTR*/
int	ig	100;
int	esw;
int	initf	1;
char	ssp[270];
char	*sym[9]	{ssp,
		ssp + 30,
		ssp + 60,
		ssp + 90,
		ssp + 120,
		ssp + 150,
		ssp + 180,
		ssp + 210,
		ssp + 240
		};

main(argc, argv)
	char	*argv[];
{
	auto	f,fct,file,i;

	if(argc < 2) {
		printf("Usage: crpost [-d] file1 file2 ...\n");
		exit();
	}

	if(*argv[1] == '-') {
		if(argv[1][1] == 'E') {
			fct = argv[1][2] - '0';
			esw = 1;
			goto on;
		}
		fct = argv[1][1] - '0';
		if((fct < 1) || (fct > 9)) {
			printf("-d: 0 < d < 10\n");
			exit();
		}
		if(argv[1][2] == 'x') {
			ig = fct-1;
		}
on:
		argv++;
		argc--;
	} else {
		fct = 3;
	}

	f = 0;
	while(++f < argc) {
		file = open(argv[f], 0);

		edf(file, fct);

		close(file);
	}
	flsh(1);

	exit();
}

int	lno	1;

edf(file, fct)
{
	auto	i,j,l;
	extern	lno,etext;
	char	brk,*buf,bufsp[150],line[150];
	char extern	*sym[];

/*	monitor(&main,&etext,&mbuf,1024);	/*INSTR*/
	for(i = 0; i < fct; i++)
		*sym[i] = 0200;
fields:
	l = -1;
	buf = &bufsp;

	for(i = 0; i < fct; ++i) {
		buf--;

swt:

		switch(*++buf = get(file)) {

			default:
				if(esw && *buf >= 'A' && *buf <= 'Z'
					&& i == 0)
					*buf =| 040;
				goto swt;

			case -1:
				*buf = ' ';
			case '\t':
				if(i == ig)	continue;
				brk = *buf;
				*buf = '\0';
				buf = &bufsp;
				if(comp(buf, sym[i])) {
					if(esw && i == 0) {
						line[0] = line[1] = '\t';
						l = 1;
						goto rest;
					}
					line[++l] = '\t';
					continue;
				} else {
					copy(buf, sym[i]);
					l =+ copy(buf, &line[++l]);
					line[--l] = brk;
					if(l < 8 && esw && i == 0)
						line[++l] = '\t';
					j = i;
					while(++j < fct)
						*sym[j] = 0200;
					continue;
				}

			case '\n':
				lno++;
				brk = *buf;
				*buf = '\0';
				buf = &bufsp;
				if(comp(buf, sym[i])) {
					goto fields;
				} else {
					copy(buf, sym[i]);
					l =+ copy(buf, &line[++l]);
					line[--l] = '\n';
					j = i;
					while(++j < fct)
						*sym[j] = 0;
					goto out;
				}

			case '\0':
				goto fexit;
		}
	}

rest:
	while((line[++l] = get(file)) != '\n')
		if(line[l] == '\0')	goto fexit;

	lno++;
out:
	if(*line != '\t') {
		put(1,"\n",1);
		lno++;
	}

	put(1,line,++l);

	goto fields;

fexit:
/*	monitor(0);	/*INSTR*/
	return(0);

}


copy(a, b)
	char	*a,*b;
{
	char	*c;

	b--;
	c = --a;
	while(*++b = *++a);
	return(a - c);
}

comp(a, b)
	char	*a, *b;
{
/*	printf("comp: %s %s\n",a,b); /*DEBUG*/
	a--;
	b--;
	while(*++a == *++b) {
		if(*a == '\0')	return(1);
	}
	return(0);
}


char	buf[512];
int	nread	1;

get(ifile) int ifile;
{

	char static *ibuf;

	if(--nread){
		return(*ibuf++);
	}

	if(nread = read(ifile,buf,512)){
		if(nread < 0)goto err;

		ibuf = buf;
		return(*ibuf++);
	}

	nread = 1;
	return(0);

err:
	nread = 1;
	printf("read error\n");
	return(0);

}

int	optr;
char	bsp[512];

char	*obuf	bsp;

int	nflush;

put(fil, string, n)
	char	*string;
{
	register int	i;
	register char	*o;

/*printf("%d %c %d\n",fil,*string,n);/*DEBUG*/

	string--;

	if((i = optr + n - 512) >= 0) {
		n =- i;
		o = &obuf[optr] -1;
		while(--n >= 0)
			*++o = *++string;
		optr = 512;
		flsh(fil);
		n = i;
	}

	o = &obuf[optr] - 1;
	optr =+ n;

	while(--n >= 0) {
		*++o = *++string;
	}
	return(0);
}

flsh(fil)
{

	if(optr <= 0)	return(optr);

	nflush++;
	if(write(fil,  obuf, optr) != optr)
		return(-1);
	optr = 0;
	return(0);
}

tcsym          
   auto	5
break	5
case	5
char	4
continue	5
default	5
do	5
double	4
else	5
extern	2
float	4
for	5
goto	5
if	5
int	4
long	4
register	5
return	5
static	5
struct	3
switch	5
while	5
ctable        
  skip
collect save
skip2 sk

cont coll save out asym agobl csym cgobl incl decl sk2 sk tab semi

collect/\;/semi;
collect/_/cont;
collect/{/incl;
collect/}/decl;
collect/'/cgobl;
collect/\\/cgobl;
collect/"/cgobl;
collect/a/cont;
collect/b/cont;
collect/c/cont;
collect/d/cont;
collect/e/cont;
collect/f/cont;
collect/g/cont;
collect/h/cont;
collect/i/cont;
collect/j/cont;
collect/k/cont;
collect/l/cont;
collect/m/cont;
collect/n/cont;
collect/o/cont;
collect/p/cont;
collect/q/cont;
collect/r/cont;
collect/s/cont;
collect/t/cont;
collect/u/cont;
collect/v/cont;
collect/w/cont;
collect/x/cont;
collect/y/cont;
collect/z/cont;
collect/A/cont;
collect/B/cont;
collect/C/cont;
collect/D/cont;
collect/E/cont;
collect/F/cont;
collect/G/cont;
collect/H/cont;
collect/I/cont;
collect/J/cont;
collect/K/cont;
collect/L/cont;
collect/M/cont;
collect/N/cont;
collect/O/cont;
collect/P/cont;
collect/Q/cont;
collect/R/cont;
collect/S/cont;
collect/T/cont;
collect/U/cont;
collect/V/cont;
collect/W/cont;
collect/X/cont;
collect/Y/cont;
collect/Z/cont;
collect/1/cont;
collect/2/cont;
collect/3/cont;
collect/4/cont;
collect/5/cont;
collect/6/cont;
collect/7/cont;
collect/8/cont;
collect/9/cont;
collect/0/cont;
