# include "dextern"
# include "files"

output(){ /* print the output for the states */

	int i, k, c;
	register struct wset *u, *v;

	fprintf( ftable, excfb[lflag] );

	SLOOP(i) { /* output the stuff for state i */
		nolook = !(tystate[i]==MUSTLOOKAHEAD);
		closure(i);
		/* output actions */
		nolook = 1;
		aryfil( temp1, nterms+nnonter+1, 0 );
		WSLOOP(wsets,u){
			c = *( u->pitem );
			if( c>1 && c<NTBASE && temp1[c]==0 ) {
				WSLOOP(u,v){
					if( c == *(v->pitem) ) putitem( v->pitem+1, NULL );
					}
				temp1[c] = state(c);
				}
			else if( c > NTBASE && temp1[ (c =- NTBASE) + nterms ] == 0 ){
				temp1[ c+nterms ] = amem[indgo[i]+c];
				}
			}

		if( i == 1 ) temp1[1] = ACCEPTCODE;

		/* now, we have the shifts; look at the reductions */

		lastred = 0;
		WSLOOP(wsets,u){
			c = *( u->pitem );
			if( c<=0 ){ /* reduction */
				lastred = -c;
				TLOOP(k){
					if( BIT(u->ws,k) ){
						  if( temp1[k] == 0 ) temp1[k] = c;
						  else if( temp1[k]<0 ){ /* reduce/reduce conflict */
						    if( foutput!=NULL )
						      fprintf( foutput,
						        "\n%d: reduce/reduce conflict (red'ns %d and %d ) on %s",
						        i, -temp1[k], lastred, symnam(k) );
						    if( -temp1[k] > lastred ) temp1[k] = -lastred;
						    ++zzrrconf;
						    }
						  else { /* potential shift/reduce conflict */
							precftn( lastred, k, i );
							}
						}
					}
				}
			}
		wract(i);
		}

	fprintf( ftable, excfe[lflag] );

	wdef( "YYNPROD", nprod );

	}

int pkdebug 0;
apack(p, n ) int *p;{ /* pack state i from temp1 into amem */
	int off;
	register *pp, *qq, *rr;
	int *q, *r;

	/* we don't need to worry about checking because we
	   we will only look entries known to be there... */

	/* eliminate leading and trailing 0's */

	q = p+n;
	for( pp=p,off=0 ; *pp==0 && pp<=q; ++pp,--off ) /* VOID */ ;
	if( pp > q ) return(0);  /* no actions */
	p = pp;

	/* now, find a place for the elements from p to q, inclusive */

	r = &amem[actsiz-1];
	for( rr=amem; rr<=r; ++rr,++off ){  /* try rr */
		for( qq=rr,pp=p ; pp<=q ; ++pp,++qq){
			if( *pp != 0 ){
				if( *pp != *qq && *qq != 0 ) goto nextk;
				}
			}

		/* we have found an acceptable k */

		if( pkdebug && foutput!=NULL ) fprintf( foutput, "off = %d, k = %d\n", off, rr-amem );

		for( qq=rr,pp=p; pp<=q; ++pp,++qq ){
			if( *pp ){
				if( qq > r ) error( "action table overflow" );
				if( qq>memp ) memp = qq;
				*qq = *pp;
				}
			}
		if( pkdebug && foutput!=NULL ){
			for( pp=amem; pp<= memp; pp=+10 ){
				fprintf( foutput, "\t");
				for( qq=pp; qq<=pp+9; ++qq ) fprintf( foutput, "%d ", *qq );
				fprintf( foutput, "\n");
				}
			}
		return( off );

		nextk: ;
		}
	error("no space in action table" );
	/* NOTREACHED */
	}

go2out(){ /* output the gotos for the nontermninals */
	int i, j, k, best, count, cbest, times;

	fprintf( ftemp, "$\n" );  /* mark begining of gotos */

	for( i=1; i<=nnonter; ++i ) {
		go2gen(i);

		/* find the best one to make default */

		best = -1;
		times = 0;

		for( j=0; j<=nstate; ++j ){ /* is j the most frequent */
			if( tystate[j] == 0 ) continue;
			if( tystate[j] == best ) continue;

			/* is tystate[j] the most frequent */

			count = 0;
			cbest = tystate[j];

			for( k=j; k<=nstate; ++k ) if( tystate[k]==cbest ) ++count;

			if( count > times ){
				best = cbest;
				times = count;
				}
			}

		/* best is now the default entry */

		zzgobest =+ (times-1);
		for( j=0; j<=nstate; ++j ){
			if( tystate[j] != 0 && tystate[j]!=best ){
				fprintf( ftemp, "%d,%d,", j, tystate[j] );
				zzgoent =+ 1;
				}
			}

		/* now, the default */

		zzgoent =+ 1;
		fprintf( ftemp, "%d\n", best );

		}



	}

int g2debug 0;
go2gen(c){ /* output the gotos for nonterminal c */

	int i, work, cc;
	struct item *p, *q;


	/* first, find nonterminals with gotos on c */

	aryfil( temp1, nnonter+1, 0 );
	temp1[c] = 1;

	work = 1;
	while( work ){
		work = 0;
		PLOOP(0,i){
			if( (cc=prdptr[i][1]-NTBASE) >= 0 ){ /* cc is a nonterminal */
				if( temp1[cc] != 0 ){ /* cc has a goto on c */
					cc = *prdptr[i]-NTBASE; /* thus, the left side of production i does too */
					if( temp1[cc] == 0 ){
						  work = 1;
						  temp1[cc] = 1;
						  }
					}
				}
			}
		}

	/* now, we have temp1[c] = 1 if a goto on c in closure of cc */

	if( g2debug && foutput!=NULL ){
		fprintf( foutput, "%s: got