/*
 * The callout structure is for a routine arranging
 * to be called by the clock interrupt (clock.c)
 * with a specified argument, in a specified amount of time.
 * Used, for example, to time tab delays on typewriters.
 * C-blocks are borrowed from the c-list to store the details,
 * hence the size of this structure must be < (CBSIZE+sizeof(int *)),
 * and NCALL must be (significantly) less than NCLIST.
 * A small reserve (NTFREE) is kept in tfreelist, in case the clist runs out.
 */

struct	timout
{
	struct timout *ti_next;	/* next in list */
	short	ti_time;	/* incremental time */
	caddr_t	ti_arg;		/* argument to routine */
	short	(*ti_func)();	/* routine */
};
