#include <param.h>
#include <systm.h>
#include <inode.h>
#include <dir.h>
#include <signal.h>
#include <user.h>
#include <buf.h>
#include <seg.h>
#include <conf.h>
#include <errno.h>

extern struct user u;
extern char b[];

/*
 * Read the file corresponding to
 * the inode pointed at by the argument.
 * The actual read arguments are found
 * in the variables:
 *	u_base		core address for destination
 *	u_offset	byte offset in file
 *	u_count		number of bytes to read
 *	u_segflg	read to kernel/user/user I
 */
readi(ip)
register struct inode *ip;
{
	struct buf *bp;
	dev_t dev;
	daddr_t lbn, bn;
	off_t diff;
	register on, n;
	register type;

	if (u.u_count == 0)
		return;
	if (u.u_offset < 0)
	{
		u.u_error = EINVAL;
		return;
	}
	ip->i_flag |= IACC;
	dev = getdevno(ip);
	type = ip->i_mode & IFMT;
	if (type==IFCHR)
	{
		return((*cdevsw[major(dev)].d_read)(dev));
	}
	if (type == IFLOK || type == IFALK)
		if (ip != u.u_locki)
		{
			u.u_error = EACCES;
			return;
		}

	do
	{
		lbn = bn = u.u_offset >> BSHIFT;
		on = u.u_offset & BMASK;
		n = min((unsigned)(BSIZE-on), u.u_count);
		if (type!=IFBLK)
		{
			diff = ip->i_size - u.u_offset;
			if (diff <= 0)
				return;
			if (diff < n)
				n = diff;
			bn = bmap(ip, bn, B_READ);
			if (u.u_error)
				return;
			dev = ip->i_dev;
		}
		else
			rablock = bn+1;
		if ((long)bn<0)
		{
			bp = geteblk();
			clrbuf(bp);
		} else if (ip->i_lastr+1==lbn)
			bp = breada(dev, bn, rablock);
		else
			bp = bread(dev, bn);
		ip->i_lastr = lbn;
		n = min((unsigned)n, BSIZE-bp->b_resid);
		if (n!=0)
		{
			ka5->r[0] = baddr(bp);
			iomove(&b[on], n, B_READ);
		}
		if (type == IFIFO && on == 0 && (u.u_offset & 0777) == 0)
		{
			bp->b_flags &= ~B_DELWRI;
			bp->b_flags |= B_AGE;
		}
		brelse(bp);
	} while (u.u_error == 0 && u.u_count != 0 && n > 0);
}

/*
 * Write the file corresponding to
 * the inode pointed at by the argument.
 * The actual write arguments are found
 * in the variables:
 *	u_base		core address for source
 *	u_offset	byte offset in file
 *	u_count		number of bytes to write
 *	u_segflg	write to kernel/user/user I
 */
writei(ip)
register struct inode *ip;
{
	struct buf *bp;
	dev_t dev;
	daddr_t bn;
	register n, on;
	register type;

	if (u.u_offset < 0)
	{
		u.u_error = EINVAL;
		return;
	}
	dev = getdevno(ip);
	type = ip->i_mode&IFMT;
	if (type==IFCHR)
	{
		ip->i_flag |= IUPD|ICHG;
		(*cdevsw[major(dev)].d_write)(dev);
		return;
	}
	if (type == IFLOK || type == IFALK)
		if (ip != u.u_locki && u.u_lockf != L_WLOCK)
		{
			u.u_error = EACCES;
			return;
		}
	if (u.u_count == 0)
		return;

	do
	{
		bn = u.u_offset >> BSHIFT;
		on = u.u_offset & BMASK;
		n = min((unsigned)(BSIZE-on), u.u_count);
		if (type!=IFBLK)
		{
			bn = bmap(ip, bn, B_WRITE);
			if ((long)bn<0)
				return;
			dev = ip->i_dev;
		}
		if (n == BSIZE) 
			bp = getblk(dev, bn);
		else
			bp = bread(dev, bn);
		ka5->r[0] = baddr(bp);
		iomove(&b[on], n, B_WRITE);
		if (u.u_error != 0)
			brelse(bp);
		else
			bdwrite(bp);
		if (u.u_offset > ip->i_size &&
		   (type==IFDIR || type==IFREG || type==IFLOK || type==IFALK))
			ip->i_size = u.u_offset;
		ip->i_flag |= IUPD|ICHG;
	} while (u.u_error == 0 && u.u_count != 0);
}

/*
 * Return the logical maximum
 * of the 2 arguments.
 */
max(a, b)
unsigned a, b;
{

	if (a > b)
		return(a);
	return(b);
}

/*
 * Return the logical minimum
 * of the 2 arguments.
 */
min(a, b)
unsigned a, b;
{

	if (a < b)
		return(a);
	return(b);
}

/*
 * Move n bytes at byte location cp
 * to/from (flag: B_READ or B_WRITE) the
 * user/kernel (u_segflg) area starting at u_base.
 * Update all the arguments by the number
 * of bytes moved.
 *
 * There are 2 algorithms,
 * if source address and dest address
 * are all even in a user copy,
 * then the machine language copyin/copyout
 * is called.
 * If not, its done byte-by-byte with
 * cpass and passc.
 */
iomove(cp, n, flag)
register caddr_t cp;
register n;
{
	register t;

	if (n==0)
		return;
	if (u.u_segflg != KERND && n >= NBPW &&
	  ((int)cp&(NBPW-1)) == 0 && ((int)u.u_base&(NBPW-1)) == 0)
	{
		char odd;

		odd = n & (NBPW-1);
		n &= ~(NBPW-1);
		if (flag==B_WRITE)
			if (u.u_segflg==USERD)
				t = copyin(u.u_base, (caddr_t)cp, n);
			else
				t = copyiin(u.u_base, (caddr_t)cp, n);
		else
			if (u.u_segflg==USERD)
				t = copyout((caddr_t)cp, u.u_base, n);
			else
				t = copyiout((caddr_t)cp, u.u_base, n);
		if (t)
		{
			u.u_error = EFAULT;
			return;
		}
		u.u_base += n;
		u.u_offset += n;
		u.u_count -= n;
		if (odd == 0)
			return;
		cp += n;
		n = odd;
	}
	if (flag==B_WRITE)
	{
		do
		{
			if ((t = cpass()) < 0)
				return;
			*cp++ = t;
		} while (--n);
	}
	else
		do
		{
			if (passc(*cp++) < 0)
				return;
		} while (--n);
}
