/ Header for standalone programs that knows most things that are of interest
/ and sets up various things appropriately

	UBMAP	= 170200	/ 31 4-byte registers up to 170372
	SID0	= 172200	/ 8 2-byte registers up to 172216
	SDD0	= 172220	/ 		"	   172236
	SIA0	= 172240	/ 		"	   172256
	SDA0	= 172260	/ 		"	   172276
	KID0	= 172300	/ 		"	   172316
	KDD0	= 172320	/ 		"	   172336
	KIA0	= 172340	/ 		"	   172356
	KDA0	= 172360	/ 		"	   172376
	MMR3	= 172516
	KWPCS	= 172540
	KWPCNT	= 172542
	KWPCNTR	= 172544
	KWL	= 177546
	DLRCS	= 177560
	DLRBF	= 177562
	DLXCS	= 177564
	DLXBF	= 177566
	CSW	= 177570
	MMR0	= 177572
	MMR1	= 177574
	MMR2	= 177576
	UID0	= 177600	/ 8 2-byte registers up to 177616
	UDD0	= 177620	/ 		"	   177636
	UIA0	= 177640	/ 		"	   177656
	UDA0	= 177660	/ 		"	   177676
	MEMLO	= 177740
	MEMHI	= 177742
	MEMERR	= 177744
	MEMCR	= 177746
	MEMSZ	= 177760
	SYSID	= 177764
	CPUERR	= 177766
	PIR	= 177772
	SLR	= 177774
	PS	= 177776

	jmp	1000
		006; 0; 012; 0; 016; 0; 022; 0; 026; 0; 032; 0; 036; 0;
	042; 0; 046; 0; 052; 0; 056; 0; 062; 0; 066; 0; 072; 0; 076; 0;
	102; 0; 106; 0; 112; 0; 116; 0; 122; 0; 126; 0; 132; 0; 136; 0;
	142; 0; 146; 0; 152; 0; 156; 0; 162; 0; 166; 0; 172; 0; 176; 0;
	202; 0; 206; 0; 212; 0; 216; 0; 222; 0; 226; 0; 232; 0; 236; 0;
	242; 0; 246; 0; 252; 0; 256; 0; 262; 0; 266; 0; 272; 0; 276; 0;
	302; 0; 306; 0; 312; 0; 316; 0; 322; 0; 326; 0; 332; 0; 336; 0;
	342; 0; 346; 0; 352; 0; 356; 0; 362; 0; 366; 0; 372; 0; 376; 0;
	402; 0; 406; 0; 412; 0; 416; 0; 422; 0; 426; 0; 432; 0; 436; 0;
	442; 0; 446; 0; 452; 0; 456; 0; 462; 0; 466; 0; 472; 0; 476; 0;
	502; 0; 506; 0; 512; 0; 516; 0; 522; 0; 526; 0; 532; 0; 536; 0;
	542; 0; 546; 0; 552; 0; 556; 0; 562; 0; 566; 0; 572; 0; 576; 0;
	602; 0; 606; 0; 612; 0; 616; 0; 622; 0; 626; 0; 632; 0; 636; 0;
	642; 0; 646; 0; 652; 0; 656; 0; 662; 0; 666; 0; 672; 0; 676; 0;
	702; 0; 706; 0; 712; 0; 716; 0; 722; 0; 726; 0; 732; 0; 736; 0;
	742; 0; 746; 0; 752; 0; 756; 0; 762; 0; 766; 0; 772; 0; 776; 0;

	mov	2, 0
	clr	2
	reset
	clr	PS
	clr	CPUERR
	mov	$-1, MEMERR
	mov	$1000, sp

printall:
	mov	r0, -(sp)
	jsr	pc, print
	mov	r1, r0
	jsr	pc, print
	mov	r2, r0
	jsr	pc, print
	mov	r3, r0
	jsr	pc, print
	mov	r4, r0
	jsr	pc, print
	mov	r5, r0
	jsr	pc, print
	mov	sp, r0
	add	$6., r0		/ step over r0 pc ps
	jsr	pc, print
	mov	2(sp), r0	/ saved pc
	jsr	pc, print
	mov	4(sp), r0	/ saved ps
	jsr	pc, print
	mov	$'\r, r0
	jsr	pc, putc
	mov	$'\n, r0
	jsr	pc, putc
	mov	(sp)+, r0
	rtt

print:				/ print out number in r0
	mov	r1, -(sp)
	mov	r2, -(sp)
	mov	r0, r1		/ safe keeping
	mov	$6, r2
	mov	$' , r0		/ space
	jsr	pc, putc
	mov	$'0, r0
	asl	r1
	bcc	0f
	inc	r0
	br	0f
1:
	clr	r0
	ashc	$3, r0		/ top 3 bits from r1 into r0
	add	$'0, r0
0:
	jsr	pc, putc
	sob	r2, 1b

	mov	(sp)+, r2
	mov	(sp)+, r1
	rts	pc

tks	= 177564
tkb	= 177566

putc:
	tstb	tks
	bge	putc
	mov	r0, tkb
	rts	pc
