/*
**	Updates the long that "te" points to with the seek address
**	 for the new entry. The new entry is written from "pe".
**	Returns the sum of variable length string fields written or
**	 PWERROR for error.
*/ 

#include	<pwr.h>

extern long lseek();

addentry(pe, te)
	register struct pwent *pe;
	register long *te;
{
	register i;

	char *strings[PWSLENCNT];
	register int total;

	for(i = 0; i < PWSLENCNT; i++)
	{
		strings[i] = pe->pw_strings[i];
		pe->pw_strings[i] = (char *)(strlen(strings[i])+1);
	}

	/*	pointers saved and changed to counts in "pe" */ 

	*te = lseek(pwfd, (long)0, 2);

	/*	ready to write */ 

	if(write(pwfd, (char *)pe, PWENTLEN) != PWENTLEN)
		return(PWERROR);

	total = 0;
	for(i = 0; i < PWSLENCNT; i++)
		if(write(pwfd, strings[i], (int)pe->pw_strings[i]) != (int)pe->pw_strings[i])
			return(PWERROR);
		else
			total += (int)pe->pw_strings[i];

	/*	all written, restore pointers to be nice	*/ 

	for(i = 0; i < PWSLENCNT; i++)
		pe->pw_strings[i] = strings[i];

	/*	now return count	*/ 

	return(total);
}
