/*
**	Wall - broadcast command
*/

#include	<local-system>
#include	<signal.h>
#include	<setjmp.h>
#include	<sys/fcntl.h>
#include	<utmp.h>

struct	utmp	utmp[256];
char		utmpf[]		= UTMPF;

char		mesg[3000];
int		msize;

char		dev[]		= "/dev/";

jmp_buf		toutbuf;
int		timeout();


main(argc, argv)
	char *		argv[];
{
	register	i;
	register	usize;
	register	f;

	if ( (f = open(utmpf, O_READ)) == SYSERROR )
	{
		perror(utmpf);
		return 1;
	}

	usize = read(f, utmp, sizeof utmp)/sizeof utmp[0];
	close(f);

	if(argc >= 2)
	{
		if ( (f = open(argv[1], O_READ)) == SYSERROR )
		{
			perror(argv[1]);
			return 1;
		}
	}
	else
		f = 0;	/* stdin */

	while((i = read(f, &mesg[msize], sizeof mesg - msize)) > 0)
	{
		if ( i == 2 && mesg[msize] == '.' )
			break;
		msize += i;
	}

	if ( f )
		close(f);

	switch ( fork() )
	{
	 case SYSERROR:
		perror("fork");
		break;

	 default:
		return 0;

	 case 0:
		;
	}

	signal(SIGALRM, timeout);

	for(i=0; i<usize; i++)
	{
		if(utmp[i].ut_line[0] == 0)
			continue;
		sendmes(utmp[i].ut_line);
	}

	return 0;
}

sendmes(tty)
	char *		tty;
{
	register	f;
	char		devtty[sizeof dev + LINESIZ + 1];

	strncat(strcpy(devtty, dev), tty, LINESIZ);

	if ( setjmp(toutbuf) )
		return;

	alarm(5);

	if ( (f = open(devtty, O_WRITE)) == SYSERROR )
	{
		perror(devtty);
		alarm(0);
		return;
	}

	write(f, "\n\n\007\007\007elec70 Broadcast Message ...\n\n", 37);
	write(f, mesg, msize);
	write(f, "\n", 1);
	close(f);

	alarm(0);
	return;
}


timeout()
{
	signal(SIGALRM, timeout);
	longjmp(toutbuf, 1);
}
