/*
 *	Su -- set user id
 *
 *	su [lname | uid]
 *
 *	Sets your uid and limits to that of the username or integer given.
 *	The password of root is requested.
 */

#include	<local-system>
#include	<passwd.h>
#include	<signal.h>
#include	<fcntl.h>
#include	<sgtty.h>
#include	<wtmp.h>

short		interrupted;
char		password[PASSWDZ];
struct	pwent	pe,tpe;
char		wtmpf[]		= WTMPF;
struct sgttyb	ttybuf;
char		su[16]		= "-SU";
char		shell[]		= "/bin/sh";

extern char *	strrchr();

#define		NULLSTR		(char *)0
#define		STREQUAL	0




main(c, v)
int c;
char **v;
{
	register char *p;
	register struct pwent *pp;
	short uid;
	short newuid;
	char buf[SSIZ];
	int intcatch();

	signal(SIGQUIT, SIG_IGN);
	if (c != 1 && c != 2)
	{
		printf("Usage: su [lname | uid]\n");
		exit(1);
	}
	uid = getuid();
	pe.pw_limits.l_uid = 0;
	if (getpwlog(&pe, buf, SSIZ) == PWERROR)
	{
		printf("Bad password file\n");
		exit(1);
	}
	if (c > 1)
	{
		tpe.pw_strings[LNAME] = v[1];
		if (getpwuid(&tpe, buf, SSIZ) == PWERROR)
		{
			tpe.pw_limits.l_uid = atoi(v[1]);
			if (getpwlog(&tpe, (char *)0, 0) == PWERROR)
			{
				printf("Who?\n");
				exit(1);
			}
		}
		pp = &tpe;
	}
	else
		pp = &pe;

	pwclose();

	p = pe.pw_pword;
	newuid = pp->pw_limits.l_uid;
	if (*p != 0 && uid >= 1)
	{
		register	count;
		register char	*q;
		short		oflags;
		extern char *	crypt();

		gtty(0, &ttybuf);
		signal(SIGINT, intcatch);
		if ((oflags = ttybuf.sg_flags) & ECHO)
		{
			ttybuf.sg_flags &= ~ECHO;
			stty(0, &ttybuf);
		}
		printf("password: ");
		if ((count = read(0,password,sizeof password - 1)) <= 1)
			password[0] = '\0';
		else
			password[count - 1] = '\0';	/* clobber the \n */
		if (oflags & ECHO)
		{
			ttybuf.sg_flags = oflags;
			stty(0, &ttybuf);
		}
		printf("\n");
		signal(SIGINT, SIG_IGN);
		if (interrupted)
			exit(1);
		q = crypt(password, pe.pw_pword);
		if (strncmp(q, p, CRYPTLEN) != 0)
		{
			printf("Sorry\n");
			exit(1);
		}
	}
	{
		struct sutmp	safe;
		register	fd;

		safe.su_type = SU_TYPE;
		safe.su_olduid = uid;
		safe.su_newuid = newuid;
		time(&safe.su_usetime);
		if ((fd = open(wtmpf, O_WRITE|O_APPEND)) != SYSERROR)
		{
			write(fd, (char *)&safe, sizeof safe);
			close(fd);
		}
	}
	if (limits(&pp->pw_limits, L_SETLIM) == SYSERROR)
	{
		perror("No limits!");
		exit(1);
	}
	setgid(pp->pw_gid);
	setuid(newuid);
	{
		extern char **environ;
		register char **ep;
		static char ps1[] = "PS1=% ";
		static char rootps1[] = "PS1=# ";
		static char path[] = "PATH=:/bin";
		static char rootpath[] = "PATH=/etc/bin:/bin";
		static char home[64] = "HOME=";

		for (ep = environ ; *ep != NULLSTR ; ep++)
			if (strncmp(ps1, *ep, 4) == STREQUAL)
				*ep = newuid ? ps1 : rootps1;
			else if (strncmp(path, *ep, 5) == STREQUAL)
				*ep = newuid ? path : rootpath;
			else if (strncmp(home, *ep, 5) == STREQUAL)
			{
				strcat(home, pp->pw_strings[DIRPATH]);
				*ep = home;
			}
	}

	signal(SIGINT, SIG_DFL);
	signal(SIGQUIT, SIG_DFL);
	{
		register char *	psh;

		if (pp->pw_strings[SHELLPATH][0] != '\0')
		{
			psh = pp->pw_strings[SHELLPATH];
			strcpy(su, "-");
			strcat(su, strrchr(psh, '/')+1);
		}
		else
			psh = shell;

		execl(psh, su, 0);
		perror(psh);
		exit(1);
	}
}

intcatch()
{
	signal(SIGINT, SIG_IGN);
	interrupted++;
}
