/*
 *	This program packs its standard input onto its standard output.
 *	The output must be seekable.
 */

#include	<stdio.h>
#include	"pac.h"

struct node
{
	char name[FSIZE + 1];	/* room for final null; free if name[0] null */
	long addr;		/* address of other paths at same level */
}
	nodes[NNODES];

char	wordbuf[FSIZE + 1];	/* current pathname component */
int	lines;			/* input line counter */
long	currentlength;		/* contains size of file as it is written */
char	obuf[512];		/* output buffer */
char	*nextp;			/* points to first free spot in obuf */
char	ignore;			/* just ignore incorrect input */


main(argc, argv)
int	argc;
char	**argv;
{
	if (argc == 2 && strcmp(argv[1], "-") == 0)
	{
		ignore++;
		argc--;
	}
	if (argc != 1)
	{
		fprintf(stderr, "Usage: pac [-]\n");
		exit(1);
	}
	nextp = obuf;
	currentlength = sizeof rootaddr;
	lseek(1, (long)sizeof rootaddr, 0);	/* leave room */
	scantree();
	if (nextp != obuf)
		write(1, obuf, nextp - obuf);
	if (fromslash)
		rootaddr.hi_word.hi_byte = 0377;
	/*
	 * must now prepend root node address
	 */
	lseek(1, 0L, 0);
	write(1, &rootaddr, sizeof rootaddr);
	exit(0);
}

scantree()
{
	register char *cp;
	register struct node *end, *p;
	char *getword();
	long freeup();

	end = &nodes[NNODES];
	for (;;)		/* for each line .... */
	{
		lines++;
		p = nodes;
		cp = pathbuf;
		while ((*cp = getchar()) != '\n')
		{
			if (*cp == EOF)		/* end of file */
			{
				rootaddr = freeup(nodes);
				return;
			}
			cp++;
		}
		if (cp == pathbuf)
			continue;
		while (*--cp == '/' && cp > pathbuf);
		cp[1] = 0;		/* amputate trailing slashes */
		cp = pathbuf;
		if (lines == 1)
			fromslash = *cp == '/';
		else
		{
			if (fromslash && *cp != '/')
			{
				if (ignore)
					continue;
				error("does not have leading /");
			}
			if (fromslash == 0 && *cp == '/')
			{
				if (ignore)
					continue;
				error("has leading /");
			}
		}
		for (;;)	/* for each directory component .... */
		{
			if (*cp == 0)		/* end of line */
				break;
			cp = getword(cp);
			if (wordbuf[0] != 0 && (p->name[0] == 0 ||
			    (strcmp(p->name, wordbuf) != 0)))
			{
				p->addr = freeup(p);
				strcpy(p->name, wordbuf);
			}
			if (++p >= end)
				error("too many levels");
		}
	}
}

char *
getword(cp)
register char *cp;
{
	register char *wp;

	wp = wordbuf;
	while (*cp == '/')
		cp++;
	while ((*wp = *cp++) && *wp != '/')
		if (wp++ == &wordbuf[sizeof wordbuf])
			error("filename too long");
	*wp = 0;
	return(cp - 1);
}

error(s)
char *s;
{
	fprintf(stderr, "Line %d: %s\n", lines, s);
	exit(1);
}

/*
 * freeup writes out the node path passed to it,
 * and returns its address in the file
 */
long
freeup(p)
register struct node *p;
{
	long saddr, lastaddr;

	if (p->name[0] == 0)		/* node is free */
		return(0L);
	saddr = freeup(p + 1);	/* recursively descend and free the lot */
	lastaddr = currentlength;
	putout(p->name, p->addr, saddr);
	p->name[0] = 0;			/* mark the node as unused */
	return(lastaddr);
}

putout(nme, link, subdir)
register char	*nme;
long	link;
long	subdir;
{
	register char	*p;
	register short	flag;

	flag = 0;
	for (p = nme; *p; p++)
		flag++;
	if (link.hi_word)
		flag |= (LSTNODE | LONGLST);
	else if (link.lo_word)
		flag |= LSTNODE;
	if (subdir.hi_word)
		flag |= (DIRNODE | LONGDIR);
	else if (subdir.lo_word)
		flag |= DIRNODE;
	putachar(flag);
	putl(link);
	putl(subdir);
	while (*nme)
		putachar(*nme++);
}

putl(l)
long l;
{
	if (l == 0L)
		return;
	if (l.hi_word)
		putachar(l.hi_word);
	putachar(l.lo_word.hi_byte);
	putachar(l.lo_word.lo_byte);
}

putachar(ch)
register char ch;
{
	currentlength++;
	if (nextp == &obuf[sizeof obuf])
	{
		write(1, obuf, sizeof obuf);
		nextp = obuf;
	}
	*nextp++ = ch;
}
