/*
 *	mtabin
 *
 *	Initialize "mtab" file with an entry for '/'
 *	with a device name found in '/dev'
 */

#include	<mtab.h>
#include	<sys/stat.h>

struct	mtab mtab;
char mtabf[] = MTABF;
char	devd[]	"/dev/xxxxxxxxxxxxxx";

main()
{
	register struct mtab *mp;
	struct	stat	sb;
	register int mf;

	mp = &mtab;
	mp->m_file[0] = '/';
	stat(mp->m_file, &sb);
	strcpy(mp->m_spec, dsearch(sb.st_dev));
	mp->m_prot = 0;
	if ((mf = creat(mtabf, 0644)) == -1)
	{
		perror(mtabf);
		exit(1);
	}
	write(mf, mp, sizeof mtab);
	exit(0);
}

dsearch(device)
register int device;
{
	struct stat sb;
	static char buf[18];
	register int df, *bp;

	bp = buf;
	if ((df = open("/dev", 0)) == -1)
	{
		perror("/dev");
		return(0);
	}
	while (read(df, bp, 16) == 16)
	{
		if (*bp && strcmp(bp+1, "swap") != 0)
		{
			devd[5] = 0;
			stat(strcat(devd, bp+1), &sb);
			if ((sb.st_mode & S_IFMT) == S_IFBLK &&
			    sb.st_rdev == device)
			{
				close(df);
				return(bp + 1);
			}
		}
	}
	close(df);
	return(0);
}
