/*
 *
 *	UNIX debugger
 *
 */

#include "defs.h"


char		NOEOR[];

int		mkfault;
int		executing;
int		infile;
char		*lp;
int		maxoff;
int		maxpos;
int		sigint;
int		sigqit;
int		wtflag;
long int	maxfile;
long int	maxstor;
long int	txtsiz;
long int	datsiz;
long int	datbas;
long int	stksiz;
char		*errflg;
int		exitflg;
int		magic;
long int	entrypt;

char		lastc;
int		eof;

int		lastcom;
long int	var[36];
char		*symfil;
char		*corfil;
char		printbuf[];
char		*printptr;


long int
round(a, b)
long int a, b;
{
	long int w;

	w = ((a + b - 1) / b) * b;
	return(w);
}

/*
 * error handling
 */
chkerr()
{
	if (errflg || mkfault)
		error(errflg);
}

error(n)
char *n;
{
	errflg = n;
	iclose();
	oclose();
	longjmp(erradb, 1);
}

fault(a)
{
	signal(a, fault);
	lseek(infile, 0L, 2);
	mkfault++;
}

/*
 * set up files and initial address mappings
 */
int argcount;

main(argc, argv)
register char **argv;
register int argc;
{
	maxfile = 1L << 24;
	maxstor = 1L << 16;
	gtty(0, &adbtty);
	gtty(0, &usrtty);
	while (argc > 1)
	{
		if (eqstr("-w", argv[1]))
		{
			wtflag = 2;
			argc--;
			argv++;
		}
		else
			break;
	}
	if (argc > 1)
		symfil = argv[1];
	if (argc > 2)
		corfil = argv[2];
	argcount = argc;
	setsym();
	setcor();
	/*
	 * set up variables for user
	 */
	maxoff = MAXOFF;
	maxpos = MAXPOS;
	var[VARB] = datbas;
	var[VARD] = datsiz;
	var[VARE] = entrypt;
	var[VARM] = magic;
	var[VARS] = stksiz;
	var[VART] = txtsiz;
	if ((sigint = signal(SIGINT, 01)) != 01)
	{
		sigint = fault;
		signal(SIGINT, fault);
	}
	sigqit = signal(SIGQUIT, 1);
	setjmp(erradb);
	if (executing)
		delbp();
	executing = FALSE;
	for(;;)
	{
		flushbuf();
		if (errflg)
		{
			printf("%s\n", errflg);
			exitflg = errflg;
			errflg = 0;
		}
		if (mkfault)
		{
			mkfault = 0;
			printc(EOR);
			prints(DBNAME);
		}
		lp = 0;
		rdc();
		lp--;
		if (eof)
		{
			if (infile)
			{
				iclose();
				eof = 0;
				longjmp(erradb, 1);
			}
			else
				done();
		}
		else
			exitflg = 0;
		command(0, lastcom);
		if (lp && lastc != EOR)
			error(NOEOR);
	}
}

done()
{
	endpcs();
	exit(exitflg);
}
