progname="Network Configuration Program"
set -e
SPOOLDIR=/tmp/net
DEVDIR=/dev/net
CHOWN=/etc/bin/chown

cat <<!
		$progname

	You will be asked for all the names of DIRECTLY connected hosts.
	Please supply them one at a time,
	terminating the list with a null line.

!
host=1
while [ ${host}x != x ]
do
	echo "host name:\07 \c"
	read host
	if [ ${host}x != x ]
	then
		hosts="$hosts $host"
	fi
done
if [ ${hosts}x = x ]
then
	cat <<-!

		Well, if there are no hosts connected, then there is not much
		point in your being in the network, is there?
	!
	exit 1
fi
cat<<!

	Directly connected hosts are: $hosts

!
if [ ! -d $SPOOLDIR ]
then
	mkdir $SPOOLDIR
fi
chmod 775 $SPOOLDIR
$CHOWN daemon $SPOOLDIR
if [ ! -d $DEVDIR ]
then
	mkdir $DEVDIR
fi
chmod 775 $DEVDIR
rm -f /etc/netstate
mknod /etc/netstate a
chmod 644 /etc/netstate
chown daemon /etc/netstate
if  [ ! -d ${SPOOLDIR}/~files ]
then
	mkdir ${SPOOLDIR}/~files
fi
chmod 771 ${SPOOLDIR}/~files
$CHOWN daemon ${SPOOLDIR}/~files
if  [ ! -d ${SPOOLDIR}/~work ]
then
	mkdir ${SPOOLDIR}/~work
fi
chmod 771 ${SPOOLDIR}/~work
$CHOWN daemon ${SPOOLDIR}/~work
for i in $hosts
do
	if [ ! -d ${SPOOLDIR}/$i ]
	then
		mkdir ${SPOOLDIR}/$i
	else
		rm -rf ${SPOOLDIR}/${i}/* ${SPOOLDIR}/${i}/.*
	fi
	$CHOWN daemon ${SPOOLDIR}/$i
	chmod 775 ${SPOOLDIR}/$i
	if [ -r ${DEVDIR}/$i ]
	then
		mv ${DEVDIR}/$i ${DEVDIR}/OLD$i
		echo "OLD ${DEVDIR}/$i saved as ${DEVDIR}/OLD$i"
	fi
	echo "\tWhat is the major device number for ${DEVDIR}/$i ?\07 \c"
	read major
	echo "\tWhat is the minor device number for ${DEVDIR}/$i ?\07 \c"
	read minor
	mknod ${DEVDIR}/$i c $major $minor
	chmod 600 ${DEVDIR}/$i
	$CHOWN daemon ${DEVDIR}/$i
	ls -l ${DEVDIR}/$i
	echo
done
cat <<!

	You should also make the "con" links in $DEVDIR at your
	leisure. These should bear names in order; eg: ${i}0, ${i}1...
	according to how many channels there are.

	Edit the "rc" file to include the daemon start-ups,
	eg: "netd $i"

	Have fun.
!
