USAGE=' -Sspooldir -{D|R|U}hostname -Chostname [-Fhostname] [-Tnetstats]'

for i
do
	case $i
	in
		-C*)
			CONN=`expr $i : '-C\(.*\)'`
			;;
		-D*)
			DOWN=`expr $i : '-D\(.*\)'`
			CNF=$i
			;;
		-F*)
			IGNH=`expr $i : '-F\(.*\)'`
			;;
		-R*)
			REMOVE=`expr $i : '-R\(.*\)'`
			CNF=$i
			;;
		-S*)
			SPOOLDIR=`expr $i : '-S\(.*\)'`
			;;
		-T*)
			ROUTE=`expr $i : '-R\(.*\)'`
			ROUTE=-S$ROUTE
			;;
		-U*)
			UP=`expr $i : '-U\(.*\)'`
			CNF=$i
			;;
		*)
			echo "$0: bad usage \"$i\""
			echo "Usage: $0 $USAGE"
			exit 2
			;;
	esac
	if [ "$CNF"x != x ]
	then
		if [ "$NF"x != x ]
		then
			echo "Only ONE of D,R,U allowed!"
			NF=
			break
		fi
		NF=$CNF
		CNF=
	fi
done

if [ "$NF"x = x -o "$CONN"x = x -o "$SPOOLDIR"x = x ]
then
	echo "Usage: $0 $USAGE"
	exit 3
fi

if [ "$UP"x != x ]
then
	net $NF -h$UP
	exit 0
else
	if [ "$REMOVE"x != x ]
	then
		netstate -b${REMOVE}:${CONN}
	else
		netstate -d${DOWN}:${CONN}
	fi
fi

#	find all links and send them the message

cd $SPOOLDIR

for i in */.lock */*/.lock
do
	if [ "$i" != \*/.lock -a "$i" != \*/\*/.lock ]
	then
		link=`expr $i : '\(.*\)\/.lock'`
		change=${link}/.change
		if [ ! -r $change ]
		then
			if [ ${DOWN}x != ${link}x -a ${CONN}x != ${link}x -a ${IGNH}x != ${link}x ]
			then
				net $NF -h$link $ROUTE
			fi
			> $change
			marks="$marks $change"
		fi
	fi
done

if [ "$marks"x != x ]
then
	rm -f $marks
fi

exit 0
