/	SUBTITLE	c-cnword.s	consword
/	Written by Steven Hardy on 14 April 1976
/		Revised 17th September 1976
/		Revised 10th January 1977
/
/	This function takes as argument a description of a word
/	in the dictionary. The dictionary is searched for
/	the appropriate word which is the result of the function
/	call. If the word does not exist it is created with
/	no value (ie false) and no identprops (ie undef).
/
/	POP11 uses the 'open hash' organization technique.
/	A structure (called 'dicvec') with 64
/	elements is accessed by a 'hash function' called
/	cwentry. This takes a word (or string) and returns
/	an entry from dicvec. A dictionary entry is either
/	false (ie this bucket is empty), a word (ie the only
/	element of this bucket) or else a list of words.
/
	ksfunction
fcnword:
	br	scnword
	wcnword; false
exit=.
	rts	pc
scnword:
	bit	r4,(r5)			/ is argument integral?
	beq	1f			/ br if not
	jsr	pc,scnstring		/ make string
	br	2f
1:
	jsr	pc,scopy		/ copy given string
2:
	mov	(r5),-(r5)		/ get dict entry
	jsr	pc,scwentry
	mov	(r5)+,r3		/ pop to r3
	cmp	r3,$false		/ is bucket empty?
	beq	3f			/ br if so
	cmp	okey(r3),$kword		/ is it a word?
	beq	2f			/ br if so
1:					/ must be a list
	cmp	r3,$nil			/ is list empty?
	beq	3f			/ br if so
	mov	(r3)+,-(r5)		/ push head of list
	jsr	pc,scwequal		/ is it the one?
	bcc	exit			/ br if so
	mov	(r3),r3			/ tail of list -> list
	br	1b			/ loop back to check rest of list
2:					/ here on a word
	mov	r3,-(r5)		/ push word
	jsr	pc,scwequal		/ is it the one?
	bcc	exit			/ exit if so
3:					/ not found
	jsr	pc,sgensym		/ create a new word
	mov	(r5)+,r0		/ pop to r0
	mov	(r5)+,oname(r0)		/ set its name
	mov	r0,-(r5)		/ push result (the word)
	mov	r0,-(r5)		/ but put in dictionary
	jbr	scwinsert		/ chain (insert word)
