/	SUBTITLE	b-lxdig.s	lexical analyse a digit
/	Written by Steven Hardy on 20 April 1976
/	Modified 19th November 1976 to handle reals
/
slxdig:
	cmp	r1,#'8			/ could this be an octal number?
	bne	3f			/ br if not
	jsr	pc,slxget		/ get next char
	cmp	r1,#':			/ is this an octal number?
	bne	2f			/ br if not
/ here on an octal number
	mov	r4,-(r5)		/ push zero
1:
	jsr	pc,slxget		/ get next char
	cmp	lxtyp(r1),$slxdig	/ is it a digit?
	jne	slxput			/ if not unread the char and exit
	sub	$2*'0,r1		/ convert char to number
	mov	r1,-(r5)		/ push the char
	jsr	pc,sswap		/ swap char and total
	mov	#8.,-(r5)		/ set up for multiply
	jsr	pc,snmmul		/ multiply total by 8
	jsr	pc,snmadd		/ add this char
	br	1b			/ loop back for rest of number
2:					/ here if not octal but begins with '8
	.if	real
	mov	$-1,-(r5)		/ decimal count
	.endif
	mov	#8.,-(r5)		/ initial number
	br	1f
3:
	.if	real
	mov	$-1,-(r5)		/ push initial deccount
	.endif				/ ie number of digits after (and including) dec point.
	mov	r4,-(r5)		/ POP11 zero onto stack
1:
	cmp	lxtyp(r1),$slxdig	/ is next char a digit?
	bne	5f			/ br if not
	sub	$2*'0,r1		/ subtract code for '0
	mov	(r5)+,r0		/ pop result to r0
	mov	r1,-(r5)		/ push digit
	mov	r0,-(r5)		/ push result
	.if	real
	bit	r4,r0			/ is result still integral?
	beq	2f			/ br if not
	cmp	r0,#1638.		/ is result getting too large?
	blt	3f			/ br if not
	bne	2f			/ br if so
	cmp	r1,#4.			/ will this digit blow it?
	ble	3f			/ br if not
2:
	mov	$dten,-(r5)		/ push 10.0
	br	4f			/ br to multiply
	.endif
3:
	mov	#10.,-(r5)		/ push 10
4:
	jsr	pc,snmmul		/ multiply
	jsr	pc,snmadd		/ add digit
	jsr	pc,slxget		/ get next char
	br	1b			/ loop back
5:					/ here at first non digit char
	.if	real
	cmp	r1,#'.			/ is it a real?
	bne	2f			/ br if not
1:
	jsr	pc,slxget		/ get next char
	inc	2(r5)			/ increment dec count
	cmp	lxtyp(r1),$slxdig	/ is it a digit?
	bne	1f			/ br if not
	sub	$2*'0,r1		/ convert char to digit
	mov	(r5)+,r0		/ pop result to r0
	mov	r1,-(r5)		/ push digit
	mov	r0,-(r5)		/ push result
	mov	$dten,-(r5)		/ push 10.0
	jsr	pc,snmmul		/ multiply
	jsr	pc,snmadd		/ add digit
	br	1b			/ loop back
1:					/ here at end of fractional point
	jsr	pc,slxput		/ unread char
	tst	2(r5)			/ but was it a lone dec point (eg 2.nl)
	bne	1f			/ br if not
	mov	#'.,r1			/ 'reset' char as real
	br	2f			/ continue with integer processing
1:					/ divide loop
	mov	$dten,-(r5)		/ push 10.0
	jsr	pc,snmdiv		/ divide
	dec	2(r5)			/ decrement dec count
	bne	1b			/ loop back if more to go
	mov	(r5)+,(r5)		/ remove dec count (now zero) from stack
	rts	pc			/ done
	.endif
2:					/ here on normal integer (eg 34x)
					/ or lone dec point
	jsr	pc,slxput		/ unread char (eg x)
	.if	real			/ check for overflow in real systems
	mov	(r5)+,(r5)		/ remove dec count from stack
	bit	r4,(r5)			/ is result still integral?
	beq	1f			/ br if not
	.endif				/ end of special processing
	rts	pc
1:					/ error code for real system integer overflow
	.if	real
	mov	#1043.,-(r5)		/ Error 43, one culprit
	jbr	serror
	.endif
