/	SUBTITLE	b-frdta.s	frame data
/	Written by Steven Hardy on 30 April 1976
/	This function takes as argument the address of a stack frame.
/	It returns two results - the address of the next stack frame
/	and the 'owner' of the stack frame.
/
sfrdta:
	mov	(r5)+,r0		/ pop address of frame to r0
	mov	(r0)+,r1		/ clink of frame to r1
1:
	tst	-(r1)			/ move r1 back till it points to 'ksfunction'
	bne	1b			/ which is zero
	cmpb	3(r1),r4		/ if r1 now points to ksfunction next word should contain a br instruction
	bne	1b			/ loop back if it doesn't
	tst	(r1)+			/ make r1 point to start of function
	cmp	r1,$finterpret		/ does r1 point to the interpreter?
	bne	1f			/ br if not
	mov	(r0),-(r5)		/ next element of the frame is the user function
	add	*(r5),r0		/ advance r0 by number of user locals
	add	*(r5),r0		/ twice - bytes not words!
	add	$4,r0			/ for other locals of interpret
	mov	r0,-(r5)		/ push the address of the next frame
	rts	pc
1:
	mov	r1,-(r5)		/ push owner
	add	$6,r1			/ r1 now points to exit code of owner
1:
	cmp	(r1)+,$rts+pc		/ is r1 pointing to an rts pc instruction?
	beq	1f			/ br if so
	tst	(r0)+			/ must be a pop from the auxiliary stack
	tst	(r1)+
	br	1b
1:
	mov	r0,-(r5)
	rts	pc
