/	SUBTITLE	b-check.s	check for nasty conditions
/	Written by Steven Hardy on 30 April 1976
/
scheck:
	cmp	sp,bsplo		/ is there an auxiliary stack overflow?
	blos	1f			/ br if so
	cmp	r5,br5lo		/ is there a user stack overflow?
	blos	2f			/ br if so
	tst	btime			/ has there been a clock tick?
	bne	3f			/ br if so
	rts	pc			/ all okay so exit
1:
	cmp	bsplo,$ospyellow	/ already overflowing?
	bne	1f			/ br if so
	mov	$ospred,bsplo		/ lower stack limit
	mov	#33.,-(r5)		/ Error 33
	jbr	serror
1:
	mov	bsphi,sp		/ clear auxiliary stack
	mov	$ssetpop,-(sp)		/ Make out we are in a call of setpop
	mov	#34.,-(r5)		/ Error 34
	jbr	serror
2:
	jsr	pc,sgarbage		/ do a garbage collection
	cmp	r5,br5lo		/ still overflowing?
	blos	1f			/ br if so
	rts	pc			/ if not return
1:
	cmp	br5zn,$ozone		/ how big is the user stack zone?
	beq	1f			/ br if equal to ozone
	sub	$ozone,br5zn		/ make the safe zone smaller
	sub	$ozone,br5lo		/ and hence bottom of user stack
	mov	#31.,-(r5)		/ Error 31
	jbr	serror
1:
	mov	br5hi,r5		/ clear the user stack
	mov	#31.,-(r5)		/ Error 31
	jbr	serror
3:
	tst	bsgint			/ interrupt?
	jne	ssgintdo
	asl	btime
	add	btime,ptime
	clr	btime
	mov	ptickfun,-(r5)		/ push clock tick function
	jbr	sapply			/ apply it
