#include	"../h/local.h"
#include "pdp00.h"
#include "pdpex.h"
#include "../h/em1.h"

/*
 * EM1 - UNIX as translator
 *
 * procedures for fake-stack manipulation
 */

/*
 * make_int provides a number of integer frames on the stack
 */

make_int (asked,empties) int asked,empties; {
	register fake_t *p,*fake_bottom;
	register i;
	int stks,dbls,faults,too_few;

	if (asked>=MAXFAKE)
		fatal(" * no space in make_int *");
	i = stks = dbls = faults = 0;
	p = fsp;
	while (i<asked && p>fake) {
		if (p->type==STK)
			stks++;
		if (p->flags & INT)
			i++;
		else {
			i =+ 2;
			dbls++;
			if (p->flags & CONV || (p->type==REG && p->flags==0))
				faults++;
				/* no splitting of this frame possible */
		}
		p--;
	}
	fake_bottom = p;
	too_few = asked-i>0? asked-i : 0;
		/* if too_few > 0 there were not enough fake entries (yet) */
	if (faults) {	/* no splitting possible! */
		if (empties==SAVE_FAKE)
			empty_fake(asked);
		else
			empty_fake(empties ? empties+asked : ALL);
		if (fsp==fake) {
			fake_bottom=fake;
			too_few=asked;
			dbls=0;
		}
	}
	/* enough 'split' space available? */
	if (dbls > &fake[MAXFAKE-1] - fsp) {
		/* n.b. you can't get here if too_few>0 ! */
		if (stks) {
			empty_fake(ALL);
			too_few=asked;
		} else {
			/* copy down top-frames containing n words
			 * (cannot if there were STKs in these frames!)
			 */
			p = fsp;
			fsp = fake_bottom;
			empty_fake(ALL);
			while (++fake_bottom <= p)
				pshfk(fake_bottom);
		}
		fake_bottom = fake;
	}
	/* now there is enough space for splitting,
	 * but first be sure to actually have frames containing
	 * n words.
	 */
	if (too_few)
		fillup(too_few);

	/* now split frames from top to bottom: */
	p = fsp;
	while (p>fake_bottom) {
		if ( (p->flags & INT)==0 )
			split(p);
		p--;
	}
}

/*
 * make_dbl provides a number of floats on the fake stack
 */

make_dbl(asked) int asked; {
	register fake_t *p,*fake_bottom;
	register i;
	int stks,ints,too_few;

	asked =<< 1;	/* twice as much words as doubles */
	if (asked >= MAXFAKE-1)
		fatal(" * no space in make_dbl *");
	p = fsp;
	i = ints = stks = 0;
	while (i<asked && p>fake) {
		if (p->flags & INT) {
			i++;
			ints++;
		} else
			i =+ 2;
		if (p->type==STK)
			stks++;
		p--;
	}
	fake_bottom = p;
	too_few = asked-i;
	if (ints && fsp >= &fake[MAXFAKE-1]) {	/* one 'split' frame needed */
		if (stks) {
			empty_fake(ALL);
			too_few = asked;
		} else {
			p = fsp;
			fsp = fake_bottom;
			empty_fake(ALL);
			while (++fake_bottom <= p)
				pshfk(fake_bottom);
		}
		fake_bottom = fake;
	}
	if (too_few>0)
		fillup(too_few);
	else
		if (too_few == -1) {	/* one too much!! */
			if ( (++fake_bottom)->type==REG
			    || fake_bottom->flags & (CONV | IND) )
				tostack(ONEFRAME,fake_bottom);
			split(fake_bottom);
			/* n.b. here frame fake_bottom IS a double! */
		}

	/* now join frames from bottom to top: */
	p = fake_bottom;
	while (++p <= fsp)
		if (p->flags & INT)
			join(p);
}

/*
 * split splits a float frame into two integer frames
 */

split (fp) fake_t *fp; {
	register fake_t *p;
	register stks,nr;
	fake_t f;

	p = fsp++;	/* fake gets one entry more now! */
	stks = 0;
	while (p>fp) {
		copyf(p,p+1);
		if (p->type=STK)
			stks++;
		p--;
	}
	/* now split frame fp */
	if (fp->flags & IND) {
		reg_frame(&f);
		if (fp->type==REG && (fp->flags&OFF)==0) {
			if ((nr=reg_avail(INT,ONLY_REG)) != -1){
				f.index=nr;
				gen2(MOV,indreg(2,fp->index),str(&f));
				fp->flags =| INT;
				copyf(&f,++fp);
				return;
			}
		} else	if (stks==0 && (nr=reg_avail(INT,ONLY_REG)) != -1){
				fp->flags = INT;
				f.index = nr;
				genf(MOV,fp,&f);
				gen1(TST,autinc(nr));
					/* high-word! */
				fp->flags =| IND;
				f.flags =| IND;
				copyf(&f,++fp);
				return;
		}
		stk.flags = 0;
		move(fp,&stk);
	}
	fp->flags =| INT;
	copyf(fp,fp+1);
	if ((fp++)->type==CONS)
		fp->offset = 0;
	else
		fp->offset =+ 2;	/* add two BYTES */
}

/*
 * join joins two integer frames into one float frame
 */

join (fp) fake_t *fp; {
	register fake_t *fp2,*p;
	int tp;

	for (;;) {
		fp2=fp+1;
		if ( ((tp=fp->type)==LOCL || tp==EXT || tp==STK)
		    && (fp->flags & (CONV | IND))==0 ) {
			if (fp2->type==tp
			   && (tp != STK?
			(fp2->offset==fp->offset+2 && fp2->index==fp->index)
				: TRUE)
			   && fp2->flags==fp->flags ) {
				fp->flags = 0;
				/*
				 * a double without conversion or
				 * indirect addressing
				 */
				p = fp2;
				while (++p <= fsp)
					copyf(p,p-1);
				fsp--;
				return;
			} else
				/*
				 * fp2 doesn't 'fit' with fp;
				 * can fp2 be splitted?
				 */
				if (fp2->flags==0 && fp2->type!=REG)
					split(fp2);
				else
					/*
					 * to be joined only
					 * by using the stack
					 */
					tostack(TWOFRAMES,fp);
		} else {
			if (fp2->flags==0 && fp2->type!=REG)
				split(fp2);
			tostack(TWOFRAMES,fp);
		}
		/* try again after splitting and or stacking */
	}
}

/*
 * fillup inserts a number of STK entries in the fake
 */

fillup (n) int n; {
	register fake_t *p;

	p = fsp;
	while (p>fake) {
		copyf(p,p+n);
		p--;
	}
	fsp =+ n;
	p = fake;
	stk.flags = INT;
 	/* fill from bottom to fsp with integer stack-frames */
	while (n-- > 0)
		copyf(&stk,++p);
}

tostack (twoflag,fp) int twoflag; fake_t *fp; {
	register fake_t *p,*ftop;
	register n;
	int stks;

	p = fp;
	stks = 0;
	n = wrdsof(fp);
	while (++p <= fsp) {
		n =+ wrdsof(p);
		if (p->type==STK)
			stks++;
	}
	ftop = fsp;
	if (stks==0) {
		fsp = fp;
		n = wrdsof(fp);
		if (twoflag) {
			fsp++;
			n =+ wrdsof(fsp);
		}
	}
	empty_fake(n);
	fsp = ftop;
	/*!!*/
}

/*
 * checkint checks a frame for being a 'clean' integer
 */

checkint(fp,reg_or_stack,nr) fake_t *fp; int reg_or_stack,nr; {
	register fake_t *lfp;
	fake_t f;

	lfp=fp;
	reg_frame(&f);
	f.index=nr;
	if (lfp->type==ADDRLOCL) {
		getreg(&f,ONLY_REG);
		move(lfp,&f);
	} else if ((lfp->flags & (IND|OFF)) && reg_or_stack < ANY){
		if (lfp->index != nr || lfp->type != REG)
			getreg(&f,reg_or_stack);
		move(lfp,&f);
	} else if (lfp->flags & CONV){
		getreg(&f,reg_or_stack);
		move(lfp,&f);
	} else if (reg_or_stack==ODD_REG &&
				(lfp->type != REG || lfp->index%2 != 1)){
		getreg(&f,ODD_REG);
		move(lfp,&f);
	} else if (reg_or_stack==REG_or_STK &&
				lfp->type != REG && lfp->type !=STK){
		f.index = ANY;
		getreg(&f,REG_or_STK);
		move(lfp,&f);
	}
}

/*
 * checkfloat checks a frame for being a 'clean' float
 */

checkflt(fp) fake_t *fp; {
	register conv;
	fake_t f;

	if ((conv=(fp->flags&CONV))==IFC || conv==DFC) {
		reg_frame(&f);
		f.flags=0;
		getreg(&f,ONLY_REG);
		move(fp,&f);
	} else if (conv==FDC) {
		stk.flags=0;
		move(fp,&stk);
	} else if (conv==FIC || conv==DIC)
		fatal("checkflt called with bad 'CONV'");
}

/*
 *  congr checks a fake frame and a lines frame on identity
 *        (stl 2 ~ lol 2)
 */

int congr(f,l) line_t *l; fake_t *f;{
	register line_t *lp;
	register fake_t *fp;
	int lineoff,lineind;

	lp=l;
	fp=f;
	if(lp->type1==GLOSYM) {
		lineoff=0;
		lineind = int_cast lp->ad.ad_gp->g_name;
	} else {
		lineoff=lp->ad.ad_i;
		lineind=0;
	}
	if (fp->type == LOCL)
		return((fp->flags == 0 && (lp->instr_num&0377) == op_sdl
		   || fp->flags == INT && (lp->instr_num&0377) == op_stl)
			&& fp->offset==lineoff
			&& fp->index==lineind );
	else if (fp->type == EXT)
		return((fp->flags == 0 && (lp->instr_num&0377) == op_sde
		   || fp->flags == INT && (lp->instr_num&0377) == op_ste)
			&& fp->offset==lineoff
			&& fp->index==lineind );
	else
		return(0);
}
