#include	"../h/local.h"
#include "pdp00.h"
#include "pdpex.h"
#include "../h/em1.h"

/*
 * EM1 - UNIX as translator
 *
 * SINGLE PRECISION ARITHMETIC
 * FLOATING POINT ARITHMETIC
 *
 */

/*
 *  op_add, op_pad, op_sub, op_psb, BIS (op_ior 2)
 */

add_sub(mnem) int mnem;{
	register fake_t *tp,*sp;
	register line_t  *lp;
	int cpyflag;
	char *s;

	make_int(2,SAVE_FAKE);
	tp = fsp--;
	sp = fsp;
	lp = forward();
	cpyflag = FALSE;
	checkint(tp,ANY,ANY);
	checkint(sp,ANY,ANY);
	if (congr(sp,lp)) {
		fsp--;
		empty_to(sp);
		genf(mnem,tp,sp);
		free_reg(tp);
		nextline = lp;
		coco = fake;
	} else if (mnem!=op_sub && congr(tp,lp)) {
		fsp--;
		empty_to(tp);
		genf(op_add,sp,tp);
		free_reg(sp);
		nextline = lp;
		coco = fake;
	} else if (mnem!=op_sub && sp->type==STK && tp->type==REG
			    && !(tp->flags & (IND|OFF))) {
		genf(mnem,sp,tp);
		copyf(tp,sp);
		coco = sp;
	} else {	/* " add 'top','second' "  */
		if (sp->type == REG && !(sp->flags & (IND|OFF))) {
			s = str1(sp);
			free_reg(tp);
		} else if (sp->type == STK) {
			s = TOP;
			free_reg(tp);
		} else {
			if ((mnem!=op_sub) &&
			   (tp->type==STK ||
				(!(tp->flags&(IND|OFF))&&tp->type==REG))){
				if (tp->type == STK)
					s = TOP;
				else
					s = str1(tp);
				free_reg(sp);
				sp = tp;
				tp = fsp;
				cpyflag = TRUE;
			} else {
				mv_to_reg(sp,ANY);
				s = str1(sp);
				free_reg(tp);
			}
		}
		gen2(mnem,str(tp),s);
		if (cpyflag)
			copyf(sp,tp);
		coco = fsp;
	}
}

/*
 *  op_mul
 */

gen_mul(){
	register fake_t *tp,*sp;

	make_int(2,SAVE_FAKE);
	tp = fsp--;
	sp = fsp;

	if (tp->flags & CONV) {
		if (sp->type == REG && sp->flags==INT && odd(sp->index)) {
			checkint(tp,REG_or_STK,ANY);
			genf(op_mul,tp,sp);
			free_reg(tp);
		} else {
			checkint(sp,ANY,ANY);
			checkint(tp,ODD_REG,ANY);
			genf(op_mul,sp,tp);
			free_reg(sp);
			copyf(tp,sp);
		}
	} else if(sp->flags & CONV) {
		if (tp->type == REG && tp->flags==INT && odd(tp->index)) {
			checkint(sp,REG_or_STK,ANY);
			genf(op_mul,sp,tp);
			free_reg(sp);
			copyf(tp,sp);
		} else {
			checkint(tp,ANY,ANY);
			checkint(sp,ODD_REG,ANY);
			genf(op_mul,tp,sp);
			free_reg(tp);
		}
	} else {
		if (sp->type==REG && !(sp->flags & (IND|OFF))
				&& odd(sp->index)) {
			checkint(tp,ANY,ANY);
			genf(op_mul,tp,sp);
			free_reg(tp);
		} else if (tp->type == REG && !(tp->flags & (IND|OFF))
				&& odd(tp->index)) {
			checkint(sp,ANY,ANY);
			genf(op_mul,sp,tp);
			free_reg(sp);
			copyf(tp,sp);
		} else {
			checkint(tp,ANY,ANY);
			checkint(sp,ODD_REG,ANY);
			genf(op_mul,tp,sp);
			free_reg(tp);
		}
	}
	coco = fsp;
}

/*
 *  op_div, op_mod
 */

div_mod(mnem) int mnem;{
	register fake_t *tp,*sp;
	register stkpop;
	fake_t f;

	make_int(2,SAVE_FAKE);
	tp = fsp--;
	sp = fsp;
	reg_frame(&f);
	f.index=REG0;
	stkpop=FALSE;
	if (is_reg(sp)==IREG && sp->index==0) {
		f.index=REG1;
		getreg(&f,ONLY_REG);
		move(sp,&f);	/* put dst frame into r1 */
	} else if (sp->type==STK && tp->type==STK) {
		gen2(MOV,MIN4SPX,R1);
		(coco=fsp)->type=REG;
		fsp->offset=0;
		fsp->index=1;
		stkpop=TRUE;
	} else {
		if (iregs[REG0]!=FREE)
			coco = fake;
		getreg(&f,REG1);	/*: do not store into r1  */
		iregs[REG0] = &f;
		mv_to_reg(sp,REG1);
	}
	if ((coco==fake)||(coco->type != REG)||(coco->index != 1))
		gen1(TST,R1);
	gen1(SXT,R0);
	checkint(tp,ANY,ANY);
	gen2(op_div,str(tp),R0);
	if (stkpop) {
		gen1(TST,POP);
		coco = fake;
	} else
		coco = fsp;
	free_reg(tp);
	if (mnem == op_div) {
		iregs[REG1]=FREE;
		f.index=REG0;
	} else {
		iregs[REG0]=FREE;
		f.index=REG1;
		coco=fake;
	}
	copyf(&f,sp);		/* result in r0 (or r1)  */
}


/*
 *  op_rol, op_ror, op_shl, op_shr
 */

gen_ash(mnem) int mnem; {
	register fake_t *tp,*sp;
	register char *s;

	make_int(2,SAVE_FAKE);
	tp = fsp--;
	sp = fsp;
	if (tp->type==CONS && tp->flags==INT){
		tp->offset =& 017;
		if (tp->offset==1 &&
		    (mnem==op_shl || mnem==op_shr)){
			ashspc(mnem);
			return;
		}
		if (mnem==op_shr || mnem==op_ror)
			tp->offset = -(tp->offset);
		else
			if (mnem==op_rol)
				tp->offset =- 16;
	} else {
		if (tp->type==STK && sp->type==STK)
			checkint(tp,ONLY_REG,ANY);
		else
			checkint(tp,REG_or_STK,ANY);
		if (tp->type==STK)
			s = TOP;
		else
			s = str(tp);
		gen2(BIC,"$177760",s);
		if (mnem==op_shr || mnem==op_ror)
			gen1(op_neg,s);
		else
			if (mnem==op_rol)
				gen2(op_sub,"$16.",s);
	}
	/*
	 *  now tp is right operand for ash or ashc
	 */
	if (mnem==op_rol || mnem==op_ror)
		checkint(sp,ODD_REG,ANY);
	else
		mv_to_reg(sp,ANY);
	genf((mnem==op_rol||mnem==op_ror)?ASHC:ASH,tp,sp);
	free_reg(tp);
	coco = sp;
}

/*
 *  op_shl, op_shr with operand 1
 */

ashspc(mnem) int mnem; {
	register line_t *fwp;
	register fake_t *ftop;

	make_int(1,SAVE_FAKE);
	checkint(fsp,ANY,ANY);

	if (congr(fsp,fwp=forward())) {
		ftop = fsp--;
		empty_to(ftop);
		gen1(mnem,str(ftop));
		nextline = fwp;
		coco = fake;
	} else {
		mv_to_reg(fsp,ANY);
		gen1(mnem,str(fsp));
		coco = fsp;
	}
}
/*
 *  op_fad, op_fsb, op_fmu, op_fdv
 */

gen_flt(mnem) int mnem; {
	register fake_t *tp,*sp;
	fake_t f;

	make_dbl(2);
	tp = fsp--;
	sp = fsp;
	checkflt(tp);
	checkflt(sp);

	coco = fsp;
	if (sp->type == REG && sp->flags == 0) {
		genf(mnem,tp,sp);
		free_reg(tp);
	} else if ((mnem==op_fad || mnem==op_fmu)
		&& (tp->type==REG && tp->flags==0)) {
		genf(mnem,sp,tp);
		free_reg(sp);
		copyf(tp,sp);
	} else {
		reg_frame(&f);
		f.flags=0;
		getreg(&f,ONLY_REG);
		if (tp->type==STK && sp->type==STK
		 && (mnem==op_fsb || mnem==op_fdv) ) {
			gen2(op_ldf,MIN8SPX,str(&f));
			gen2(mnem,POP,str(&f));
			gen2(op_cmi,POP,POP);
			copyf(&f,sp);
			coco = fake;
		} else {
			move(sp,&f);
			genf(mnem,tp,sp);
			free_reg(tp);
		}
	}
}
