#
#include "const.h"
/*
 *	pre-processor for the Translang translator.
 *	This program filters standard input, changing
 *	text between lines marked '.a' and '..' from
 *	ascii to a set of literal assignments which
 *	can be encoded by 'trans'.
 */

char	inbuf[BUFSIZ], outbuf[BUFSIZ];
char	buf[BUFSIZE];


main()
{
	register char	*ptr;

	setbuf(stdin, inbuf);
	setbuf(stdout, outbuf);
	while( readline(stdin,buf) > 0 )
	{
		ptr = buf;

		if( *ptr++ == '.' && *ptr++ == 'a' && *ptr == '\n' )
		{
			if( !readtex() )	exit();
		}
		else
		{
			fprintf(stdout, "%s", buf);
		}
	}
}

readtex()
{
	register int	flag;
	register char	*ptr;

	flag = 1;

	while( readline(stdin,buf) > 0 )
	{
		ptr = buf;

		if( *ptr++ == '.' && *ptr++ == '.' && *ptr == '\n' )
		{
			fprintf(stdout, "\t0 = lit\n");
			return( 1 );
		}
		else
		{
			ptr = buf;
		}

		if( !flag )	fprintf(stdout, "\t%d = lit\t$ \\n\n" , '\n');

		while( *ptr != '\n' )
		{
			fprintf(stdout, "\t%d = lit\t$" , *ptr);

			switch( *ptr )
			{
			case '\\':
				ptr++;
				if( *ptr == '\n' )	break;
			case ' ':
				fprintf(stdout, "\n");
				break;
			case '\t':
				fprintf(stdout, " \\t\n");
				break;
			default:
				fprintf(stdout, " %c\n" , *ptr);
			}
			ptr++;
		}

		flag = 0;
	}
	return( 0 );
}
