#
#include "const.h"
#include "regs.h"
#include "memory.h"
/*
 *	Output functions
 *
 *	These are:
 *	dumpmem()
 *	outreg()
 */
dumpmem()
{
	int	addr1,addr2;
	register long	*saddr,*saddr1;
	int	asc,dec,hex,oct;	/* output mode flags */
	int	i,n;
	char	*ptr;

	printf("Dump of s-memory.\nOutput can be in decimal,hex,octal, or ascii.");
	printf("\nInput is:\n	starting address. (9999 terminates dump)\n");
	printf("	finishing address.	and\n	output mode. (first character)");

	for(;;)
	{
		dec = FALSE;
		asc = FALSE;
		oct = FALSE;
		hex = FALSE;

		printf("\n\nStarting address? ");
		fflush(stdout);
		i = readline(stdin, buf);
		if( i == 0 )
		{
			printf("*** end of file ***\n");
			return;
		}
		addr1 = atoi(buf);
		if( outflags & 0400 )	printf("%d",addr1);
		putchar('\n');
		if( addr1 == 9999 )	return;

		if( addr1 > SLIMIT )
		{
			printf("S-memory only goes to %d\n",SLIMIT);
			continue;
		}

		printf("Finishing address? ");
		fflush(stdout);
		i = readline(stdin, buf);
		addr2 = atoi(buf);
		if( outflags & 0400 )	printf("%d",addr1);

		if( addr2 > SLIMIT )
		{
			printf("S-memory only goes to %d\n",SLIMIT);
			continue;
		}

		printf("\nOutput mode? ");
		fflush(stdout);
		i = readline(stdin, buf);
		if( outflags & 0400 )	fprintf(stdout,buf);

		printf("\nDump of memory from %d to %d\n",addr1,addr2++);
		printf("Location	S-Memory Contents\n");

		for( ptr=buf ; *ptr ; ptr++ )
		{
			switch( *ptr )
			{
			case 'd':
				dec = TRUE;
				break;
			case 'o':
				oct = TRUE;
				break;
			case 'h':
				hex = TRUE;
				break;
			case 'a':
				asc = TRUE;
			}
			if( !(dec || oct || hex || asc) )	dec = TRUE;
		}
		for( saddr = &smem[addr1] ; addr1 < addr2 ; saddr = saddr1 )
		{
			n = addr2 - addr1;
			if( n > 5 )	n = 5;
			if( dec )
			{
				saddr1 = saddr;
				printf("%4d",addr1);

				for( i=n ; i!=0 ; i-- )	printf(" %12ld",*saddr1++);
				putchar('\n');
			}
			if( oct )
			{
				saddr1 = saddr;
				printf("%4d",addr1);
				for( i=n ; i!=0 ; i-- )	printf(" %12lo",*saddr1++);
				putchar('\n');
			}
			if( hex )
			{
				saddr1 = saddr;
				printf("%4d",addr1);
				for( i=n ; i!=0 ; i-- )	printf(" %12lx",*saddr1++);
				putchar('\n');
			}
			if( asc )
			{
				saddr1 = saddr;
				printf("%4d",addr1);
				for( i=n ; i!=0 ; i-- )	ascprt(*saddr1++);
				putchar('\n');
			}
			addr1 += n;
			putchar('\n');
		}
	}
}
/*
 *	routine to print long integers as sets of four chars.
 */
ascprt(val)
long	val;
{
	register char	c,i;

	printf("     ");
	for( i=3 ; i>=0 ; i-- )
	{
		c = val >> (8 * i);
		if( c < ' ' )	c = ' ';	/* don't print nasty characters */
		printf("%c ",c);
	}
	return;
}
/*
 *	Routine to do register dumps.
 *
 *	Now define formats for octal, decimal or hex dumps:
 *	Index 0 for octal, 1 for decimal, and 2 for hex.
 */

char	*form1[] =
	{
		"a1 =%9lo\ta2 =%9lo\ta3 =%9lo\tb =%10lo\n",
		"a1 =%9ld\ta2 =%9ld\ta3 =%9ld\tb =%10ld\n",
		"a1 =%9lx\ta2 =%9lx\ta3 =%9lx\tb =%10lx\n"
	};

char	*form2[] =
	{
		"mir =%8lo\tsar =%8o\tlit =%8o\tctr =%8o\tampcr =%6d\n",
		"mir =%8ld\tsar =%8d\tlit =%8d\tctr =%8d\tampcr =%6d\n",
		"mir =%8lx\tsar =%8x\tlit =%8x\tctr =%8x\tampcr =%6d\n"
	};

outreg(clk,flags)
register int	clk,flags;
{
	int	index;

	index = (flags >> 6) & 03;

	if( flags & 15 )
	{
		if( flags & 1 )
			printf("p(1) addr =%2d	p(%1d) addr =%2d	clock =%6d\n",mpmsav,phase,p3old,clk);
		if( flags & 2 )
			printf( form1[index], a1,a2,a3,b);
		if( flags & 4 )
			printf( form2[index], mir,sar,lit,ctr,ampcr);
		if( flags & 8 )
			printf("br1 =%8d	br2 =%8d	mar =%8d	bmar =%7d	gc1=%1d	gc2=%1d\n",br[0],br[1],mar,bmar,GC1,GC2);
		if( flags & 16 )
			printf("lc1=%1d	lc2=%1d	lc3=%1d	mst=%1d	lst=%1d	abt=%1d	aov=%1d	cov=%1d	sai=%1d	rdc=%1d\n",LC1,LC2,LC3,MST,LST,ABT,AOV,COV,SAI,RDC);
		putchar('\n');
	}
	return;
}
