#
#include "const.h"

	int	p3old;
	int	phase;
/*
 *	registers for d-machine.
 */
	long	a1,a2,a3,b,mir;
	unsigned int	ampcr,bmar,mpmsav,ctr,lit,br[2],mar;
	int	sar,cond[16];
/*
 *	internal variables and buffers
 */
	int	start,maxclk,outnm,outsrt,outstp,outflags,trace,BREAK;
	char	buf[BUFSIZE];
/*
 *	data storage
 */
	long	smem[SLIMIT];
	int	mpm[MLIMIT];
	struct nano
	{
		int  a,b,c,d;
/*	a,b,c,d contain the nano bits
 *		a- bits 1-16
 *		b- bits 17-31
 *		c- bits 32-42
 *		d- bits 43-54
 */
	} nanobts[NLIMIT],*nan1,*nan2;


/*
 * end of external variable declarations
 *
 *
 *	Main program starts here.			**********
 *	-------------------------
 */
main(argc,argv)
int	argc;
char	**argv;
{
/*	definition of local constants
 */
#define PAGE 350
/*
 *	PAGE is the maximum number of register dumps allowed.
 *	It is a crude method of limiting printed output.
 */
#define LMASK	0377
#define AMASK	07777
#define SMASK	037
#define SETC0	020000000001l
#define SETM0	017777777777l
#define SETM1	020000000000l
#define SETL0	037777777776l
#define SETA0	020000000000l
#define SETC1	0177400l
#define SETLB	0377
#define SETL5	073
#define SETMB	036000000000l
#define ZEXT	extbus
#define ERROR1 printf("I/O op requested before previous I/O op done.")

	long	x,y,adout,shout,temp,datawt,x1,y1,b1,extbus,ir;
	extern	long	adder(),devread();
	int	n,skip,byte2,p3new,p3sav,linepr,mpm2;
	unsigned int	addr;
	int	save,clock,mpcr,mpm1;
	int	addop,im,ic,il,con,sc,type2,shift,k,loop,j;
	int	nsai,nrdc,nxtsai,nxtrdc;
	struct	nano	nullnano;
/*
 *	end of declarations
 *
 *	now read the calling line and the input files
 */
	readin(argc,argv);
/*
 *	set initial conditions - clear registers etc.
 */
	nan1 = &nullnano;	/* an empty location to point to */
/*
 *	nan1 points to the nano instruction that is in phase 2 or 3,
 *	while nan2 points to the nano instruction in phase 1.
 */
	nan1->a = 0;
	nan1->b = 0;
	nan1->c = 0;
	nan1->d = 0;
	loop = 0;
	mpm1 = start;	/* set up starting address */
	mpcr = start;
	p3old = start - 1;	/* address of instruction completing phase 3 - initially meaningless */
	type2 = FALSE;
	a1 = 0;		/* clear registers */
	a2 = 0;
	a3 = 0;
	b = 0;
	ampcr = 0;
	ctr = 0;
	sar = 0;
	br[0] = 0;
	br[1] = 0;
	bmar = 0;
	lit = 0;
	mar = 0;
	skip = 0;	/* this counts the number of clock pulses between dumps */
	cond[0] = FALSE;
	SAI = FALSE; /* clear read/write flags */
	RDC = FALSE;
	nsai = 5;	/* 5 clock pulse delay for I/O operations */
	nrdc = 5;
	nxtsai = 0;
	nxtrdc = 0;
	clock = 1;	/* first clock period beginning... */
/*
 *	now the calculation starts
 */
  while( mpm[mpm1] != 0x4000 && (clock-1) <= maxclk)
  {
/*
 *		mpm2 is the mpm instruction, mpm1 is its address.
 */
	mpm2 = mpm[mpm1];
	mpmsav = mpm1;
	if( (mpm2 & 0xF000) == 0xF000 )
	{
		if( (mpm2 & 0x0FFF) < NLIMIT )	nan2 = &nanobts[mpm2 & 0x0FFF];
		else	printf("Nano-instruction memory bounds fault\n");
		p3sav = mpm1;
		type2 = FALSE;
	}
	else	type2 = TRUE;
/*
 *****		select x input for adder
 */
	n = valbits(17,19,nan1);
	switch( n )
	{
	case 0:
		x = 0;		/* 0	*/
		break;
	case 1:
		x = lit;	/* lit	*/
		break;
	case 2:
		x = ZEXT;	/* zext	*/
		break;
	case 3:
		x = ctr;	/* ctr	*/
		x = x << 24;
		break;
	case 4:
		x = ctr;	/* z	*/
		x = (x << 24) | lit;
		break;
	case 5:
		x = a1;		/* a1	*/
		break;
	case 6:
		x = a2;		/* a2	*/
		break;
	case 7:
		x = a3;		/* a3	*/
	}
/*
 *****		select y input for adder
 */
	n = valbits(22,24,nan1);
	switch( n )
	{
	case 0:				/* bmcl	*/
	case 4:
		im = valbits(20,21,nan1);
		ic = valbits(22,22,nan1);
		il = valbits(25,26,nan1);
		y = 0;

		if( (im == 0) && (ic == 0) && (il == 0) )	break;
		y = b;
		if( ic == 0 )	y = y & SETC0;

		switch( im )
		{
		case 0:
			y = y & SETM0;
		case 1:
			break;
		case 2:
			if( y & SETM1 )
			{
				y = y & SETM0;
				break;
			}
		case 3:
			y = y | SETM1;
		}

		switch( il )
		{
		case 0:
			y = y & SETL0;
		case 1:
			break;
		case 2:
			if( y & 1 )
			{
				y = y & SETL0;
				break;
			}
		case 3:
			y = y | 1;
		}
		break;

	case 1:
		y = lit;		/* lit	*/
		break;
	case 2:
		y = ZEXT;		/* zext	*/
		break;
	case 3:
		y = ctr;		/* ctr	*/
		y = y << 24;
		break;
	case 5:
		y = (ctr << 24) | lit;	/* z	*/
		break;
	case 6:
		y = ampcr;		/* ampcr */
		break;
	case 7:
		y = bmar;		/* bmar	*/
	}
/*
 *	NOTE: z,bmar,zext are NOT listed in the BNF
 *	as possible y inputs.
 *	They were, however, in the Fortran programs and, with the
 *	exception of bmar, in table 4.4 in Katzan.
 *
 *
 *****		find adder operation to be done
 */
	addop = valbits(27,31,nan1);
	MST = FALSE;
	LST = FALSE;
	AOV = FALSE;
	ABT = FALSE;
	adout = adder(x,y,addop);
	if( adout & SETM1 )	MST = TRUE;
	if( adout & 1 )		LST = TRUE;
	if( (~adout) == 0 )	ABT = TRUE;

	if( !type2 )				/* type 1 instruction */
	{	/* check condition */
		con = valbits(1,4,nan2);	/* set/clear condition codes */
		if( valbits(5,5,nan2) == 0 )	k = TRUE;
		else	k = FALSE;
		if( cond[con] == k )	sc = FALSE;
		else	sc = TRUE;
/*
 *****			shift operation
 */
		shift = valbits(32,33,nan1);

		switch( shift )
		{
		case 0:				/* no shift */
			shout = adout;
			break;
		case 1:				/* logical right shift */
			shout = lsr(adout,sar);
			break;
		case 2:				/* logical left shift */
			shout = adout << (32 - sar);
			break;
		case 3:				/* circular shift */
			temp = lsr(adout,sar);
			shout = temp | (adout << (32 - sar));
		}
/*
 *****			select outputs
 */
		if( sc || (valbits(6,6,nan2) == 0) )
		{
			if( valbits(34,34,nan1) )	a1 = shout;	/* a1	*/
			if( valbits(35,35,nan1) )	a2 = shout;	/* a2	*/
			if( valbits(36,36,nan1) )	a3 = shout;	/* a3	*/
/*
 *****		b register select
 */
			n = valbits(37,40,nan1);

			switch( n )
			{
			case 0:
				break;				/* no select */
			case 1:					/* bc4	*/
			case 9:					/* bc8 */
				switch( addop & 017 )
				{
				case 3:
					y++;		/* x+y+1 */
				case 0:
					break;		/* x+y */
				case 5:
					y = y | x;	/* oad */
					break;
				case 10:
					y = y & x;	/* aad */
					break;
				case 12:
					y = ~y;		/* x-y-1 */
					break;
				case 15:
					y = (~y) + 1;	/* x-y */
					break;
				default:
					x = 0;		/* logic ops */
					y = 0;
				}
				b = 0;
				for( j=1 ; j<=4 ; j++ )
				{
					b1 = 0;
					if( overflow(x,y) || valbits(27,27,nan1) )	b1 = 0x30;
					x <<= 4;
					y <<= 4;
					if( n != 9 )
					{
						if( valbits(27,27,nan1) )
						{
							x1 = x & SETMB;
							y1 = y & SETMB;
						}
						else
						{
							x1 = x;
							y1 = y;
						}
						if( overflow(x1,y1) )	b1 |= 3;
					}
					b |= b1 << ((4-j) * 8);
					x <<= 4;
					y <<= 4;
				}
				break;

			case 8:					/* bad	*/
				b = adout;
				break;
			case 10:				/* bba	*/
				ir = adout;
				b = shout | ir;
				break;
			case 11:				/* b	*/
				b = shout;
				break;
			case 12:				/* bex	*/
				b = extbus;
				break;
			case 13:				/* bmi	*/
				b = mir;
				break;
			case 14:				/* bbe	*/
				ir = extbus;
				b = shout | ir;
				break;
			case 15:				/* bbi	*/
				ir = mir;
				b = shout | ir;
				break;
			default:
				printf(" Illegal b register input request");
				printf("\nAt line %d\n",mpm1);
				break;
			}
/*
 *****		other outputs - mir, ctr, lit, sar, etc.
 */
			if( valbits(41,41,nan1) )	mir = shout;		/* mir	*/
			if( valbits(42,42,nan1) )	ampcr = shout & 07777;	/* ampcr */
			byte2 = shout & SETC1;
			if( valbits(43,43,nan1) )	br[0] = byte2 / 256;	/* mar1	*/
			else	if( valbits(44,44,nan1) )	br[1] = byte2 / 256;	/* mar2	*/
			if( valbits(45,45,nan1) )
			{
				if( valbits(46,46,nan1) )	mar = shout & SETLB;	/* mar */
				else	mar = lit;				/* lmar	*/
			}

			switch( valbits(47,48,nan1) )
			{
			case 2:
				if( ctr < 255 )	ctr++;			/* inc	*/
				else
				{
					ctr = 0;
					COV = TRUE;
				}
			case 0:
				break;
			default:
				COV = FALSE;
				if( valbits(46,46,nan1) )	ctr = SETLB & ~shout;	/* ctr */
				else	ctr = SETLB & ~lit;			/* lctr	*/
			}

			if( valbits(49,49,nan1) )
			{
				sar = shout & SETL5;			/* sar	*/
				sar = (sar >> 1) + sar % 4;
			}
			else	if( valbits(50,50,nan1) )	sar = 32 - sar;	/* csar	*/
		}
/*
 *****			now set up successor
 */
		if( sc == FALSE )	n = valbits(14,16,nan2);
		else	n = valbits(11,13,nan2);

		switch( n )
		{
		case 3:
			mpcr++;			/* skip */
		case 1:
			mpcr++;			/* step */
		case 0:
			break;			/* wait */
		case 2:
			ampcr=mpcr++;		/* save */
			break;
		case 4:
			mpcr = (ampcr + 1) & AMASK;	/* jump */
			break;
		case 5:
			mpm1 = (ampcr + 1) & AMASK;	/* exec */
			break;
		case 6:
			save = mpcr;			/* call */
			mpcr = (ampcr + 1) & AMASK;
			ampcr = save;
			break;
		case 7:
			mpcr = (ampcr + 2) & AMASK;	/* retn */
		}

		if( n != 5 )
		{
			mpm1 = mpcr;
		}
/*
 *****		Now check for conditions which must be cleared when tested.
 */
			if( con==2 || con==3 || con>=8 )	cond[con] = FALSE;

/*
 *****		set or clear lc & gc condition codes.
 */
		if( sc || (valbits(7,7,nan2) == 0) )
		{
			n = valbits(8,10,nan2);

			switch( n )
			{
			case 1:			/* set lc2 */
				LC2 = TRUE;
			case 0:			/* no set */
				break;
			case 2:			/* set gc2 */
				GC2 = TRUE;
				break;
			case 3:			/* reset gc */
				GC1 = FALSE;
				GC2 = FALSE;
				break;
			case 4:			/* set int */
				INT = TRUE;
				break;
			case 5:			/* set lc3 */
				LC3 = TRUE;
				break;
			case 6:			/* set gc1 */
				GC1 = TRUE;
				break;
			case 7:			/* set lc1 */
				LC1 = TRUE;
			}
/*
 *****		memory operations
 */
			n = valbits(51,54,nan2);

			j = n & 1;
/*
 *	j is the index for br[], 0 for mr1, mw1 , 1 for mr2, mw2.
 *	reads, writes etc. using br[0] have even op-codes, and those
 *	using br[1] have odd op-codes.
 */
			addr = ((br[j] << 8) | mar) & SET16;
			if( (addr < SLIMIT) || (n > 7) || (n < 2) )
			{
				bmar = addr;
			}
			else
			{
				printf("S-memory bounds fault at %d\n",mpmsav);
				finishoff( clock );
				exit( 0 );
			}

			switch( n )
			{
			case 0:				/* no mdop */
				break;
			case 2:				/* mr1 */
			case 3:				/* mr2 */
				if( !nxtrdc )
				{
					datawt = smem[addr];
					nxtrdc = clock + nrdc;
				}
				else
				{
					ERROR1;
					finishoff( clock );
					exit( 0 );
				}
				break;
			case 6:				/* mw1 */
			case 7:				/* mw2 */
				if( !nxtsai )
				{
					smem[addr] = mir;
					nxtsai = clock + nsai;
				}
				else
				{
					ERROR1;
					finishoff( clock );
					exit( 0 );
				}
				break;
			case 10:			/* dr1 */
			case 11:			/* dr2 */
				datawt = devread( bmar );
				nxtrdc = clock + nrdc;
				break;
			case 14:			/* dw1 */
			case 15:			/* dw2 */
				devwrite( bmar );
				nxtsai = clock + nsai;
				break;
			default:
				printf("Illegal memory operation - nano(51-54) = %2d\n",n);
				finishoff( clock );
				exit( 0 );
			}
		}
	}
/*
 *****		type 2 instruction
 */
	else
	{
		mpm2 = mpm[mpm1];
		mpm1 = ++mpcr;
/*
 *	look at first hex digit of mpm word.
 */
		switch( (mpm2 >> 12) & 0xF )
		{
		case 016:			/* lit only */
			lit = (mpm2 & LMASK);
			break;
		case 014:			/* ampcr */
			ampcr = (mpm2 & AMASK);
			break;
		case 010:			/* sar and lit */
		case 011:
		case 012:
		case 013:
			lit = (mpm2 & LMASK);
		default:			/* sar */

/*			move mpm bits 7&8 to 6&7. */

			mpm2 = (mpm2 & ~03400) | ((mpm2 & 01400) << 1);
			sar = (mpm2 >> 9) & SMASK;
		}
	}


/*
 *****		check for completion of an I/O operation
 */
	if( nxtrdc == clock )
	{
		RDC = TRUE;
		nxtrdc = 0;
		extbus = datawt;		/* data transfer complete */
	}
	if( nxtsai == clock )
	{
		SAI = TRUE;
		nxtsai = 0;
	}
	if( (mpmsav >= outsrt) && (mpmsav <= outstp) )
	{
		skip++;
		if( (skip == outnm) )
		{
			skip = 0;
			outreg(clock,outflags);
			if( ((++linepr) > PAGE) && (outflags & 037) )
			{
				printf("***** too much output.\n");
				printf("Register dumps will be turned off.\n");
				outflags &= 0740;
			}
		}
	}
	if( trace == mpmsav )	outreg(clock,outflags);


/*
 *****		end of present clock period - prepare for next
 */
	clock++;
	phase = 2;
	if( (!type2) && (sc || (valbits(6,6,nan2) == 0)) )
	{
		phase++;
/*
 *	swap nano instructions
 */
		nan1 = nan2;
		p3new = p3sav;
	}
	type2 = FALSE;

/*
 *****		check for loops
 */
	if( mpmsav == mpm1 )
	{
		if( ++loop > 7 )
		{
			printf(" loop detected at mpm address - %d\n",mpm1);
			mpcr = ++mpm1;
			loop = 0;
		}
	}
	else	loop = 0;
	if( p3new == p3sav )	p3old = p3sav;
	if( (mpmsav == BREAK) && (outflags & 040) )
	{
		printf("Break requested at line %d\n",mpmsav);
		dumpmem();
		printf("You can now alter S-Memory.\n");
		fflush(stdout);
		readsmem(stdin, 0);
	}
/*
 *****		check for mpm address error
 */
	if( mpm1 >= MLIMIT )
	{
		printf("Next micro-program address out of range at %d\n",mpmsav);
		printf("The new address is %d.\n",mpm1);
		break;
	}
  }
/*
 *	Simulation loop ends here - now we do the end of run dumps.
 */
	if( (clock - 1) > maxclk )	printf("Brrring! %d clocks exceeded.\n",maxclk);
	finishoff( clock );
}
/*
 *	routine to call up the final dumps...
 */
finishoff( clock )
int	clock;
{
	printf("\n\nEnd of simulation. Registers contain:\n\n\n");
	outreg(clock,outflags | 037);
	if( outflags & 040 )	dumpmem();
}
/*
 *	routine to extract values from nano-instructions.
 */
valbits(from,to,ptr)
int	from,to;
register struct nano	*ptr;
{
	register int	i,mask;

	mask = 0;
/*
 *	Create mask for bits required - not pretty, but it works well.
 */
	for( i=from ; i<=to ; i++ )	mask = (mask << 1) | 1;

	if( from >= 43 )	return( mask & (ptr->d >> (54 - to)) );
	if( from >= 32 )	return( mask & (ptr->c >> (42 - to)) );
	if( from >= 17 )	return( mask & (ptr->b >> (31 - to)) );
	return( mask & (ptr->a >> (16 - to)) );
}
/*
 *	device read and write operations - there is no information
 *	in the book on how these should function. Consequently,
 *	they are set up to make life (relatively) easy for the
 *	user. If required, alterations should be easy...
 */
long	devread( addr )
unsigned int	addr;
{
	extern	long	atoli(),atolo(),lpack();
	register char	*ptr;

	fflush(stdout);
	if( readline(stdin, buf) > 0 )
	{
		ptr = buf;

		while( (*ptr == ' ') || (*ptr == '\t') )	ptr++;

		if( ('0' < *ptr) && (*ptr <= '9') )
		{
			return( atoli( ptr ) );
		}
		if( (*ptr == '0') )
		{
			return( atolo( ptr ) );
		}
		if( (*ptr != '\n') )
		{
			return( lpack( ptr ) );
		}
	}
	return( 0 );
}

devwrite( addr )
unsigned int	addr;
{
	register int	i,c;

	switch( addr )			/* addr selects conversion routine */
	{
	case 0:				/* long octal */
		printf("%lo\n",mir);
		break;
	case 1:				/* long decimal */
		printf("%ld\n",mir);
		break;
	case 2:				/* long hex */
		printf("%lx\n",mir);
		break;
	case 3:
		for( i=3 ; i>=0 ; i-- )
		{
			c = (mir >> (8 * i)) & 0377;
			if( c )	printf("%c",c);
		}
	}
	return;
}
