/*
 *      skill - signal a process and all its children
 *                             written by Bob Greenberg
 */
/*
 *	added code for gettable() instead of gprocs()
 *				Craig McGregor
 */

#include <defines.h>
#include <param.h>
#include <proc.h>		/* declares proc[NPROC] */

int *p__t, *p__te, p__sig;

skill(pid, sig)
{
	register int i, *n;

#ifndef	GETTAB
	if (gprocs(0) >= NPROC) return(-1);
	i = gprocs(proc);
#else	GETTAB
	if (gettab(0, NULL, sizeof proc) >= NPROC) return(-1);
	i = gettab(0, proc, sizeof proc);
#endif	GETTAB
	p__t = proc;
	p__te = &proc[i];
	p__sig = sig;
	return(sk_2(pid));
}

sk_2(pidd)
{
	register struct proc *p;
	register int n, pid;
	int n2;

	n = 0;
	pid = pidd;
	n2 = 1;
	for (p = p__t; p < p__te; p++)
	{
		if (p->p_stat == 0) continue;
		if (p->p_ppid == pid) n =| sk_2(p->p_pid);
		if (p->p_pid == pid) n2 = 0;
	}
	if (n2 == 0 && kill(pid,p__sig) < 0) n2 = 1;
	return(n2 | n);
}
