#include	<param.h>
#include	<proc.h>
#include	<signal.h>
#include	<dir.h>
#include	<user.h>
#include	<filsys.h>

main(ac, av)
char **av;
{
	register int fd;

	if (ac != 3)
	{
		printf("Usage: print table file\n");
		printf("  tables: p(roc), u(ser), s(uperblk)\n");
		exit(1);
	}
	if ((fd = open(av[2], 0)) == -1)
	{
		perror(av[2]);
		exit(1);
	}
	switch(av[1][0])
	{
    case 'p':	pproc(fd);
		break;
    case 'u':	puser(fd);
		break;
    case 's':	psuper(fd);
		break;
    default:	printf("Unrecognised table\n");
		exit(1);
	}
	exit(0);
}

pproc(fd)
{
	struct proc p;

	if (read(fd, &p, sizeof(struct proc)) != sizeof(struct proc))
	{
		printf("Proc wrong size\n");
		exit(1);
	}
	printf("Stat: ");
	switch(p.p_stat)
	{
    case NULL:		printf("NULL\n");
			return;
    case SSLEEP:	printf("SSLEEP\n");
			break;
    case SRUN:		printf("RUN\n");
			break;
    case SIDL:		printf("SIDL\n");
			break;
    case SZOMB:		printf("SZOMB\n");
			break;
    case SSTOP:		printf("SSTOP\n");
			break;
    default:		printf("Illegal stat 0%o\n", p.p_stat);
			return;
	}
	if (p.p_flag != 0)
	{
		printf("Flag:");
		if (p.p_flag & SLOAD)
			printf(" in core;");
		if (p.p_flag & SSYS)
			printf(" scheduler;");
		if (p.p_flag & SLOCK)
			printf(" cannot be swapped;");
		if (p.p_flag & SSWAP)
			printf(" being swapped out;");
		if (p.p_flag & STRC)
			printf(" being traced;");
		if (p.p_flag & SWTED)
			printf(" trace flag;");
		if (p.p_flag & SULOCK)
			printf(" user core lock;");
		p.p_flag &= ~(SLOAD|SSYS|SLOCK|SSWAP|STRC|SWTED|SULOCK);
		if (p.p_flag)
			printf(" illegal flag bits: 0%o", p.p_flag);
		printf("\n");
	}
	if (p.p_stat == SZOMB)
	{
		printf("uid %d\n", p.xp_uid);
		printf("pid %d ppid %d\n", p.xp_pid, p.xp_ppid);
		printf("Lnode 0%o\n", p.xp_lnode);
		printf("Exit status 0%o\n", p.xp_xstat);
		printf("User time %ld System time %ld\n", p.xp_utime, p.xp_stime);
		return;
	}
	printf("pri %d time %d cpu %d nice %d\n",
		p.p_pri, p.p_time, p.p_cpu, p.p_nice);
	printf("sig 0%o\n", p.p_sig);
	printf("uid %d pgrp %d pid %d ppid %d\n",
		p.p_uid, p.p_pgrp, p.p_pid, p.p_ppid);
	printf("lnode 0%o\n", p.p_lnode);
	printf("addr 0%o size %d wchan 0%o\n",
		p.p_addr, p.p_size, p.p_wchan);
	printf("textp 0%o\n", p.p_textp);
	printf("link 0%o\n", p.p_link);
	printf("clktim %d\n", p.p_clktim);
}

puser(fd)
{
	register unsigned *ip;
	struct user u;

	if (read(fd, &u, sizeof(struct user)) != sizeof(struct user))
	{
		printf("User wrong size\n");
		exit(1);
	}
	printf("rsav: ka5 0%o r2 0%o r3 0%o r4 0%o r5 0%o sp 0%o pc 0%o\n",
		u.u_rsav[0], u.u_rsav[1], u.u_rsav[2],
		u.u_rsav[3], u.u_rsav[4], u.u_rsav[5], u.u_rsav[6]);
	printf("fper 0%o fpsaved %d", u.u_fper, u.u_fpsaved);
	if (u.u_fpsaved == 0)
		printf("\n");
	else
	{
		printf(" fpsr 0%o\n", u.u_fps.u_fpsr);
		printf(" %18.16e %18.16e %18.16e\n",
			u.u_fps.u_fpregs[0],
			u.u_fps.u_fpregs[1],
			u.u_fps.u_fpregs[2]);
		printf(" %18.16e %18.16e %18.16e\n",
			u.u_fps.u_fpregs[3],
			u.u_fps.u_fpregs[4],
			u.u_fps.u_fpregs[5]);
	}
	printf("segflg: ");
	switch (u.u_segflg)
	{
    case USERD:	printf("userd\n");
		break;
    case KERND:	printf("kernd\n");
		break;
    case USERI:	printf("useri\n");
		break;
    default:	printf("illegal (%d)\n", u.u_segflg);
		break;
	}
	printf("error %d\n", u.u_error);
	printf("uid %d, gid %d, ruid %d, rgid %d\n",
		u.u_uid, u.u_gid, u.u_ruid, u.u_rgid);
	printf("procp 0%o\n", u.u_procp);
	printf("ap 0%o", u.u_ap);
	printf(" r0 0%o r1 0%o off/time %ld", u.u_r.r_r0, u.u_r.r_r1, u.u_r.r_off);
	printf(" dirp 0%o\n", u.u_dirp);
	printf("arg: ");
	for (ip = &u.u_arg[0]; ip < &u.u_arg[5]; ip++)
		printf(" 0%o", *ip);
	printf("\n");
	printf("base 0%o count %d offset %ld fmode 0%o\n",
		u.u_base, u.u_count, u.u_offset, u.u_fmode);
	printf("cdir 0%o, rdir 0%o\n", u.u_cdir, u.u_rdir);
	printf("dbuf: ");
	dirprint(u.u_dbuf);
	printf("\n");
	printf("dent ino %d, name: ", u.u_dent.d_ino);
	dirprint(u.u_dent.d_name);
	printf("\n");
	printf("pdir %d\n", u.u_pdir);
	printf("locki 0%o, lockf 0%o\n", u.u_locki, u.u_lockf);
	printf("uisa: ");
	for (ip = &u.u_uisa[0]; ip < &u.u_uisa[8]; ip++)
		printf(" 0%o", *ip);
	printf("\n      ");
	for (ip = &u.u_uisa[8]; ip < &u.u_uisa[16]; ip++)
		printf(" 0%o", *ip);
	printf("\n");
	printf("uisd: ");
	for (ip = &u.u_uisd[0]; ip < &u.u_uisd[8]; ip++)
		printf(" 0%o", *ip);
	printf("\n      ");
	for (ip = &u.u_uisd[8]; ip < &u.u_uisd[16]; ip++)
		printf(" 0%o", *ip);
	printf("\n");
	printf("ofile: ");
	for (ip = (unsigned *)&u.u_ofile[0]; ip < (unsigned *)&u.u_ofile[10]; ip++)
		printf(" 0%o", *ip);
	printf("\n       ");
	for (ip = (unsigned *)&u.u_ofile[10]; ip < (unsigned *)&u.u_ofile[NOFILE]; ip++)
		printf(" 0%o", *ip);
	printf("\n");
	printf("tsize %d dsize %d ssize %d\n", u.u_tsize, u.u_dsize, u.u_ssize);
	printf("qsav: ka5 0%o r2 0%o r3 0%o r4 0%o r5 0%o sp 0%o pc 0%o\n",
		u.u_qsav[0], u.u_qsav[1], u.u_qsav[2],
		u.u_qsav[3], u.u_qsav[4], u.u_qsav[5], u.u_qsav[6]);
	printf("ssav: ka5 0%o r2 0%o r3 0%o r4 0%o r5 0%o sp 0%o pc 0%o\n",
		u.u_ssav[0], u.u_ssav[1], u.u_ssav[2],
		u.u_ssav[3], u.u_ssav[4], u.u_ssav[5], u.u_ssav[6]);
	printf("signal: ");
	for (ip = &u.u_signal[0]; ip < &u.u_signal[NSIG]; ip++)
		printf(" 0%o", *ip);
	printf("\n");
	printf("utime %ld stime %ld cutime %ld cstime %ld\n",
		u.u_utime, u.u_stime, u.u_cutime, u.u_cstime);
	printf("ar0 0%o\n", u.u_ar0);
	if (u.u_prof.pr_scale)
		printf("Prof: base 0%o size %d off 0%o scale %d\n",
			u.u_prof.pr_base, u.u_prof.pr_size,
			u.u_prof.pr_off, u.u_prof.pr_scale);
	printf("sep %d\n", u.u_sep);
	printf("ttyp 0%o dev 0%o\n", u.u_ttyp, u.u_ttyd);
	printf("Ex: mag 0%o tsize %d dsize %d bsize %d ssize %d\n",
		u.u_exdata.ux_mag, u.u_exdata.ux_tsize,
		u.u_exdata.ux_dsize, u.u_exdata.ux_bsize,
		u.u_exdata.ux_ssize);
	printf("    entloc 0%o relflg %d\n", u.u_exdata.ux_entloc, u.u_exdata.ux_relflg);
	printf("comm: ");
	dirprint(u.u_comm);
	printf("\n");
	printf("start %ld\n", u.u_start);
	printf("acflag %d\n", u.u_acflag);
	printf("umask 0%o\n", u.u_cmask);
}

dirprint(s)
register char *s;
{
	register char *cp;

	cp = s;
	s += DIRSIZ;
	while (cp < s)
	{
		if (*cp < 040 || *cp > 0176)
			printf(" %03o", *cp & 0377);
		else
			printf(" %c", *cp);
		cp++;
	}
}

psuper(fd)
{
	register i;
	struct filsys s;

	if (read(fd, &s, sizeof(struct filsys)) != sizeof(struct filsys))
	{
		printf("Super blk wrong size\n");
		exit(1);
	}
	printf("isize %u fsize %ld\n", s.s_isize, s.s_fsize);
	printf("flock 0%o ilock 0%o\n", s.s_flock, s.s_ilock);
	printf("time %s", ctime(s.s_time));
	printf("free blks %d:", s.s_nfree);
	for (i = 0; i < s.s_nfree; i++)
	{
		if ((i & 07) == 0)
			printf("\n");
		printf(" %8ld", s.s_free[i]);
	}
	printf("\n");
	printf("free inodes %d:", s.s_ninode);
	for (i = 0; i < s.s_ninode; i++)
	{
		if ((i & 07) == 0)
			printf("\n");
		printf(" %7u", s.s_inode[i]);
	}
	printf("\n");
}
