#include	<sys/param.h>
#include	<sys/inode.h>
#include	<a.out.h>

char	*unixf;
char	*coref;
int	ufd, cfd;
struct inode inode[NINODE];

struct nlist nl[] =
{
	{ "_inode",	0, 0 },
	{ 0,		0, 0 },
};

main(ac, av)
char **av;
{
	register struct nlist *nlp;
	register struct inode *ip;
	unsigned slot;

	if (ac != 3)
	{
		printf("Usage: x unix core\n");
		exit(1);
	}
	unixf = av[1];
	coref = av[2];
	if ((ufd = open(unixf, 0)) == -1)
	{
		perror(unixf);
		exit(1);
	}
	if ((cfd = open(coref, 0)) == -1)
	{
		perror(coref);
		exit(1);
	}
	nlp = nl;
	nlist(unixf, nlp);
	if (nlp->n_value == 0 && nlp->n_type == 0)
	{
		printf("_inode not found\n");
		exit(1);
	}
	lseek(cfd, (long)nl[0].n_value, 0);
	read(cfd, inode, NINODE * sizeof(struct inode));
	slot = 0;
	printf("     Flg Cnt Device Inum Mode Nlnk Uid Gid Size Lkf Lkc\n");
	for (ip = inode; ip < &inode[NINODE]; ip++, slot++)
	{
		printf("%3d:", slot);
		printf(" %03d", ip->i_flag);
		printf(" %2d", ip->i_count);
		printf(" %2d/%2d", major(ip->i_dev), minor(ip->i_dev));
		printf(" %5d", ip->i_number);
		printf(" %06o", ip->i_mode);
		printf(" %2d", ip->i_nlink);
		printf(" %3d", ip->i_uid);
		printf(" %3d", ip->i_gid);
		printf(" %5ld", ip->i_size);
		printf(" %03", ip->i_lockf);
		printf(" %2d", ip->i_lockc);
		printf("\n");
	}
	exit(0);
}
