/*
 * C library -- readlock, writelock, unlock
 *
 *	readlock and writelock expect a file descriptor. unlock doesn't,
 *	as a process can only have one locked file open.
 */

#include	<fcntl.h>

readlock(fd)
{
	return(fcntl(fd, F_RLOCK, 0));
}

writelock(fd)
{
	return(fcntl(fd, F_WLOCK, 0));
}

unlock()
{
	return(fcntl(0, F_UNLOCK, 0));
}
