/*LINTLIBRARY*/

/*
**	This function deletes the password entry pointed to by "pe".
**	Both the uid and login name passed must correspond
**	with the password entry.
**	Returns 1 for success, 0 for failure, and PWERROR for error.
*/ 

#include	<pwr.h>


delpwent(pe)
	register struct pwent *pe;
{
	register struct pwent *rp;

	struct pwent p;
	long hte, te;
	register int ht;
	register int ri;

	ri = PWERROR;

	/*	open and lock */ 

	if ( pwopen( 1 ) == SYSERROR )
		return ri;

	/*	initialise */ 

	do
	{
		rp = &p;
		if(!getutab(pe->pw_limits.l_uid, &te))
			break;
		if(te == PWENTNULL)
			return(0);
		if((ri = equalentry(pe, &te)) != 1)
			break;
		ri = PWERROR;
		if(!getentry(rp, &te))
			break;

		/*	got elements and all ok, now delete */ 

		pe->pw_next = rp->pw_next;
		pe->pw_last = rp->pw_last;

		if(pe->pw_last == PWENTNULL)
		{
			/* a beginning of list item - update hash pointers */ 
			ht = pwhash(pe->pw_strings[LNAME]);
			if(!gethtab(ht, &hte))
				break;
			if(hte != te)
				break;
			hte = pe->pw_next;
			if(!puthtab(ht, &pe->pw_next))
				break;
		}

		if(pe->pw_next != PWENTNULL)
		{
			/* this element has a next in list */ 
			if(!getentry(rp, &pe->pw_next))
				break;
			rp->pw_last = pe->pw_last;
			if(!putentry(rp, &pe->pw_next))
				break;
		}

		if(pe->pw_last != PWENTNULL)
		{
			/* this element has a last in list */ 
			if(!getentry(rp, &pe->pw_last))
				break;
			rp->pw_next = pe->pw_next;
			if(!putentry(rp, &pe->pw_last))
				break;
		}

		/*	done - zap uid and return */ 

		te = PWENTNULL;
		if(!pututab(pe->pw_limits.l_uid, &te))
			break;

		ri = 1;
	}
	while(0);

	unlock();

	return(ri);
}
