/*LINTLIBRARY*/

/*
**	alters the passwd entry specified by "pe->pw_limits.l_uid" and "*pe->pw_strings[LNAME]
**	to contain the data in the area pointed to by "pe".
**	Returns 1 for success, 0 for failure and PWERROR for error
**	Note: the uid and login name MUST match
*/ 

#include	<pwr.h>


chngpwent(pe)
	register struct pwent *pe;
{
	register struct pwent *rp;

	struct pwent p;
	register int ht;
	register int ri;
	long hte, te, newt;

	ri = PWERROR;

	/*	open and lock	*/ 

	if ( pwopen( 1 ) == SYSERROR )
		return ri;

	/*	initialise	*/ 

	do
	{
		rp = &p;
		if(!getutab(pe->pw_limits.l_uid, &te))
			break;
		if((ri = equalentry(pe, &te)) != 1)
			break;
		ri = PWERROR;
		if(!getentry(rp, &te))
			break;

		/* got entry ok */ 

		pe->pw_next = rp->pw_next;
		pe->pw_last = rp->pw_last;

		/* add new entry before deleting old */ 

		if(addentry(pe, &newt) == PWERROR)
			break;

		/* now newt is the address of the added entry */ 

		if(pe->pw_last == PWENTNULL)
		{
			/* beginning of list - update the hash ptr */ 
			ht = pwhash(pe->pw_strings[LNAME]);
			if(!gethtab(ht, &hte))
				break;
			if(hte != te)
				break;
			if(!puthtab(ht, &newt))
				break;
		}

		if(pe->pw_next != PWENTNULL)
		{
			/* this element has a next in list */ 
			if(!getentry(rp, &pe->pw_next))
				break;
			rp->pw_last = newt;
			if(!putentry(rp, &pe->pw_next))
				break;
		}

		if(pe->pw_last != PWENTNULL)
		{
			/* this element has a last in list */ 
			if(!getentry(rp, &pe->pw_last))
				break;
			rp->pw_next = newt;
			if(!putentry(rp, &pe->pw_last))
				break;
		}

		/* done, zap the uid entry and that is all */ 

		if(!pututab(pe->pw_limits.l_uid, &newt))
			break;

		ri = 1;
	}
	while(0);

	unlock();

	return(ri);
}
