/*LINTLIBRARY*/

/*
**	mytty(): return "/dev/name" which is the name of the
**	tty belonging to current user.
**	The environment variable TTYNAME is searched for,
**	if it does not exist, then the utmp file is searched
**	for a device matching the command terminal.
*/

#include	<local-system>
#include	<types.h>
#include	<stat.h>
#include	<utmp.h>
#include	<fcntl.h>

#define		NULLSTR		(char *)0
static char	dev[]		= "/dev/";
static char	utmpf[]		= UTMPF;

extern char	*strncat();
extern char	*strcat();
extern char	*strcpy();
extern char	*getenv();
extern int	atoi();

char *
mytty()
{
	register char	*s;
	static char	tty[sizeof dev + LINESIZ];
	extern char *	_mytty();

	strcpy(tty, dev);

	if ( (s = getenv( "TTYNAME" )) == NULLSTR || *s < ' ' )
		return _mytty(tty);
	else
		return strcat(tty, s);
}




static char *
_mytty(buf)
	char *		buf;
{
	register char *	s;
	register	fd;
	struct utmp	utmp;
	struct stat	fsb;

	if ( !isatty(0) || fstat(0, &fsb) == SYSERROR )
		return NULLSTR;

	if ( (fd = open(utmpf, O_READ)) == SYSERROR )
		return NULLSTR;

	if ( (s = getenv("TTYSLOT")) != NULLSTR && *s >= '0' && *s <= '9' )
		lseek(fd, (long)(atoi(s)*sizeof utmp), 0);

	while ( read(fd, (char *)&utmp, sizeof utmp) == sizeof utmp )
	{
		if ( utmp.ut_line[0] != '\0' && utmp.ut_ttyid == fsb.st_rdev )
		{
			close(fd);
			return strncat(buf, utmp.ut_line, LINESIZ);
		}
		if ( s != NULLSTR && *s >= '0' && *s <= '9' )
			break;
	}

	close(fd);
	return NULLSTR;
}
