/*
 * touch - program to alter access and/or modification times
 */ 
char usage[] = "Usage: touch [-[amc]] [[[[[[yy]mm]dd]hh]mm]] file ...\n";
/*
 *	The -a flag alters only the access time.
 *	The -m flag alters only the modify time.
 *	The -c flag creates the file if it does not exist.
 *	NOTE: partial dates are with respect to the current time.
 *
 *	This program uses UTIME (2) to update the times on the files.
 *	It must therefore be setuid to root (at our installation).
 *	For mortals, the times can only be set to the current time.
 */

#include	<sys/types.h>
#include	<sys/stat.h>
#include	<time.h>

#define	W	02	/* for access system call */

struct utimbuf
{
	time_t actime;
	time_t modtime;
} tb;
extern char *ctime();
char *cbp;
struct stat stats;
time_t timbuf;

main(ac, av)
char **av;
{
	register char *cp;
	register int rac;
	register char **rav;
	register short count;
	register short uid;
	short status;		/* exit status */
	char modtime, acctime, create;

	count = 0;
	status = 0;
	modtime = 1;	/* default is ON */
	acctime = 1;	/* default is ON */
	create = 0;
	rac = ac - 1;
	rav = av + 1;		/* skip over command name */
	if (rac > 1 && (cp = rav[0])[0] == '-')
	{
		modtime = 0;
		acctime = 0;
		while (*++cp)
			switch(*cp)
			{
		    case 'a':	acctime++;
				break;

		    case 'm':	modtime++;
				break;

		    case 'c':	create++;
				break;

		    default:	write(2, usage, sizeof usage - 1);
				exit(-1);
			}
		rac--;
		rav++;
	}
	if (rac < 1)
	{
		write(2, usage, sizeof usage - 1);
		exit(-1);
	}
	cbp = *rav;
	uid = getuid();		/* real uid */
	time(&timbuf);
	if (rac > 1 && uid == 0 && gtime() == 0)
	{
		rac--;
		rav++;
	}
	ac = rac;
	av = rav;
	while (rac--)
	{
		if (stat(*rav, &stats) == -1)
		{
			if (create)
			{
				count++;
				rav++;
				continue;
			}
			status++;
			perror(*rav);
		}
		else if (uid && access(*rav, W) == -1)
		{
			status++;
			perror(*rav);
		}
		else
		{
			if (acctime == 0)
				tb.actime = stats.st_atime;
			else
				tb.actime = timbuf;
			if (modtime == 0)
				tb.modtime = stats.st_mtime;
			else
				tb.modtime = timbuf;
			if (utime(*rav, &tb) == -1)
			{
				status++;
				perror(*rav);
			}
		}
		*rav = 0;	/* zap successful args */
		rav++;
	}
	if (create == 0 || count == 0)
		exit(status);
	setuid(uid);
	rac = ac;
	rav = av;
	while (rac--)
	{
		if (*rav == 0)		/* arg zapped above */
		{
			rav++;
			continue;
		}
		if (creat(*rav, 0600) == -1)
		{
			status++;
			perror(*rav);
		}
		if (--count == 0)
			break;
		rav++;
	}
	exit(status);
}

gtime()
{
	register i, *ip;
	register struct tm *tvec;
	int y, t, d, h, m;
	char dst;	/* daylight saving flag */
	extern time_t time();
	extern struct tm *localtime();	/* in ctime.o */ 
	extern char dmsize[];		/* in ctime.o */ 
	extern int dysize();		/* in ctime.o */
	extern time_t timezone;		/* in ctime.o */

	tvec = localtime(timbuf);
	dst = tvec->tm_isdst;
	y = tvec->tm_year;
	t = tvec->tm_mon + 1;
	d = tvec->tm_mday;
	h = tvec->tm_hour;
	i = 0;
	ip = (int *)tvec;	/* use tm struct as a workarea */
	while ((*ip++ = gpair()) >= 0)
		if (i++ >= 5)
			return(1);
	if (i == 0)
		return(1);
	ip = (int *)tvec;

	switch(i)
	{
    case 5:	y = *ip++;
    case 4:	t = *ip++;
    case 3:	d = *ip++;
    case 2:	h = *ip++;
    case 1:	m = *ip++;
	}
	if (y < 70 || t < 1 || t > 12 || d < 1 || d > 31 || h > 23 || m > 59)
		return(1);
	y += 1900;
	timbuf = 0;
	for (i = 1970; i < y; i++)
		timbuf += dysize(i);
	if (dysize(y) == 366 && t >= 3)
		timbuf++;		/* leap year */
	while (--t)
		timbuf += dmsize[t-1];
	timbuf += d-1;
	timbuf = timbuf*24+h;
	timbuf = timbuf*60+m;
	timbuf = timbuf*60;
	if (dst)
		timbuf -= 60*60;	/* daylight saving correction */
	timbuf += timezone;	/* convert from local to GMT */
	return(0);
}

gpair()
{
	register int c, d;
	register char *cp;



	cp = cbp;
	if (*cp == 0)
		return(-1);
	c = (*cp++ -'0')*10;
	if (c < 0 || c > 100)
		return(-1);
	if (*cp == 0)
		return(-1);
	if ((d = *cp++ -'0') < 0 || d > 9)
		return(-1);
	cbp = cp;
	return(c+d);
}
