/*
 *	Big-brother-is-watching-YOU program.
 *	Prints out procs that are currently active on the given device,
 *	or accessing the given file.  Options allow for killing those procs,
 *	and exec'ing chk.
 *
 *	The program assumes that raw devices live in /dev (for chk),
 *	and are formed by adding 'r' to the block device name.
 *
 *				Kevin Hill
 */

#include	<local-system>
#include	<param.h>
#include	<proc.h>
#include	<dir.h>
#include	<signal.h>
#include	<user.h>
#include	<stat.h>
#include	<text.h>
#include	<file.h>
#include	<inode.h>
#include	<tty.h>
#include	<table.h>
#include	<setjmp.h>
#include	<stdio.h>

int	texts[NTEXT];			/* store inumber of actual file */
int	files[NFILE];
int	inodes[NINODE];

struct proc proc[NPROC];
struct inode inode;
struct text text;
struct file file;
struct user u;

#define	SIG	SIGTERM			/* sent to procs if k-flag set */

char ttyc[NTTYS + 1][2];		/* 2-char tty name */
int  ttyd[NTTYS + 1];			/* tty dev */

#define	NI	88			/* max nr. args to chk */
int	list[NI], li;

char	mem[] = "mem";
int	memfd;
char	swap[] = "swap";
int	swapfd;
char	devdir[] = "/dev";
int	devfd;
char	cant[] = "Can't find %s\n";
char	warning[] = "\007Warning: too many %s: recompile\n";
char	chk[] = "/bin/ncheck";
#define	CHK	5			/* offset to skip etc bin above */

int	dev, inum;
int	heading, col;			/* output listing controls */
int	pid, uid;
char	blkfile[16] = "r";		/* block-file name corresponding to given arg */
char killflag, chkflag, fileflag, textswap;

char args[512];

jmp_buf env;
struct table table[4];
#define	TPROC	0
#define	TTEXT	1
#define	TINODE	2
#define	TFILE	3


main(ac, av)
register char **av;
{
	register char *cp;
	char outbuf[BUFSIZ];

	while (av[1][0] == '-')
	{
		switch((*++av)[1])
		{
	    case 'f':	fileflag++;
			break;

	    case 'k':	printf("\n\tk flag: are you EXTREMELY sure?? ");
			if ((cp = getchar()) == 'y')
				killflag++;
			if (cp && cp != '\n')
				while (getchar() != '\n');
			break;

	    case 'n':	chkflag++;
			break;
		}
		ac--;
	}
	if (ac != 2)
	{
		printf("Usage: slook [-f][-k][-n] file\n");
		exit(1);
	}
	if (fileflag)
		chkflag = 0;
	if (stat(cp = *++av, args) == -1 || chdir(cp = devdir) == -1 ||
		((memfd = open(cp = mem, 0)) == -1) ||
		((swapfd = open(cp = swap, 0)) == -1) ||
		((devfd = open(cp = devdir, 0)) == -1))
	{
		printf(cant, cp);
		exit(1);
	}
	inum = args->st_ino;
	dev = args->st_dev;
	if (fileflag == 0)
	{
		if ((args->st_mode & S_IFMT) == S_IFBLK)
		{
			cp = av[0];
			dev = args->st_rdev;
			while ((blkfile[++col] = *cp++) && col < 14)
				if ((blkfile[col]) == '/')
					col = 0;
			blkfile[col + 1] = 0;
			col = 0;
		}
		else if (inum != ROOTINO)
		{
			printf("%s: illegal file\n", *av);
			exit(1);
		}
	}
	initdev();
	if (getaddr(G_PROC, &table[TPROC]) == -1 ||
	    getaddr(G_TEXT, &table[TTEXT]) == -1 ||
	    getaddr(G_INODE, &table[TINODE]) == -1 ||
	    getaddr(G_FILE, &table[TFILE]) == -1)
	{
		printf("Getaddr failed\n");
		exit(1);
	}
	if (table[TPROC].tb_num != NPROC ||
	    table[TPROC].tb_size != sizeof(struct proc) ||
	    table[TTEXT].tb_num != NTEXT ||
	    table[TTEXT].tb_size != sizeof(struct text) ||
	    table[TINODE].tb_num != NINODE ||
	    table[TINODE].tb_size != sizeof(struct inode) ||
	    table[TFILE].tb_num != NFILE ||
	    table[TFILE].tb_size != sizeof(struct file))
	{
		printf("\007Warning: recompile\n");
		exit(1);
	}
	setbuf(stdout, outbuf);
	nice(-20);		/* get some service */
	setjmp(env);	/* from `scanprocs' if inconsistent user found */
	heading = li = 0;
	scaninodes();
	scanprocs();
	nice(10);		/* back to earth */
	if (heading)
	{
		fflush(stdout);
		if (chkflag && li)
		{
			if (blkfile[1] == 0)
			{
				printf("Can't match dev %d/%d\n",
					major(dev), minor(dev));
				exit(1);
			}
			if (stat(blkfile, args) == -1)
				callchk(&blkfile[1]);
			else
				callchk(blkfile);
		}
	}
	else if (! killflag)
		if (textswap)
			printf("Text MAY be on swap device\n");
		else
			printf("Inode active, yet no procs found??\n");
	exit(0);
}


initdev()
{
	register n, console;
	register struct direct *dp;
	struct direct dbuf[32];		/* 32 * 16 = 512 */

	while ((n = read(devfd, dbuf, sizeof dbuf)) > 0)
	{
		n /= sizeof(struct direct);
		for (dp = dbuf; dp < &dbuf[n]; dp++)
		{
			if (dp->d_ino == 0 ||
			    strncmp(dp->d_name, "swap", DIRSIZ) == 0 ||
			    strncmp(dp->d_name, "tty", DIRSIZ) == 0)
				continue;
			console = strncmp(dp->d_name, "console", DIRSIZ);
			if (strncmp(dp->d_name, "tty", 3) == 0 || console == 0)
			{
				if (stat(dp->d_name, args) == -1 ||
				    (args->st_mode & S_IFMT) != S_IFCHR)
					continue;
				if (console == 0)
				{
					ttyc[li][0] = 'c';
					ttyc[li][1] = 'o';
				}
				else
				{
					ttyc[li][0] = dp->d_name[3];
					ttyc[li][1] = dp->d_name[4];
				}
				ttyd[li] = args->st_rdev;	/* major & minor tty numbers */
				if (++li > NTTYS)
				{
					printf(warning, "ttys");
					exit(1);
				}
				continue;
			}
			if (blkfile[1] == 0 &&
			    stat(dp->d_name, args) != -1 &&
			    (args->st_mode & S_IFMT) == S_IFBLK &&
			    args->st_rdev == dev)
			{
				strncpy(&blkfile[1], dp->d_name, DIRSIZ - 1);
			}
		}
	}
	ttyd[li] = -1;		/* end-of-list sentinel */
	li = 0;
}


scaninodes()
{
	register i, j;

	j = 1;
	{
		register struct inode *ip;

		ip = (struct inode *)table[TINODE].tb_addr;
		for (i = 0; i < NINODE; i++, ip++)
		{
			lseek(memfd, (long)ip, 0);
			read(memfd, &inode, 6);	/* flag, count, dev, inum */
			if (inode.i_count != 0 && inode.i_dev == dev &&
			    (! fileflag || inode.i_number == inum))
			{
				j = 0;
				inodes[i] = inode.i_number;
			}
		}
	}
	if (j)
	{
		printf("No active inode(s) found\n");
		exit(0);
	}
	{
		register struct text *tp;

		tp = (struct text *)table[TTEXT].tb_addr;
		tp = (struct text *)&tp->x_iptr;
		for (i = 0; i < NTEXT; i++, tp++)
		{
			lseek(memfd, (long)tp, 0);
			read(memfd, &(text.x_iptr), 3);	/* iptr and count */
			if (text.x_iptr != NULL)
			{
				unsigned temp;

				temp = (unsigned)text.x_iptr;
				temp -= table[TINODE].tb_addr;
				temp /= sizeof(struct inode);
				texts[i] = inodes[temp];
				if (texts[i] && text.x_count == 0 && fileflag)
				{
					textswap++;
					break;
				}
			}
		}
	}
	{
		register struct file *fp;

		fp = (struct file *)table[TFILE].tb_addr;
		for (i = 0; i < NFILE; i++, fp++)
		{
			lseek(memfd, (long)fp, 0);
			read(memfd, &file, sizeof(struct file));
			if (file.f_count != 0)
			{
				unsigned temp;

				temp = (unsigned)file.f_inode;
				temp -= table[TINODE].tb_addr;
				temp /= sizeof(struct inode);
				files[i] = inodes[temp];
			}
		}
	}
}


scanprocs()
{
	register struct proc *p;
	register i, j;
	int count;

	lseek(memfd, (long)table[TPROC].tb_addr, 0);
	read(memfd, proc, sizeof proc);
	for (count = 0, p = proc; p < &proc[NPROC]; p++, count++)
	{
		if (p->p_stat == 0 || p->p_stat == SZOMB)
			continue;
		i = ((unsigned)p->p_textp - table[TTEXT].tb_addr) / sizeof(struct text);
		pid = p->p_pid;
		uid = p->p_uid;
		readuser(p);
		if (p->p_textp != NULL && texts[i])
		{
			if (killflag)
			{
				kill(p->p_pid, SIG);
				continue;
			}
			print(1, texts[i]);
		}
		i = ((unsigned)u.u_procp - table[TPROC].tb_addr) / sizeof(struct proc);
		if (i != count)
		{			/* Inconsistent: p->p_addr->u_procp != p */
			printf("Retrying...\n");
			longjmp(env, 1);
		}
		i = ((unsigned)u.u_cdir - table[TINODE].tb_addr) / sizeof(struct inode);
		if (inodes[i])
		{
			if (killflag)
			{
				kill(p->p_pid, SIG);
				continue;
			}
			print(2, inodes[i]);
		}
		for (i = 0; i < NOFILE; i++)
		{
			if (u.u_ofile[i] == 0)
				continue;
			j = (((unsigned)u.u_ofile[i] & ~01) - table[TFILE].tb_addr) / sizeof(struct file);
			if (files[j])
			{
				if (killflag)
				{
					kill(p->p_pid, SIG);
					continue;
				}
				print(3, files[j]);
			}
		}
		if (col)
		{
			putchar('\n');
			col = 0;
		}
	}
}


readuser(p)
register struct proc *p;
{
	long useraddr, temp;

	if (p->p_flag & SLOAD)
	{
		temp = p->p_addr;
		temp = temp << 6;
		useraddr = temp + (long)&(0->u_procp);
		lseek(memfd, useraddr, 0);
		read(memfd, &u.u_procp, sizeof u.u_procp);
		useraddr = temp + (long)&(0->u_cdir);
		lseek(memfd, useraddr, 0);
		read(memfd, &u.u_cdir, sizeof u.u_cdir);
		useraddr = temp + (long)&(0->u_ofile[0]);
		lseek(memfd, useraddr, 0);
		read(memfd, &u.u_ofile[0], sizeof u.u_ofile);
		useraddr = temp + (long)&(0->u_ttyd);
		lseek(memfd, useraddr, 0);
		read(memfd, &u.u_ttyd, sizeof u.u_ttyd);
		useraddr = temp + (long)&(0->u_comm[0]);
		lseek(memfd, useraddr, 0);
		read(memfd, &u.u_comm[0], sizeof u.u_comm);
	}
	else
	{
		useraddr = p->p_addr;
		useraddr--;			/* really + swplo */
		useraddr = useraddr << 9;
		lseek(swapfd, useraddr, 0);
		read(swapfd, &u, sizeof u);
	}
}


print(newcol, inum)
register newcol;
{
	register char *cp;
	int fdes[2];

	if (heading == 0)
	{
		printf("TTY   NAME     PID   UID  TEXT  CDIR  FILES ...\n");
		heading++;
	}
	if (col == 0)
	{
		printf("%2.2s: %-8.8s %5d %5d", findtty(), u.u_comm, pid, uid);
		col = 1;
	}
	while (col++ < newcol)
		printf("      ");
	printf(" %5d", inum);
	if (chkflag)
		addtolist(inum);
}


findtty()
{
	register m, n;

	n = 0;
	while ((m = ttyd[n]) != -1)
	{
		if (m == u.u_ttyd)
			return(ttyc[n]);
		n++;
	}
	return("??");
}


addtolist(inum)
register inum;
{
	register *lp;

	for (lp = list; lp != &list[li] && *lp != inum; lp++);
	if (lp == &list[li] && li != NI)
	{
		*lp = inum;
		li++;
	}
}


char *itoa(p, n)
char *p;
register unsigned n;
{
	register char *sp, *rp;
	char stack[6];

	rp = p;
	sp = stack;
	*sp++ = 0;
	while (n)
	{
		*sp++ = n % 10 + '0';
		n /= 10;
	}
	while (*rp++ = *--sp)
		if (rp >= &args[sizeof args])
			return(p);
	return(rp);
}


callchk(filsys)
register char *filsys;
{
	register i;
	register char *cp;
	char *arglist[NI + 4];

	close(memfd);
	close(swapfd);
	close(devfd);
	arglist[0] = &chk[CHK];
	arglist[1] = "-i";
	arglist[(i = li) + 2] = filsys;
	arglist[i + 3] = 0;
	cp = args;
	while (i--)
	{
		arglist[i + 2] = cp;
		cp = itoa(cp, list[i]);
	}
	for (i = 0; arglist[i] != 0; i++)
		printf(" %s", arglist[i]);
	putchar('\n');
	execv(chk, arglist);
	printf(cant, chk);
	exit(1);
}
