#include	<stdio.h>
#include	<local-system>
#include	<param.h>
#include	<stat.h>
#include	<ino.h>
#include	<filsys.h>

struct dinode inodes[32];
struct filsys supblk;

int	ncnum;		/* inode number from ncheck output */
char	ncnam[200];	/* file name from ncheck output */
FILE	*filep;

main(argc,argv)
int argc;
char **argv;
{
	register int *ip, *xp, i ,n;
	int ipc;		/* count of inodes updated */
	unsigned int inum;	/* counter for inodes looked at */
	unsigned int ino;	/* number of inodes to look at */
	int fd;			/* filesystem access */
	struct stat sbuf;	/* for stat of marker-file */
	int upino[2000];	/* hold updated inode numbers */
	FILE *popen();

	if( argc != 3 )
	{
		printf("Usage: oscar marker-file raw-file-sys\n");
		exit(1);
	}
	sys( stat(argv[1],&sbuf), argv[1] );


	strcpy(ncnam, "ncheck ");
	strcat(ncnam, argv[2]);
	filep = popen(ncnam, "r");
	sys( fd = open(argv[2],0) , argv[2] );
	sys( lseek(fd,512L,1) , "seek" );
	sys( n = read(fd,&supblk,512) , "read" );
	ino = (supblk.s_isize - 2) * ( 512 / sizeof inodes[0] );	/* total inodes */
	inum = 0;
	ip = upino;
	ipc = 0;
	sync();
	while( (n = read(fd,inodes,sizeof inodes)) > 0 )
	{
		n = n / sizeof inodes[0];	/* number of inodes this slurp */
		for( i = 0 ; i < n ; i++ )
		{
			if( inum++ == ino )
				goto done;
			if ((inodes[i].di_mode&S_IFMT) != S_IFREG)
				continue;	/* not plain file */
			if( sbuf.st_mtime >= inodes[i].di_mtime )
				continue;	/* not updated */
			*ip++ = inum;		/* remember them */
			ipc++;			/* and count them */
		}
	}
  done:
	if (ipc == 0)
		exit(0);
	while ((fd = getc(filep)) != EOF && fd != '\n');	/* skip first line */
	while( getline() )
	{
		xp = upino;
		while( xp != ip )
		{
			if( *xp++ == ncnum )
			{
				printf("%s\n",ncnam);
				xp[-1] = -1; /* not again */
				if( --ipc == 0 ) exit(0);
				break;
			}
		}
	}
	pclose(filep);
	exit(0);
}

sys( sysret , argindic )
{
	if( sysret != -1 )
		return;
	perror(argindic);
	exit(1);
}

getline()
{
	register char c;
	register char *p;

	while( (c=getc(filep)) != EOF )
	{
		ncnum = c - '0';
		while( (c=getc(filep)) != '\t' )
			ncnum = ncnum * 10 + c - '0';
		p = ncnam;
		getc(filep);	/* no leading slash */
		while( (c=getc(filep)) != '\n' )
			*p++ = c;
		*p = 0;
		return 1;
	}
	return 0;
}
