/*
**	list file or directory
**	define DOTSUP to suppress listing of files beginning with dot
*/

#include	<local-system>
#include	<sys/param.h>
#include	<sys/stat.h>
#include	<sys/dir.h>
#include	<passwd.h>
#include	<stdio.h>

#define	DOTSUP	1
#define	NFILES	1024
#define	ISARG	0100000
#define	DIRECT	10	/* Number of direct blocks */
#define	INDIR	128	/* Number of pointers in an indirect block */
#define	INSHFT	7	/* Number of right shifts to divide by INDIR */


struct	lbuf
{
	union
	{
		char	lname[15];
		char	*namep;
	} 
		ln;
	char	ltype;
	short	lnum;
	short	lflags;
	short	lnl;
	short	luid;
	short	lgid;
	long	lsize;
	long	lmtime;
};

struct	lbuf	*flist[NFILES];
struct	lbuf	**lastp = flist;
struct	lbuf	**firstp = flist;
struct	lbuf	*gstat();

FILE	*grpf, *dirf;

int	aflg, dflg, lflg, sflg, tflg, uflg, iflg, fflg, gflg, cflg;
int	rflg = 1;
int	flags;
int	lastuid	= -1;
int	statreq;

char	*dotp = ".";
char	*makename();
char	tbuf[64];
char	*ctime();
char	stdbuf[BUFSIZ];

long	nblock();
long	tblocks;
long	year, now;



main(argc, argv)
	int			argc;
	char *			argv[];
{
	register struct lbuf *	ep;
	register struct lbuf **	ep1;
	register struct lbuf **	slastp;
	register struct lbuf **	epp;
	register		i;
	struct lbuf		lb;
	int			err = 0;
	int			amino;
	int			opterr = 0;
	int			c;
	extern int		compar();
	extern long		time();
	extern char *		optarg;
	extern int		optind;

#ifdef STANDALONE
	if (argv[0][0] == '\0')
		argc = getargv("ls", &argv, 0);
#endif
	setbuf(stdout, stdbuf);
	lb.lmtime = time((long *) NULL);
	year = lb.lmtime - 6L*30L*24L*60L*60L; /* 6 months ago */
	now = lb.lmtime + 60;
	while ((c=getopt(argc, argv, "asdglrtucif")) != EOF) switch(c)
	{
	case 'a':
		aflg++;
		continue;

	case 's':
		sflg++;
		statreq++;
		continue;

	case 'd':
		dflg++;
		continue;

	case 'g':
		gflg++;
		continue;

	case 'l':
		lflg++;
		statreq++;
		continue;

	case 'r':
		rflg = -1;
		continue;

	case 't':
		tflg++;
		statreq++;
		continue;

	case 'u':
		uflg++;
		continue;

	case 'c':
		cflg++;
		continue;

	case 'i':
		iflg++;
		continue;

	case 'f':
		fflg++;
		continue;

	case '?':
		opterr++;
		continue;
	}
	if(opterr)
	{
		fprintf(stderr,"usage: ls -asdglrtucif file . . .\n");
		exit(2);
	}
	if (fflg)
	{
		aflg++;
		lflg = 0;
		sflg = 0;
		tflg = 0;
		statreq = 0;
	}
	if(lflg && gflg)
	{
		grpf = fopen("/etc/group", "r");
	}
	if ((amino=(argc-optind))==0)
	{
		argv[optind] = dotp;
	}
	for (i=0; i < (amino ? amino : 1); i++)
	{
		if ((ep = gstat((*argv[optind] ? argv[optind] : dotp), 1))==NULL)
		{
			err = 2;
			optind++;
			continue;
		}
		ep->ln.namep = (*argv[optind] ? argv[optind] : dotp);
		ep->lflags |= ISARG;
		optind++;
	}
	qsort(firstp, lastp - firstp, sizeof *lastp, compar);
	slastp = lastp;
	for (epp=firstp; epp<slastp; epp++)
	{
		ep = *epp;
		if (ep->ltype=='d' && dflg==0 || fflg)
		{
			if (amino>1)
				printf("\n%s:\n", ep->ln.namep);
			lastp = slastp;
			readdir(ep->ln.namep);
			if (fflg==0)
				qsort(slastp, lastp - slastp, sizeof *lastp, compar);
			if (lflg || sflg)
				printf("total %ld\n", tblocks);
			for (ep1=slastp; ep1<lastp; ep1++)
				pentry(*ep1);
		} 
		else 
			pentry(ep);
	}
	exit(err);
}

pentry(ap)
struct lbuf *ap;
{
	struct	{
		char	dminor,
		dmajor;
	};
	register struct lbuf *p;
	register char *cp;

	p = ap;
	if (p->lnum == -1)
		return;
	if (iflg)
		printf("%5d ", p->lnum);
	if (sflg)
		printf("%4ld ", nblock(p->lsize));
	if (lflg)
	{
		putchar(p->ltype);
		pmode(p->lflags);
		printf("%3d ", p->lnl);
		if (getname(p, tbuf)==0)
			printf("%-8.8s", tbuf);
		else
			printf("%-8u", gflg?p->lgid:p->luid);
		if (p->ltype=='b' || p->ltype=='c')
			printf("%3d,%3d", major((int)p->lsize), minor((int)p->lsize));
		else
			printf("%7ld", p->lsize);
		cp = ctime(p->lmtime);
		if((p->lmtime < year) || (p->lmtime > now))
			printf(" %-7.7s %-4.4s ", cp+4, cp+20);
		else
			printf(" %-12.12s ", cp+4);
	}
	if (p->lflags&ISARG)
		printf("%s\n", p->ln.namep);
	else
		printf("%.14s\n", p->ln.lname);
}

getname(p, buf)
	register struct lbuf *	p;
	register char		buf[];
{
	struct pwent		pe;
	char			sbuf[SSIZ];

	if ( lastuid == (gflg?p->lgid:p->luid) )
		return 0;

	pe.pw_limits.l_uid = p->luid;

	if ( getpwlog(&pe, sbuf, SSIZ) != PWERROR )
	{
		if ( gflg && pe.pw_gid != p->lgid )
		{
			pe.pw_limits.l_uid = p->lgid;

			if ( getpwlog(&pe, sbuf, SSIZ) == PWERROR )
				return -1;
		}

		lastuid = pe.pw_limits.l_uid;
		strcpy(buf, pe.pw_strings[LNAME]);
		return 0;
	}

	return -1;
}

long nblock(size)
long size;
{
	long blocks, tot;

	blocks = tot = (size + 511) >> 9;
	if(blocks > DIRECT)
		tot += ((blocks - DIRECT - 1) >> INSHFT) + 1;
	if(blocks > DIRECT + INDIR)
		tot += ((blocks - DIRECT - INDIR - 1) >> (INSHFT * 2)) + 1;
	if(blocks > DIRECT + INDIR + INDIR*INDIR)
		tot++;
	return(tot);
}

int	m1[]	= { 1, S_IREAD>>0, 'r', '-' };
int	m2[]	= { 1, S_IWRITE>>0, 'w', '-' };
int	m3[]	= { 2, S_ISUID, 's', S_IEXEC>>0, 'x', '-' };
int	m4[]	= { 1, S_IREAD>>3, 'r', '-' };
int	m5[]	= { 1, S_IWRITE>>3, 'w', '-' };
int	m6[]	= { 2, S_ISGID, 's', S_IEXEC>>3, 'x', '-' };
int	m7[]	= { 1, S_IREAD>>6, 'r', '-' };
int	m8[]	= { 1, S_IWRITE>>6, 'w', '-' };
int	m9[]	= { 2, S_ISVTX, 't', S_IEXEC>>6, 'x', '-' };

int	*m[]	= { m1, m2, m3, m4, m5, m6, m7, m8, m9};

pmode(aflag)
{
	register int **mp;

	flags = aflag;
	for (mp = &m[0]; mp < &m[sizeof(m)/sizeof(m[0])];)
		select(*mp++);
}

select(pairp)
register int *pairp;
{
	register int n;

	n = *pairp++;
	while (--n>=0 && (flags&*pairp++)==0)
		pairp++;
	putchar(*pairp);
}

char *
makename(dir, file)
char *dir, *file;
{
	static char dfile[100];
	register char *dp, *fp;
	register int i;

	dp = dfile;
	fp = dir;
	while (*fp)
		*dp++ = *fp++;
	*dp++ = '/';
	fp = file;
	for (i=0; i<DIRSIZ; i++)
		*dp++ = *fp++;
	*dp = 0;
	return(dfile);
}

readdir(dir)
char *dir;
{
	static struct direct dentry;
	register int j;
	register struct lbuf *ep;

	if ((dirf = fopen(dir, "r")) == NULL)
	{
		fflush(stdout);
		fprintf(stderr, "%s unreadable\n", dir);
		return;
	}
	tblocks = 0;
	for(;;)
	{
		if (fread((char *) &dentry, sizeof(dentry), 1, dirf) != 1)
			break;
		if (dentry.d_ino==0
		    || aflg==0 && dentry.d_name[0]=='.' 
#ifndef DOTSUP
		    && (dentry.d_name[1]=='\0' || dentry.d_name[1]=='.'
		    && dentry.d_name[2]=='\0')
#endif
		    )
			continue;
		ep = gstat(makename(dir, dentry.d_name), 0);
		if (ep==NULL)
			continue;
		if (ep->lnum != -1)
			ep->lnum = dentry.d_ino;
		for (j=0; j<DIRSIZ; j++)
			ep->ln.lname[j] = dentry.d_name[j];
	}
	fclose(dirf);
}

struct lbuf *
gstat(file, argfl)
char *file;
{
	struct stat statb;
	register struct lbuf *rep;
	static int nomocore;
	extern char *	malloc();

	if (nomocore)
		return(NULL);
	rep = (struct lbuf *)malloc((unsigned)sizeof(struct lbuf));
	if (rep==NULL)
	{
		fprintf(stderr, "ls: out of memory\n");
		nomocore = 1;
		return(NULL);
	}
	if (lastp >= &flist[NFILES])
	{
		static int msg;
		lastp--;
		if (msg==0)
		{
			fprintf(stderr, "ls: too many files\n");
			msg++;
		}
	}
	*lastp++ = rep;
	rep->lflags = 0;
	rep->lnum = 0;
	rep->ltype = '-';
	if (argfl || statreq)
	{
		if (stat(file, &statb)<0)
		{
			fprintf(stderr, "%s not found\n", file);
			statb.st_ino = -1;
			statb.st_size = 0;
			statb.st_mode = 0;
			if (argfl)
			{
				lastp--;
				return(NULL);
			}
		}
		rep->lnum = statb.st_ino;
		rep->lsize = statb.st_size;
		switch(statb.st_mode&S_IFMT)
		{
		case S_IFLOK:
			rep->ltype = 'L';
			break;

		case S_IFALK:
			rep->ltype = 'A';
			break;

		case S_IFDIR:
			rep->ltype = 'd';
			break;

		case S_IFBLK:
			rep->ltype = 'b';
			rep->lsize = statb.st_rdev;
			break;

		case S_IFCHR:
			rep->ltype = 'c';
			rep->lsize = statb.st_rdev;
			break;

/*	No named pipes yet - KFH
		case S_IFIFO:
			rep->ltype = 'p';
			break;
*/
		}
		rep->lflags = statb.st_mode & ~S_IFMT;
		rep->luid = statb.st_uid;
		rep->lgid = statb.st_gid;
		rep->lnl = statb.st_nlink;
		if(uflg)
			rep->lmtime = statb.st_atime;
		else if (cflg)
			rep->lmtime = statb.st_ctime;
		else
			rep->lmtime = statb.st_mtime;
		tblocks += nblock(statb.st_size);
	}
	return(rep);
}

compar(pp1, pp2)
struct lbuf **pp1, **pp2;
{
	register struct lbuf *p1, *p2;

	p1 = *pp1;
	p2 = *pp2;
	if (dflg==0)
	{
		if (p1->lflags&ISARG && p1->ltype=='d')
		{
			if (!(p2->lflags&ISARG && p2->ltype=='d'))
				return(1);
		} 
		else
		{
			if (p2->lflags&ISARG && p2->ltype=='d')
				return(-1);
		}
	}
	if (tflg)
	{
		if(p2->lmtime == p1->lmtime)
			return(0);
		if(p2->lmtime > p1->lmtime)
			return(rflg);
		return(-rflg);
	}
	return(rflg * strcmp(p1->lflags&ISARG? p1->ln.namep: p1->ln.lname,
	p2->lflags&ISARG? p2->ln.namep: p2->ln.lname));
}
