/*
 *
 *	UNIX debugger
 *
 */

#include "defs.h"


char		BADFIL[];

struct symtab	symbol;
char		localok;
int		lastframe;
struct symslave	*symvec;
unsigned	maxoff;
long int	maxstor;

/*
 * symbol management
 */
long int	symbas;
long int	symcnt;
long int	symnum;
long int	localval;
char		symrqd = -1;
struct symtab	symbuf[SYMSIZ];
struct symtab	*symnxt;
struct symtab	*symend;

int		fsym;
char		*errflg;
unsigned	findsym();

/*
 * symbol table and file handling service routines
 */
longseek(f, a)
long int a;
{
	return(lseek(f, a, 0) != -1);
}

valpr(v, idsp)
{
	unsigned d;

	d = findsym(v, idsp);
	if (d < maxoff)
	{
		printf("%.8s", symbol.symc);
		if (d)
			printf(OFFMODE, d);
	}
}

localsym(cframe)
long int cframe;
{
	int symflg;

	while (nextsym() && localok && symbol.symc[0] != '~'
		&& (symflg = symbol.symf) != 037)
	{
		if (symflg >= 2 && symflg <= 4)
		{
			localval = symbol.symv;
			return(TRUE);
		}
		else if (symflg == 1)
		{
			localval = leng(shorten(cframe) + symbol.symv);
			return(TRUE);
		}
		else if (symflg == 20 && lastframe)
		{
			localval = leng(lastframe + 2 * symbol.symv - 10);
			return(TRUE);
		}
	}
	return(FALSE);
}

psymoff(v, type, s)
long int v;
int type;
char *s;
{
	unsigned w;

	w = findsym(shorten(v), type);
	if (w >= maxoff)
		printf(LPRMODE, v);
	else
	{
		printf("%.8s", symbol.symc);
		if (w)
			printf(OFFMODE, w);
	}
	printf(s);
}

unsigned
findsym(svalue, type)
unsigned svalue;
int type;
{
	long int diff, value, symval, offset;
	int symtyp;
	register struct symslave *symptr;
	struct symslave	*symsav;

	value = svalue;
	diff = 0377777L;
	symsav = 0;
	if (type != NSYM && (symptr = symvec))
	{
		while (diff && (symtyp = symptr->typslave) != ESYM)
		{
			if (symtyp == type)
			{
				symval = leng(symptr->valslave);
				if (value-symval < diff && value >= symval)
				{
					diff = value - symval;
					symsav = symptr;
				}
			}
			symptr++;
		}
		if (symsav)
		{
			offset = leng(symsav - symvec);
			symcnt = symnum - offset;
			longseek(fsym, symbas + offset * SYMTABSIZ);
			read(fsym, &symbol, SYMTABSIZ);
		}
	}
	return(shorten(diff));
}

nextsym()
{
	if ((--symcnt) < 0)
		return(FALSE);
	else
		return(longseek(fsym, symbas + (symnum - symcnt) * SYMTABSIZ) != 0 &&
			read(fsym, &symbol, SYMTABSIZ) == SYMTABSIZ);
}


/*
 * sequential search through file
 */
symset()
{
	symcnt = symnum;
	symnxt = symbuf;
	if (symrqd)
	{
		longseek(fsym, symbas);
		symread();
		symrqd = FALSE;
	}
	else
		longseek(fsym, symbas + sizeof symbuf);
}

struct symtab *
symget()
{
	register int rc;

	if (symnxt >= symend)
	{
		rc = symread();
		symrqd = TRUE;
	}
	else
		rc = TRUE;
	if (--symcnt > 0 && rc == 0)
		errflg = BADFIL;
	return((symcnt >= 0 && rc) ? symnxt++ : 0);
}

symread()
{
	int symlen;

	if ((symlen = read(fsym, symbuf, sizeof symbuf)) >= SYMTABSIZ)
	{
		symnxt = symbuf;
		symend = &symbuf[symlen / SYMTABSIZ];
		return(TRUE);
	}
	else
		return(FALSE);
}
