/*
 * Common block for lineprinter drivers
 */

/*
 * Select various options in lp drivers etc.
 */
/*#define	XTRANS		/* half ascii printers */
#define	XPLOT		/* plotter devices */
#define	XPACK		/* packed plot files */
#define	XFLUSH		/* output flush */
#define	XESC		/* escape codes */
#define	XKRONOS		/* kronos EOF, EOR */
#define	XVTAB		/* vertical tab */
#define	X6LPI		/* 6 lines/inch on 11" paper */

struct	lpst {
	int			flag;		/* mode flags */
#define	TRNS		0000001		/* if half ascii */
#define	THROW		0000002		/* throw page on open/close */
#define	FEED		0000004		/* if always take ff's, lf's */
#define	VTAB		0000010		/* support vertical tabs */
#define	NOEJECT		0000020		/* if disable auto skip */
#define	TMPNOEJ		0000040		/* temporary no eject */
#define	PLTTR		0000100		/* if a plotter */
#define	PACK		0000200		/* if packed plot mode */
#define	FLUSH		0000400		/* flush all & return error */
#define	SIXLPI		0001000		/* 6 lines/inch on 11" paper */
#define	NOFF		0002000		/* no hardware formfeeds */
#define	NOVT		0004000		/* no hardware vertical tabs */
/*			0010000		/* ?? */
#define	NOCUT		0020000		/* no plotter cutter */
#define	XBUSY		0040000		/* copy of OPEN - for gtty */
#define	LPERROR		0100000		/* error bit set in status register */
	int			state;		/* internal state */
#define	OPEN		0000001		/* device open for writing */
#define	CLOSIN		0000002		/* device closing */
#define	WOPEN		0000004		/* waiting for open */
#define	RUNNING		0000010		/* device running (interrupt enabled) */
#define	ESCAPE		0000020		/* null byte escape found */
					/* or 377/376 for print mode */
#define	SPFUNC		0000040		/* special function found */
#define	OUTPUT		0000100		/* doing output string */
#define	EXPAND		0000200		/* doing multiple characters */
#define	LFEEDS		0000400		/* doing line feeds */
#define	CONTROL		0001000		/* special function pending */
#define	OPRINT		0002000		/* doing overprint of '-' for XTRANS option */
#define	LPBUSY		(OUTPUT|EXPAND|LFEEDS|CONTROL)
	unsigned int		bfree;		/* number of buffers unused */
	struct buf		*bfwd;		/* first buffer in chain */
	struct buf		*blst;		/*  last buffer in chain */
	int			*lpaddr;	/* device register address */
	unsigned int		ejline;		/* lines per page (settable) */
	unsigned int		maxcol;		/* columns per line (settable) */
	unsigned int		ocol;		/* output column */
	unsigned int		icol;		/* input column */
	unsigned int		olin;		/* output line */
	unsigned int		ilin;		/* input line */
	unsigned int		bc;		/* byte count */
	char			*ba;		/* next char in buffer */
	unsigned int		qcnt;		/* OUTPUT:	length of output string */
						/* EXPAND:	number of repitions of character */
						/* LFEEDS:	number of blank lines */
						/* CONTROL:	control function */
	char			*qptr;		/* OUTPUT:	output string */
	char			qfc;		/* EXPAND:	duplicated char */
	int			(*fput)();	/* run print routines */
	int			(*ffunc)();	/* special function */
	};

/*
 * Encoding of output commands
 *	...func(plp, c);
 *		plp :: printer structure
 *		c :: control character
 *			0 - open
 *			1 - close
 *			-1 - interrupt
 *	...put(plp);
 *
 * 1.	OUTPUT mode
 *		prints string of graphic characters
 *			cnt = plp->qcnt;
 *			ptr = plp->qptr;
 * 2.	EXPAND mode
 *		prints multiple copies of a graphic character
 *			cnt = plp->qcnt;
 *			chr = plp->qfc;
 * 3.	LFEEDS mode
 *		prints (plp->qcnt) linefeeds
 * 4.	CONTROL mode
 *		performs function in (plp->qcnt)
 *		print mode:
 *			\r, \f, \013
 *		plot mode:
 *			0400|EOL, 0400|EOT, 0400|FORM, 0400|CUT
 */

#define	BMAX		3		/* maximum number of buffers used per device */

#define	XMODES		(PLTTR|XBUSY|LPERROR)	/* the bits cannot be changed by stty call */

/*
 * some special function codes - plot mode
 */
#define	EOL		012		/* line flush */
#define	FORM		014		/* line flush + 2.5 inches */
#define	EOT		004		/* line flush + 8.0 inches */
#define	CUT		021		/* line flush + cut paper */
#define	UPACKMD		000		/* set to unpacked mode */
