/*
**	con [-quit-char] remote_tty[^quit-char]
**
**	Connect user to remote machine:- assumes "conn"
**	 or intelligent "getty" exists on any intermediate machine.
**
**	If a "connect-wise" getty IS installed, then "CON_GETTY"
**	 must be defined in <local-system>.
**
**	Bob Kummerfeld - Basser - MAY 80
*/

#include	<local-system>
#ifdef	Aus2
#include	<types.h>
#include	<stat.h>
#include	<dir.h>
#include	<sgtty.h>
#endif	Aus2
#include	<passwd.h>
#ifdef	Aus1
#include	<lnode.h>
#include	<stat16.h>
#include	<dir.h>
#include	"lvl7.h"
#endif	Aus1
#include	<errno.h>
#include	<signal.h>
#include	<setjmp.h>
#include	<stdio.h>

/*
**	Parameters
*/

char		devnet[]			= "/dev/net/";
char		remote[sizeof devnet + DIRSIZ];

#define		QUIT		'y'
#define		QUIT_SEP	'^'

char		quit				= QUIT;		/* default escape char is ctrl/q */
char *		quitdescrpt			= "ctrl-";	/* escape prefix */

#define		TIMEOUT		20	/* give up line if no result after TIMEOUT secs */

/*
**	Miscellaneous
*/

char *		name;		/* program invoked name */
jmp_buf		to_jb;
#define		NULLSTR		(char *)0
#define		STREQUAL	0

int		sigcatch();

extern int	strlen();
extern char *	strcpy();
extern char *	strrchr();
extern char *	strncat();
extern char *	strcat();
extern char *	findhost();




main(argc, argv)
	int		argc;
	register char *	argv[];
{
	register char *	qp;
	struct pwent	pe;

	name = *argv++;
	if ( (qp = strrchr(name, '/')) != NULLSTR )
		name = qp+1;

	if ( pe.pw_uid = getuid() )
		if ( getpwlog(&pe, (char *)0, 0) == PWERROR
			|| (pe.pw_xflags & USENET) == 0
		   )
		{
			neterror("no permission");
			return 1;
		}

	if ( argc != 2 && argc != 3 )
	{
		neterror("Usage: %s [-quit-char] remote-host", argv[0]);
		return 1;
	}

	if ( okuse() )
	{
		if ( argc == 3 && argv[0][0] == '-' )
		{
			quit = argv[0][1];
			argv++;
		}

		if ( (qp = strrchr(argv[0], QUIT_SEP)) != NULLSTR )
		{
			quit = qp[1];
			*qp = '\0';
		}

		if ( quit > 'z' || quit < 'a' )
			quit = QUIT;

		con(argv[0], pe.pw_uid, pe.pw_gid);
		return 0;
	}

	neterror("illegal use!");
	return 1;
}


con(target, uid, gid)
	char *		target;
	uid_t		uid;
	uid_t		gid;
{
	register char *	port;
	register char *	link;
	FILE *		remotefd;
	char		rembuf[BUFSIZ];
	char	outbuf[BUFSIZ];
	extern		finish();
	extern		errno;

	if ( strcmp(target, NETID) == STREQUAL )
		neterror("This IS %s!\07", NETID);

	setbuf(stdout, outbuf);

	if ( (link = findhost(target, (long)0)) == NULLSTR )
		link = target;

	if ( access(strcat(strncat(strcpy(remote, devnet), link, DIRSIZ-1), "0"), 0) == SYSERROR )
		neterror("destination \"%s\" unknown", target);

	port = remote + strlen(remote) - 1;

	if ( setjmp(to_jb) )
	{
		errno = 0;
		neterror("line hung!");
	}

	signal(SIGALRM, sigcatch);
	alarm(TIMEOUT);

	while ( (remotefd = fopen(remote, "r+")) == NULL )
		if ( (errno == ENXIO) && (*port != '9') )
				(*port)++;
		else
			if ( errno == ENOENT && *port != '0' )
			{
				errno = 0;
				neterror("link to %s busy", target);
			}
			else
				neterror("can't open link \"%s\" to %s", link, target);

	/* ensure exclusive use */
	ioctl(fileno(remotefd),TIOCEXCL,NULL);
	/* level 7 systems only */

	setbuf(remotefd, rembuf);
	signal(SIGINT, finish);
	signal(SIGQUIT, finish);

	chown(remote, uid, gid);	/* indicate current user of the log line */
	chmod(remote, 0600);		/* protect against other access */

	/*
	** logically connect local terminal to remote until quit char received
	*/

	fprintf(stdout, " %s -> %s ('%s%c'=quit)\n", NETID, link, quitdescrpt, quit);
	fflush(stdout);

	sleep(2);	/* allow getty to start up */

#	ifdef	CON_GETTY
	if ( quit != QUIT )
		fprintf(remotefd, "@@:%s%c%c\n", target, QUIT_SEP, quit);
	else
		fprintf(remotefd, "@@:%s\n", target);
#	else	CON_GETTY
	fprintf(remotefd, "@@%s\n", target);
#	endif	CON_GETTY
	fflush(remotefd);

	alarm(0);

	if ( ttyconnect(fileno(stderr), fileno(remotefd), 1, quit&037) == SYSERROR )
		neterror("connect to link \"%s\" failed", link);

	signal(SIGALRM, finish);
	alarm(TIMEOUT);

	fprintf(remotefd, "@@\004\004%c@@\004\004@", quit&037);
	fflush(remotefd);

	finish(SIGINT);
}



sigcatch()
{
	longjmp(to_jb, 1);
}



finish(sig)
	int	sig;
{
#	ifdef	Aus1
	sig = SIGINT;
#	endif	Aus1
	if ( sig )
	{
		signal(sig, SIG_IGN);
	}
	if ( remote[0] != '\0' )
	{
		chown(remote, 0, 0);	/* change back to root */
#		ifdef	BASSER40
		chmod(remote, 0606);	/* multi use line */
#		endif	BASSER40
	}
	exit(sig?0:1);
}



/*
**	Validate that con is not being used with any
**	standard input or output redirection
**	- this includes asynchronous use.
**	The test checks that file descriptors 0, 1, and 2
**	represent the same tty.
*/

okuse()
{
	register int	i;
#	ifdef	Aus1
	struct statbuf	sbuf[3];
#	endif	Aus1
#	ifdef	Aus2
	struct stat	sbuf[3];
#	endif	Aus2

	for ( i = 0 ; i < 3 ; i++ )
		if ( fstat(i, &sbuf[i]) == SYSERROR	/* stat failed ??? */
			|| (sbuf[i].st_mode & S_IFMT) != S_IFCHR	/* not a tty */
			|| i
				&& ( sbuf[i].st_dev != sbuf[i-1].st_dev
					|| sbuf[i].st_ino != sbuf[i-1].st_ino	/* some sort of redirection */
				   )
		   )
			return 0;

	return 1;
}


/*VARARGS1*/
neterror(s, a, b)
	char *	s;
	char *	a;
	char *	b;
{
	extern	errno;

	alarm(0);
	fprintf(stderr, "%s: ", name);
	fprintf(stderr, s, a, b);
	if ( errno )
	{
		fflush(stderr);
		perror("\07");
	}
	else
		putc('\n', stderr);
	finish(0);
}
