#include	"log.h"
#include	"access.h"
#define	INIT_DATA
#include	"quit.h"
#include	<errno.h>
#include	<signal.h>
#include	<fcntl.h>


log(argc,argv)
int argc;
char **argv;
{
	register char	*arg;
	register char	*otp;
	register int	i;
	extern char	*fquit();
	extern		finish();
	extern int	errno;
	extern char *	strcpy();
	extern char *	strncat();

	if (argc != 2)
	{
		printf("Usage: log remote-special-file\n");
		exit(1);
	}

	strncat(strcpy(otherm, "/dev/net/"), argv[1], 13);

	otp = otherm + strlen(otherm);
	*otp++ = '0';		/* all names start with '0' termination */
	*otp-- = 0;		/* extra-null, address last byte of name */

	signal(SIGINT, SIG_DFL);
	while( (xfd = open(otherm, O_RDWR|O_EXCL)) == SYSERROR)
		if( (errno == ENXIO) && (*otp!='9') )
				(*otp)++;
		else
		{
			if( errno == ENOENT && *otp != '0' )
				printf("%s busy\n",argv[1]);
			else
				perror(otherm);
			exit (2);
		}
	signal(SIGINT, SIG_IGN);

	quit = ESCAPE;
	quitdescrpt = ESCAPED;
	for (i = 0; i < sizeof quits / sizeof quits[0]; i++)
	{
		arg = argv[1];
		otp = quits[i].name;
		while (*otp && *otp == *arg++) otp++;
		if (*otp == '\0')
		{
			quit = quits[i].escape;
			quitdescrpt = quits[i].descpt;
			break;
		}
	}
	if (i == sizeof quits / sizeof quits[0])	/* ran off the end */
	{
		if (uid)
		{
			printf("%s: illegal device\n", argv[1]);
			exit(1);
		}
		init_remote(xfd, 0);
	}
	else
		init_remote(xfd, quits[i].speed);

	chown(otherm,uid,DAEMONUID);	/* indicate current user of the log line */
				/* quicker than a ps */
	chmod(otherm,0600);	/* protect against other access, especially */
				/* from the disconnect command */
	signal(SIGINT, finish);

	printf("* tty\n");
	tty();

	for (;;)
	{
		errors();
		printf("* ");

		switch(getline())
		{
	    case 'p':	if (narg == 3) put();	/* put a file to remote */
			break;

	    case 'g':	if (narg == 3) get();	/* get a file from remote */
			break;

	    case 't':	if (narg == 1) tty();	/* talk to remote as a terminal */
			break;

	    case 's':	if (narg == 1) finish();	/* stop this sillyness */
			break;

	    case 'q':	if (narg == 2)  quitdescrpt = fquit();	/* change quit code */
			break;

	    case '!':	sh();			/* local escape to shell */
			break;

	    case 'c':	if( narg == 2 )
			{
				if (access(cmd[1], X) ||
				 chdir(cmd[1]) == -1 ) perror(cmd[1]);
				break;
			}

	    case 0:	break;

		/*
		 * Undocumented "features" added by KFH for kenr
		 */
	    case 'x':	ioctl(xfd, TIOCNXCL, 0);
			break;

	    case 'y':	ioctl(xfd, TIOCEXCL, 0);
			break;

	    default:	help();			/* unknown command */
			break;
		}
	}
}
