Uses Newposition;
vars conspoint destpoint;
cons ->conspoint;
dest ->destpoint;

vars Charout;
discout('/dev/tty') ->Charout;

function outascii c;
		Charout(c+128)
end;
vars inascii;
discin('/dev/tty') ->inascii;

vars inechomode; true ->inechomode;

function echo;
unless inechomode then
	Shell('stty echo');
	true -> inechomode
close
end;

function noecho;
  if inechomode then
	Shell('stty -echo');
	false ->inechomode
close
end;






vars ginascii goutascii gcharout;
inascii ->ginascii;
outascii ->goutascii;
charout ->gcharout;

function clrinputbuff;
  
	discin('/dev/tty') -> inascii;
	inascii ->ginascii;
end;

vars vducode scopecode;


2->vducode;  3->scopecode;

vars ingraphmode inscopemode inginmode inalphamode graphx graphy alphay alphax;

 0->graphx;
 0->graphy;
 false->inscopemode;
 false->ingraphmode;







vars lastyhi lastylo lastxhi;






operation 5 addkey x y;
 
 
 
  logor(logand(x,8:37), y<<5)
end;







vars gtransxyout gtransxyin;		








vars clipping;          
true ->clipping;

function gxyout x y;
 
 
 
 

 vars  xlobits xhibits ylobits yhibits;

  y>>5 addkey 1        ->yhibits;
  y addkey 3            ->ylobits;
  x>>5 addkey 1        ->xhibits;
  x addkey 2            ->xlobits;

 unless yhibits=lastyhi then
        yhibits.goutascii; yhibits->lastyhi
 close;

 unless ylobits=lastylo and xhibits=lastxhi then
        ylobits.goutascii; ylobits->lastylo;
 close;

 unless xhibits=lastxhi then
        xhibits.goutascii; xhibits->lastxhi;
 close;

 xlobits.goutascii;             
end;


vars setgraphic;        
vars lastx lasty;
0 -> lastx; 0 -> lasty;


vars outofbounds; false ->outofbounds;

vars gxmin gxmax gymin gymax;

0 ->gxmin; 1023 ->gxmax;
0 ->gymin; 1023 ->gymax;

function gptout y jumping;
        vars x x1 y1 x2 y2  p1out p2out bothout;
        
        
        
        
        if y.isnumber.not then y.destpoint -> y -> x; else -> x close;
        x -> graphx; y -> graphy;
        gtransxyout(x,y) -> y -> x;             
        lastx -> x1; lasty -> y1; x -> x2; y -> y2;

        
        
        

        function gclip x1 y1 x2 y2 xl pred => x1 y1 x2 y2;
         
         
                  pred(x1,xl) -> p1out;         
          pred(x2,xl) -> p2out;         
          if p2out then
                true ->outofbounds;
                if jumping then true ->p1out close
          close;

          if p1out and p2out then
                true ->bothout; x.round ->lastx; y.round ->lasty
          elseif p1out or p2out then
                
                xl,
                y2 - (y2 - y1 + 0.0)*(x2-xl)/(x2 - x1);		
                
                if p1out then   ->y1 ->x1
                else            ->y2 ->x2
                close;
          close
        end;

     if clipping then
        false ->outofbounds;
        false ->bothout;
        
        gclip(x1,y1,x2,y2, gxmin, nonop <) ->y2 ->x2 ->y1 ->x1;
        if bothout then exit;

        
        gclip(x1,y1,x2,y2, gxmax, nonop >) ->y2 ->x2 ->y1 ->x1;
        if bothout then exit;

        

        gclip(y1,x1,y2,x2, gymin, nonop <) ->x2 ->y2 ->x1 ->y1;
        if bothout then exit;

        gclip(y1,x1,y2,x2, gymax, nonop >) ->x2 ->y2 ->x1 ->y1;
        if bothout then exit;

        
        x1.round -> x1; y1.round -> y1;
        unless jumping or (x1=lastx and y1=lasty)
        then setgraphic();  gxyout(x1,y1)
        close
     close;

        x2.round -> x2; y2.round -> y2;
        gxyout(x2,y2);
        x.round -> lastx; y.round -> lasty
end;




vars gcucharout;                

function setscope;
 
 unless inscopemode then
        scopecode.goutascii; true->inscopemode;
 close
end;

function setnullstatus;
 
 false->inalphamode; false->inginmode; false->ingraphmode;
end;


function setgraphic;
 
 .setscope;             
 .setnullstatus;
 true ->ingraphmode;    
 goutascii(29);         
end;

function setgin;
 
 
 
 .setscope;

 .setnullstatus; true ->inginmode;
 .noecho;
 goutascii(27); goutascii(26);  
end;


function setalpha;
 
 unless inscopemode then .setscope close;
 .echo;
 goutascii(31);
 .setnullstatus;  true->inalphamode;
end;

function gsleep n;
	popmess([%Sleep,n%])
end;

function setvdu;
 if inscopemode then
   .setalpha;           
   vducode.goutascii;   
   gcucharout ->cucharout;
 close;
 false ->inscopemode;
end;

vars athome;    
 
function greset;
 
 .setscope;
 goutascii(27); goutascii(12);  
 
  gsleep(3);
 true->athome; 
 
 0->alphax;767 ->alphay;
 .setvdu;
end;























function gnumof xhibits xlobits;
 
  logor(logand(xhibits,8:37)<<5, logand(xlobits,8:37))
end;

cancel addkey;

function gincoords xhibits xlobits yhibits ylobits;
  
  
  
  gtransxyin(gnumof(xhibits,xlobits), gnumof(yhibits,ylobits))
end;

function getgin;
 
  .setgin;      
                
  .ginascii.ginascii.ginascii.ginascii.ginascii;
  .clrinputbuff;      
  .gincoords;   
end;




vars xturt yturt;

function gsetturt;
 
  graphx ->xposition; graphy ->yposition;
end;

function jumpto;
 
 .setgraphic;
 .gsetturt;
 gptout(true);
 gsetturt();
end;

function drawto;
 
 unless ingraphmode then
  jumpto(graphx,graphy);
 close;
 gptout(false);
 gsetturt()
end;



function draw steps;
 .gsetturt;
 Newposition(steps) -> yposition ->xposition;
  drawto(xposition,yposition);
 .gsetturt;
end;

function jump steps;
 .gsetturt;
  Newposition(steps) ->yposition ->xposition;
  jumpto(xposition,yposition);
end;




function gprintlength wd;
  
  vars n;
  function cucharout x; n+1 ->n end;
  0 ->n;
  if wd.isstring then prstring(wd) else pr(wd) close;
  n
end;


function gprintat wd;
 
 
 vars cucharout; gcharout ->cucharout;
 jumpto();
 setalpha();
 if wd.isstring then wd.prstring else wd.pr close;
 graphy ->alphay;
 graphx + 14*gprintlength(wd) ->alphax;
end;










function gcucharin;
 if inscopemode then
        .setvdu;
 close;
 .charin
end;

function gcucharout x;
 if inscopemode then .setvdu close;
        x.gcharout;
end;




operation 2 graphic;
  function interrupt;
	.setvdu;
	exitto(nonop graphic);
  end;

  function errfun;
	.setvdu;
	.syserr;
  end;
	false -> fnprops(errfun);

  l:
     lambda;
	'setgraphic'.prstring;pr(newline);
	.clrinputbuff;
	compile(gcucharin);
	.setpop;
     end.apply;
  goto l
end;











vars gxscale gyscale;





vars gxorigin gyorigin;




function gtransxyin x y;
  (x - gxorigin)/gxscale, (y - gyorigin)/gyscale
end;

function gtransxyout x y;
  if gxscale == 1 then x else x * gxscale close + gxorigin,
  if gyscale == 1 then y else y * gyscale close + gyorigin,
end;









unless gxorigin.isnumber then 495->gxorigin close;
unless gyorigin.isnumber then 385->gyorigin close;
unless gxscale.isnumber  then 1->gxscale close;
unless gyscale.isnumber  then 1->gyscale close;




function gmirrorx;
 - gxscale ->gxscale;
end;

function gmirrory;
 - gyscale ->gyscale;
end;

function gstretchx n;
 n * gxscale -> gxscale;
end;

function gstretchy n;
 n * gyscale -> gyscale;
end;

function gstretch n;
 gstretchx(n); gstretchy(n);
end;

function gshiftby x y;
 
 gxorigin + x -> gxorigin;
 gyorigin + y -> gyorigin;
end;

function gshiftr x;
 
  gxorigin + x * abs(gxscale) ->gxorigin
end;

function gshiftup y;
 
  gyorigin + y * abs(gyscale) ->gyorigin
end;

jumpto(0,0);
setvdu();

vars usingpoly;
unless usingpoly = true then
	'Type \n	: graphic;\n'.prstring;
close;
function turtle();
	greset();
	jumpto(0,0);
	0 -> heading;
	setvdu();
end;
