;;;	/ p o p / u s r / l i b / j u n c t i o n s . p
;;;		by Aaron Sloman.
;;; used by /pop/usr/lib/seelines.p
;;; see the SEEPICTURE demo.
;;; The top level function in this lot is recognisejunc.
;;; It is somewhat redundant at present.
function testforside (line);
  ;;; given a line, represented by its two ends, this returns a function which,
  ;;; when applied to a point gives the result -1, 0 or 1, depending which
  ;;; side of the line the point is on. If the point is on the line, the result is 0
 ;;; Note that the order of the points on the line will make a difference to the sign of the result
  vars x1 x2 y1 y2;
  dl(hd(line)) ->y1 ->x1;
  dl(hd(tl(line))) ->y2 ->x2;
	;;; It might be wiser to put the points in a canonical order first?
  lambda (point, dx, dy, c);
	;;; all except point will be frozen before the function is returned
	vars x y;
	dl(point) ->y ->x;
	sign( x * dy - y * dx - c)
  end(%x2 -x1, y2-y1, x1*y2 -y1*x2 %)
end;
function allsame(list);
	;;; true if all the elements of the list are the same.
	vars testitem;
	if list==[] then true exit;
	dest(list) ->list ->testitem;
	until	list==[]
	then
		unless	hd(list)==testitem
		then	false
		exit;
		tl(list) ->list
	close;
	true
end;
function lineshere=> otherends linesthrough;
	;;; If this function is applied at a point, after the picture has been painted
	;;; with lists of lines through each point, then the result is two lots of
	;;; information about the point
	;;; (a) a list of the far ends of lines ending at the point
	;;; (b) a list of the lines going through the point but not ending there
	vars lines line end1 end2 p;
	[] ->otherends;
	[] ->linesthrough;
	here() ->p;
	for	colhere() ->lines
	step	tl(lines) ->lines
	till	atom(lines)
	then	hd(lines) ->line;
		dl(tl(line)) ->end2 ->end1;
		if	equal(end1,p)
		then	end2::otherends ->otherends
		elseif	equal(end2,p)
		then	end1::otherends ->otherends
		else	tl(line)::linesthrough ->linesthrough;
		close
	close
end;
function testmulti;
;	;;; called inside recognisejunc as a last resort.
	vars linesthrough otherends;
	lineshere() ->linesthrough ->otherends;
	unless length(linesthrough) == 1 then error('threeway error',here(),2000) close;
	if	allsame(maplist(otherends,testforside(hd(linesthrough))))
	then	"kay"
	else	"psi"
	close
end;
function testthreeway;
	;;;used inside recognisejunc to distinguish arrow from fork
	vars p e1 e2 e3 otherends;
	here() ->p;
	erase(lineshere()) ->otherends;
	unless	length(otherends)==3
	then	error('testthreeway error: otherends -',otherends,2000)
	close;
	dl(otherends) ->e1 ->e2 ->e3;
		;;; these are the far points on the lines which meet here.
		;;; its an arrow if theres one line such that the other two lie on the same side of it
		;;; otherwise a fork.
		;;; If there's one such line there will be two, so only two out of
		;;; the three need be tested.
	if	allsame(maplist([%e1,e2%], testforside([%p,e3%])))
	or	allsame(maplist([%e2,e3%], testforside([%p,e1%])))
	then	"arrow"
	else	"fork"
	close
end;
function recognisejunc(le,lm);
	;;; called at a point inside seelines
	;;; le is the number of lines ending at the point,
	;;; lm is the number of lines going through the point (m=middle)
	if	le==0
	then	if	lm==2
		then	"cross"
		else	"multicross"
		close
	elseif	lm==0
	then
		if	le==1
		then	"end"
		elseif	le==2
		then	"ell"
		elseif	le == 3
		then	testthreeway()
		else	"multi"
		close
	elseif	lm==1
	then	if	le==1
		then	"tee"
		else	testmulti()
		close
	else	"horrible"
	close
end;
