/	SUBTITLE	b-expand.s	alter size of heap area
/	Written by Steven Hardy on 17 May 1976
/
/ This function is called whenever it seems that the area of core allocated to
/ the POP11 process is inappropriate.
/ This function moves the user stack down next to the heap and tries to
/ alter the break.
/ It then moves the user stack back up to the break
/
sexpand:
	mov	bhphi,r1		/ top of heap to r1
1:
	cmp	r5,br5hi		/ user stack empty?
	beq	1f			/ br if so
	mov	(r5)+,(r1)+		/ transfer top item
	br	1b			/ loop back
1:
	mov	r1,r2			/ set up to compute new break in r2
	add	$ofree+77,r2		/ add 'reasonable' free space to r2
	bic	$77,r2			/ round down to next multpile of 100 bytes
	mov	bsplo,r3		/ compute maximum break in r3
	sub	$ozone,r3
	bic	$017777,r3		/ round down to page boundary
	sub	$100,r3			/ and one block below
	cmp	r2,r3			/ is proposed break to high?
	blos	1f			/ br if okay
	mov	r3,r2			/ alter proposed break to maximum
1:
	cmp	r2,br5hi		/ do we already have the space?
	beq	1f			/ br if so
	mov	r2,ibreak+2		/ set up syscall
	sys	0; ibreak		/ issue the break request
	bcs	1f			/ br on error
	mov	r2,br5hi		/ store new br5hi
1:
	mov	br5hi,r5		/ set new user stack
1:
	cmp	r1,bhphi		/ any more of user stack to move back?
	beq	1f			/ br if not
	mov	-(r1),-(r5)
	br	1b
1:
	rts	pc
