/*	PAR - The POP11 System Archiver
 *	/ p o p / c c c / p a r . c
 *
 *	This program creates POP11 library files,for use with
 *	the popmess(Liblist) command.
 *
 *	Typical calls:
 *		par file1 file2 ... >libfile
 *	or	par <specfile >libfile
 *
 *	PAR, like CAT, takes a number of file names
 *	as argument and concatenates them to its
 *	standard output. Unlike CAT, PAR processes
 *	the subfiles (removing comments, redundant spaces etc)
 *	for faster compilation.  Furthermore, PAR precedes the
 *	subfiles by an 'index' understood by the POP11 system.
 *	If invoked with NO arguments PAR treats its
 *	standard input as a set of filenames (one per line).
 */


main(argc,argv)
int argc;
char  **argv;
{	register int this,max,temp;
	extern fout;
	char *name[512];
	int size[512];
	this = 1;
	if (--argc) while (argc--) name[this++] = *++argv;
	else while (temp = readline())
			name[this++] = temp;
	max = this;
	if (max > 500) error("too many input files",0);
	name[0] = "[INDEX]";
	fout = dup(1);
	size[0] = max * 16;
	seek(fout,size[0],0);
	for (this = 1; this < max; this++)
		size[this] = process(name[this]);
	flush();
	seek(fout,0,0);
	for (this = 0; this < max; this++)
	{	write(fout,trim(name[this]),14);
		write(fout,&size[this],2);
	}
}


char heap[5120];
char *free  heap;
readline()
{	register char c,*p,*q;
	p = free;
	while ((c = getchar()) != '\n')
		if (c == 0) return(0);
		else *p++ = c;
	*p++ = 0;
	q = free;
	if ((free = (p+1) & ~1) > &heap[5000])
		error("file name space overflow",0);
	return(q);
}


char last;
int count;					/* Incremented by "put" */
process(name)
{	extern fin;
	register char this;
	last = '\n';
	count = 0;
	if ((fin = open(name,0)) < 0)
		error("unable to open input file",name);
	this = getchar();
	while (this > 0)
		if (this == ';')
		{	if ((this = getchar()) == ';'
					&& (this = getchar()) == ';')
				while ((this = getchar()) !=  '\n');
			else put(';');
		}
		else
		{	if (this == ' ' || this == '\t' || this == '\n')
				this = '\n';
			put(this);
			if (this == '\'')
			{	while ((this = getchar()) != '\'')
				{	put(this);
					if (this == '\\')
						put(getchar());
				}
				put(this);
			}
			this = getchar();
		}
	if (count & 1) put(';');
	close(fin);
	fin = 0;
	return(count);
}
put(c)
char c;
{
	if (c != '\n' || last != '\n')
		{count++; putchar(c); last = c;}
}


char trimbuff[20];
trim(name)
{	register char c,*p,*q;
	p = name;
	q = trimbuff;
	while (c = *p++)
		if (c == '.') break;
		else if (c == '/') q = trimbuff;
		else *q++ = c;
	while (q < &trimbuff[20]) *q++ = 0;
	return(trimbuff);
}

error(message,culprit)
char *message, *culprit;
{
	diagnostic("par -- ");
	diagnostic(message);
	if (culprit) {diagnostic(" "); diagnostic(culprit);}
	diagnostic("\n");
	exit();
}

diagnostic(string)
register char *string;
{
	char c;
	while (c = *string++) write(2,&c,1);
}
