.hw micro-world
?he 'AI1.VAC.R''Page %'
?fo ' Steven Hardy'- % -'1st June, 1977'
.ce 3
Vacation Thinking for Cognitive Studies: Artificial Intelligence.
.br
------------------------------------------------------------------
June 1977

The Artificial Intelligence course is about the construction of
computational models of human cognitive abilities.
This raises the question 'which abilities`? and (to a great extent)
the answer is 'rather simple ones`
- or at least those we normally
regard as simple.
Consider, for example, my actionson a typical morning;
After waking and rather blearily looking round I get up, have
a bath, get dressed, have breakfast and come to the university.
As you see - nothing exceptional,
until one examines them in greater detail.

As I look round everything is as I expect; I am in my bedroom, the sun shining through
the window and nothing is amiss;
although half asleep
I experience no difficulty in recognizing the scene before me.
And yet this involves a colosal
amount of information processing; somehow the stream of impulses from nerves
in my retina
is 'matched` against my stored model of the room
- a model I would articulate in terms of 'walls`, 'lampshade`, 'plant` etc.
not in the terms I imagine my eye to describe it
- 'bluish-green light falling on retinal cell number 200000`!

I manage to translate the thought 'I'll get up now` into the necessary
pattern of muscle movements with only slight difficulty
and effortlessly execute a plan which takes me to the bathroom.
(I have to modify my general 'getting to the bathroom plan`
to avoid a chair left in the corridor but this was not a major problem.)

Later, when about to leave the house I pack some books into my
briefcase;
sometime you might like to think about a simplified version of this problem,
that of  drawing a number of rectangles (of given size) onto a TURTLE picture
so that they don't overlap - its surprisingly hard!

I have only recently moved house and therefore have to consult some kind of mental
map of the area to devise a plan for getting to the station
- unlike most of the day`s activity I am aware of doing this, though
not aware of precisely HOW I use this map.

The task of modelling my thought processes during this half hour
period of the day is well beyond practitioners
of A.I. (or psychology)
and they have sought a simplified version of this problem
to explore.
One such simplification is to consider a 'microworld` consisting
of a number of children`s building blocks on a table.
The task of writing programs to see and manipulate such a world
may, so some think,
help us to understand how WE get about in OUR world.

.tp10
Obviously, we cannot model all aspects of human cognition
in this world but here are some of the tasks explored:
.ll -5
.in +5

1) Using a T.V. camera get a digitisation of a scene containing
a number of such blocks. Write a program to interpret this digitization.
.br
.ne 25
.nf
.in +5
        *****
       *   **
      ***** *         *********
      *   * *        *       **
     **   * ****    *       * *
    * *   **  **   *       *  *
   *  *****  * *  *********   *
  *         *  *  *       *   *
 *         *   *  *       *   *
\&***********    ********   *   *
\&*         *    *     **   *   *
\&*         *   *     * *   *  *
\&*         *  *******  *   * *
\&*         *  *     *  *   **
\&*         *  *     *  *****
\&*         *  *     *  *
\&*         *  *     * *
\&*         * **     **
\&*         ** *******
\&***********
.br
How many blocks are there?
How many blocks are on the table?
How many blocks are partially occluded by others.
.fi
.in -5

2) Write a program to produce a plan for rearranging the scene given a description
in terms of the blocks, and their positions, it contains.
e.g. Pile up the blocks in a single tower in order of size
(biggest at the bottom) assuming you can pick up only one block at a time.
.br

3) Write a program to converse in English about the scene and to manipulate the scene.
For example, answer the following question:
.in +5
.ll -5

Call the smallest block 'A` and the next smallest 'B`.
.br
Why did you have to move block A to put block B on the biggest block?
.in -5
.ll +5

4) Learning a new concept. e.g How could the computer learn, from examples,
the difference between a 'tidy stack` and an 'untidy stack`;
How would YOU define these concepts?
.in -5
.ll +5

Over the vacation we would like you to think about the first of these tasks
- instructing a computer so that it can interpret 'digitizations' of a blocks world scene.
The scene above has already been processed
in that only points on lines (which represent edges) are marked.
One might prefer a program to accept 'gray level data`, i.e. a number representing
how bright the light at an (x,y) position of the scene is; a simplified
version of such input (for the scene portrayed earlier) might be:

.tp25
.ce 24
00000000000000000000000000000000000
00000000000000000000000000000000000
00000000003333300000000000000000000
00000000033333200000000000000000000
00000000333332200000000033333333300
00000000111122200000000333333333200
00000003111122233300003333333332200
00000033111122333200033333333322200
00000333111123332200333333333222200
00003333333333322200111111112222200
00033333333333222200111111112222200
00333333333332222233333331112222200
00111111111122222333333321112222200
00111111111122223333333221112222000
00111111111122233333332221112220000
00111111111122211111122221112200000
00111111111122211111122221112000000
00111111111122211111122220000000000
00111111111122211111122200000000000
00111111111122211111122000000000000
00111111111122011111120000000000000
00111111111120000000000000000000000
00000000000000000000000000000000000
00000000000000000000000000000000000

Lets call our original picture an 'edge picture` and that above
a 'gray level picture`.
One approach to producing the edge picture from the gray level picture
is to apply a 'local operator`
to each point of the gray level picture.
When applied to a point (x,y) this operator should return TRUE
if, and only if, (x,y) is an edge point.
Here is a poor example of such an operator:

.in +5
.ll -5
A point (x,y) is not an edge point if the light intensity at that point is
the same as the light intensity at the points directly above, to the right
and diagonally up to the right.

.in -5
.ll +5
.tp 10
Translated into POP11 this looks like:

.in +5
.ll -5
.nf
 	: FUNCTION ISEDGEPOINT (X,Y) => RESULT;
 	:	IF	GRAYPIC(X,Y) = GRAYPIC(X+1,Y)
 	:	AND	GRAYPIC(X,Y) = GRAYPIC(X,Y+1)
 	:	AND	GRAYPIC(X,Y) = GRAYPIC(X+1,Y+1)
 	:	THEN	FALSE -> RESULT
 	:	ELSE	TRUE -> RESULT
 	:	CLOSE
 	: END;
.br

.fi
.in -5
.ll +5
What is wrong with the above operator - can you produce a better edge detector?
Try to design a program which uses the function ISEDGEPOINT
(or an improved version of it)
and the gray level picture to create
the edge picture.
(You'll have to arrange for x and y to be varied so that the whole picture is covered.)
.tp30

Let us suppose that we have a program
capable of finding the junctions (and regions) between edges in the above picture
(see
/POP/DEMOS/PICTURES):

.nf
.in +17
        a***b
       * 1 **
      c***d *         e*******f
      g   *3*        *       **
     ** 2 * h**i    *   4   * *
    * *   **  **   *       *  *
   *  i***k  * *  l*******m   *
  *         *  *  *       *   *
 *    5    *   *  *    6  * 7 *
n*********o  8 *p*q***r   *   *
\&*         *    s     **   *   t
\&*         *   *  9  * *   *  *
\&*         *  u*****v  *   * *
\&*         *  *     *10*   **
\&*    11   *  * 12  *  w***x
\&*         *  *     *  y
\&*         *  z     * *
\&*         * **     **
\&*         ** A*****B
.br
C*********D
.in -17
.fi

Such a program, if we could write one, would have an easier task if the picture
had a finer resolution (i.e had more points in it) - why?

Let us further suppose that we could convert the above picture into 
the following list of lists:
.nf
.in +5

[[a 8 20 b c]
 [b 12 20 h d a]
 [c 6 18 a d g]
 ...
 [C 1 1 D n]
 [D 11 1 C n]]
.in -5
.fi

The first elementof this list structure - [a\ 8\ 20\ b\ c] - says that
junction 'a` has x-coordinate 8, y-coordinate 20 and is
connected to junctions 'b` and 'c`.
How hard would it be to get the above list structure from the above picture?
The following list structure again describes the junctions, this time they are followed by a list
of the regions at that junction
and the size of the relevant corner of that region (in degrees)
(nb region 0 is the background):
.nf
.in +5

[[a 0 225 1 135]
 [b 0 270 3 45 1 45]
 [c 0 225 1 45 2 90]
 [d 1 90 3 135 2 90]
 [e 0 225 4 135]
 ...
 [A 0 270 12 90]
 [B 0 225 12 90 10 45]
 [C 0 270 11 90]
 [D 0 225 11 90 8 45]]

.fi
.in -5
Can you complete the above list?
How many deliberate(!) mistakes have I made?
(You will find it easier if you redraw the above picture using 'proper` lines
rather than asterisks.)

Lines in a picture correspond to edges in the scene,
regions correspond to surfaces and junctions to vertices.
At a vertex some of the surfaces belong to the same body,
e.g. at junction k regions 2 and 3 denote two surfaces of the same object.
If you look at the above scene you will see that the same type of junctions
occur again.
We need some names for these types of junction and conventionally they are called:
.tp6
.in +5
.ll -5
.nf
ARROWS - where three lines meet thus:
.in +5
    *
   ***
  * * *
 *  *  *

.in -5
FORKS - where three lines meet thus:
.in +5
 *     *
  *   *
   * *
    *
    *
    *

.in -5
ELLS - where any two lines meet, thus:
.in +5
 *****     or *****
     *             *
     *              *
     *               *
     *                *

.in -5
TEES - where any line meets a straight line
.in +5
\&*******  OR  *******
   *             *
   *              *
   *               *
   *                *
.in -5

.fi
.in -5
.ll+5

We would need a program to take the above list and convert it into a list
of
.ul
typed
junctions,
thus:
.in +5
.nf
[[a ell 0 1]
 [b ell 0 1]
 [c arrow 0 1 2]
 [d fork 1 3 2]
 [e ell 0 4]
 ...
 [z tee 12 0 8]
 [A ell 0 12]
 [B arrow 0 12 10]
 [C ell 0 11] 
 [D arrow 0 11 8]]
.fi
.in -5

In the picture above wherever there is an ARROW junction the regions
on either side of the barb denote surfaces belonging to the same object
- and we can try to find similar 'rules` for all junction types, as did
Adolfo Guzman in his SEE program. His program would produce the following 'region links`
from the junctions in the above lists:
.in +5
.nf

a - no links
b - link 1 and 3
c - link 1 and 2
d - link 1, 2 and 3
e - no links
f - link 4 and 7
 ...
A - no links
B - link 10 and 12
C - no links
D - link 8 and 11

.fi
.in -5
If we collect together all region links we get:
.in +5

[[] [1 3] [1 2] [1 2 3] [] [4 7] ... [10 12] [] [8 11]]
.in -5

Try producing a set of rules to link regions
and explore the consequences of your rules on at least six pictures of your own.
(To produce your list of rules
you will have to draw lots of different pictures anyway).
Try writing POP11 functions embodying your rules, for example:
 	: FUNCTION LINKS(JUNCTION);
 	:	IF	TYPE(JUNCTION) = "ELL"
 	:	THEN	[]
 	:	ELSEIF	TYPE(JUNTION) = "ARROW"
 	:	THEN	[%FOURTH(JUNCTION), FIFTH(JUNCTION)%]
 	:	...
 	:	CLOSE
 	: END;
.br
This function (when completed) could be used to write a program to produce the list of
linked regions shown above. Try writing a function to take this set of linked regions and produce
a list of regions belonging to each body, that is:
 	: AGGREGATE([[] [1 3] [1 2] [1 2 3] ... [10 12] [] [8 11]]) =>
 	** [[1 2 3] [4 6 7] [5 8 11] [9 10 12]]
.br

If you are able to produce a list of region linking rules that satisifies you
try it on (a) scenes where one body passes behind another and reappears on the other side, e.g:
.in +5
.nf

            *******
           *     **
          *     * *
         *******  *
         *     *  *
         *     *  *
         *     *  *
         *     *  *
         *     *  *
   *******     *  ****************
  *      *     *  *             **
 *       *     *  *            * *
\&**********     *  *************  *
\&*        *     *  *           *  *
\&*        *     *  *           *  *
\&*        *     *  *           *  *
\&*        *     *  *           * *
\&*        *     *  *           **
\&**********     *  *************
         *     *  *
         *     *  *
         *     * *
         *     **
         *******

.in -5
.fi
(b) objects with holes in.

Your vacation work is to think, and write, about the problems in writing
programs like those hypothesised above; in particular, what difficulties you would encounter
and what the limitations of any resulting program would be.
The most important part of the task is to produce a list of junction TYPES
(e.g. ARROW, TEE etc) and to say which regions surrounding each junction type
belong to the same body.
.br
IMPORTANT - You will find this very hard, especially if you try to produce fragments of POP11 code;
do not be disheartened by this - you haven't done the course yet!
.bb
.ce 2

There is no good text-book available yet for this course. However, you
may find it useful to dabble in some of the following books and articles.
Make notes on any topic that interests you, and bring any problems or
difficulties to the first tutorial.
prepared to skip technical passages.

Productive Thinking. M. Wertheimer.
.sp
Computing Machinery and Intelligence. MIND. A.M. Turing.
(also in CT).
.sp
Teaching children to be mathematicians versus teaching about mathematics
Some bits of some of the books may be quite hard to read. Be
.br
Seymour Papert,
Artificial Intelligence Memo 249,
Massachusets Institute of Technology,
July 1971.

The Thinking Computer - mind inside matter,
.br
Bertram Raphael,
W.\ H.\ Freeman and Co.,
1976.
This book presents a highly idiosyncratic view of AI, so
take it with a pinch of salt.

The Psychology of Computer Vision,
.br
P.\ H.\ Winston (ed),
McGraw-Hill 1975.
.br
(Try the articles by Winston, Waltz and Minsky. Some bits are
very hard.)

Plans and the Structure of Behaviour,
.br
G.\ A.\ Miller, E.\ Galanter & K.\ H.\ Pribam,
Holt, Rinehart and Winston 1960.
This book is most important. As an exercise try rewriting a
'tote unit` in POP11.

The Digital Villain,
.br
R.\ M.\ Baer,
Addison-Wesley 1972.

Recent Progress in Artificial Intelligence,
.br
M.I.T.  A.I. memo no 252
.br
M.Minsky and S.Papert

Computer Models of Thought and Language,
.br
Edited by K. Colby and R. Schank.
.br
Read the chapter by Newell, but beware its pretty hard going.
.sp
The Robots are Coming,
.br
edited by F.H. George, National Computer Centre publications, 1975
This book has some nice pictures and examples in it.

Understanding Natural Language,
.br
T. Winograd, Edinburgh University Press.
.br
(Leave out technical parts.)
