#include	"../h/local.h"
#include	"pdp00.h"
#include	"pdpex.h"

/*
 * this file contains several library routines.
 * these routines are included to overcome the
 * incompatibilities between UNIX version 6 and 7.
 * not included are the system call routines and printf and atof.
 */

zero(area,length) char *area; {
	register char *p;
	register n;
	/*
	 * Clear area of length bytes.
	 */
	if ((n=length)==0)
		return;
	p = area;
	do *p++=0; while (--n);
}

int strcmp(as1,as2) char *as1,*as2; {
	register char *s1,*s2;
	/*
	 * String compare.
	 */
	s1 = as1; s2 = as2;
	while (*s1++ == *s2)
		if (*s2++ == 0)
			return(0);
	return( (*--s1 < *s2) ? -1 : 1);
}

strcpy(as1,as2) char *as1,*as2; {
	register char *s1,*s2;
	/*
	 * Fast string copy.
	 */
	s1 = as1; s2 = as2;
	while (*s1++ = *s2++)
		;
}

finit(af,fd) FILE *af; {
	register FILE *f;
	/*
	 * initialize file structure
	 */
	f = af;
	f->fd = fd;
	f->nleft = 0;
	f->nextp = 0;
}

int fill() {
	/*
	 * read in next block
	 */
	stdin.nextp = stdin.buff;
	return(stdin.nleft = read(stdin.fd,stdin.buff,BUFSIZ) - 1);
}

flush() {
	/*
	 * write out a (partial) filled block; fatal if error
	 */
	if (stdout.nextp)
		if (write(stdout.fd,stdout.buff,stdout.nextp-stdout.buff) < 0)
			if (inerror == 0)
				fatal("write error");
	stdout.nextp = stdout.buff;
	stdout.nleft = BUFSIZ;
}

putchar(c) {
	/*
	 * write next character
	 */
	if (--stdout.nleft < 0) {
		flush();
		--stdout.nleft;
	}
	*(stdout.nextp)++ = c;
}

int readbyte() {
	register FILE *f;
	/*
	 * Read one byte from input.
	 */
	inpoff++;
	f = &stdin;
	if (--f->nleft < 0)
		if (fill() < 0)
			fatal("end of file on input");
	return( *(f->nextp)++ & 0377 );
}

int readword() {
	register n;
	/*
	 * get a word.
	 */
	n = readbyte();
	return(n | (readbyte() << 8));
}

pputd(an) {
	register n,n1;

	n = an;
	if (n1 = n/10)
		pputd(n1);
	pputc(n%10 + '0' );
}

pputo(an) {
	register n,n1;

	n = an;
	n1 = (n>>3)&017777;
	if (n1)
		pputo(n1);
	pputc((n&07) + '0' );
}

pputs(ap) char *ap; {
	register char *p;

	p=ap;
	while (*p)
		pputc(*p++);
}

plabel (s) char *s; {
	pputs(s);
	pputc(':');
}

pline () {
	pputc('\n');
	eoln=TRUE;
}

pputc(c) {
#ifdef DUMP
	if(dumps)
		if(eoln)
			printf("---- ");
#endif
	eoln=FALSE;
	/* here, the characters of the produced PDP 11 code are
	   given to the output buffer.
	*/
	if (--stdout.nleft < 0) {
		flush();
		--stdout.nleft;
	}
	*(stdout.nextp)++ = c;
}

error(string1,a1) char	*string1,*a1; {
	register fd;

	/*
	 * diagnostic output
	 */
	inerror++;
	error_count++;
	flush();
	fd = stdout.fd;
	finit(&stdout,2);
	printf("%s: line %d (byte 0%o",progname,complines,inpoff);
	if (module[0])
		printf(";pro %s",module);
	printf("): ");
	printf(string1,a1);
	putchar('\n');
	flush();
	finit(&stdout,fd);
	inerror = 0;
}

fatal(s) char *s; {
	/*
	 * handle fatal errors
	 */
	error("Fatal error: %s",s);
	ertrap();
}

ertrap() { /* trap routine to drain input in case of compile errors */

	while (read(stdin.fd,stdin.buff,BUFSIZ) > 0)
		;
	exit(-1);
}

#ifdef V6
atol(ap,lp) char *ap; long *lp; {
	long n1,n2;
	register int f;
	register char *p;

	p = ap;
	n1 = 0;
	f = 0;
	for(;;p++) {
		switch(*p) {
		case ' ':
		case '\t':
			continue;
		case '-':
			f++;
		case '+':
			p++;
		}
		break;
	}
	while(*p >= '0' && *p <= '9') {
		n2 = n1 + n1;
		n2 = n2 + n2 + n1;
		n1 = n2 + n2 + (*p++ - '0');
	}
	if (f)
		n1 = 0 - n1;
	*lp = n1;
}
#endif
