#include	"../h/local.h"
#include "pdp00.h"
#include "pdpex.h"
#include "../h/em1.h"
/*
** utilities of EM1-translator
*/

#define MAXERR 50

/*
 * glohash returns an index in globlabel and leaves a stepsize in globstep
 *
 */

int glohash(aname) char *aname; {
	register char *p;
	register i;
	register sum;

	for(sum=i=0,p=aname;*p;i =+ 3)
		sum =+ (*p++)<<(i&07);
	sum =& 077777;
	globstep = (sum / MAXLABEL) + 7;
	return(sum % MAXLABEL);
}

/*
 * lookup idname in labeltable , if it is not there enter it
 * return index in labeltable
 */

glob_t *glolookup(name,status) char *name; {
	register glob_t *gbp;
	int rem;

	if (nglobs > MAXLABEL - 10 )
		fatal("global label table overflow");
	rem = glohash(name);
	gbp = &globlabel[rem];
	while (gbp->g_name[0] != 0 && strcmp(name,gbp->g_name) != 0) {
		rem = (rem + globstep) % MAXLABEL;
		gbp = &globlabel[rem];
	}
	if (gbp->g_name[0] == 0) {
		strcpy(gbp->g_name,name);
		++nglobs;
	}
	switch(status) {
	case IMPORTING:
		if ((gbp->g_status&DEF) == 0)
			gbp->g_status =| IMP;
		break;
	case FORWARDING:
		if ((gbp->g_status&DEF) == 0)
			gbp->g_status =| FWD;
		break;
	case EXPORTING:
		gbp->g_status =| EXP;
		break;
	case DEFINING:
		if (gbp->g_status&DEF)
			error("global symbol redefined",0);
		else {
			gbp->g_status =| DEF;
/*PDP*/			gbp->g_status =& ~IMP;
		}
		break;
	case OCCURRING:
		if ((gbp->g_status&(DEF|IMP|FWD)) == 0)
			error("undefined global reference",0);
		break;
	}
	return(gbp);
}

#define locstep 1

#define lochash(n) (((n)-1)%MAXLOCLABEL)

locl_t *loclookup(an,status) {
	register locl_t *lbp;
	register num,i;

	if (nlocs == MAXLOCLABEL)
		fatal("local label table overflow");
	num = an;
	i = lochash(num);
	lbp = &loclabel[i];
	while (lbp->l_num != num && lbp->l_num != 0) {
		i = (i + locstep) % MAXLOCLABEL;
		lbp = &loclabel[i];
	}
	if (lbp->l_num == 0) {
		lbp->l_num=num;
		++nlocs;
	}
/*PDP*/	if ((lbp->l_status & (DEF|OCC))==0)	/* first occ */
/**/		lbp->l_val = uniquelocs++;
	if (status == DEFINING) {
		if (lbp->l_status & DEF)
			error("local label redefined",0);
		else {
			lbp->l_status =| DEF;
		}
	} else {
/**/		lbp->l_status =| OCC;
	}
	return(lbp);
}

char pro_message[]	EQ "pro redeclared or PDP restriction";

int prolookup(name,status) char *name; {
	register proc_t *prptr;
	register char stat;

	prptr=procdesc;
	while (prptr <= last_proc)
		if (strcmp(name,prptr->p_name) == 0)
			break;
		else
			prptr++;
	if (prptr > last_proc) {
		if (++last_proc >= &procdesc[MAXPROC])
			fatal("procdesc full");
		strcpy(prptr->p_name,name);
	}
	stat = prptr->p_status;
	switch (status) {
	case PRO_OCC:
		stat =| OCC;
		break;
	case PRO_LCL:
		if(stat & (DEF|OCC))
			error(pro_message,0);
		else
			stat =| IMP;
			/* NB. here IMP is used as a flag for
			   yet undefined forward declarations. */
		break;
	case PRO_DFL:
		if(stat & DEF || stat == OCC)
			error(pro_message,0);
		else {
			stat =| DEF;
			stat =& ~IMP; /* clear forward flag */
		}
		break;
	case PRO_DFX:
		if(stat & (DEF|IMP))
			error(pro_message,0);
		else
			stat =| (DEF|EXP);
		break;
	}
	prptr->p_status = stat;
	return(prptr-procdesc);
}

pro_check () {	/* at EOF */
	register char status;
	register proc_t *p;

	for(p=procdesc;p <= last_proc;p++) {
		if ((status=p->p_status) & IMP)
			error("undefined local pro",0);
		if(status==OCC) {
			pputs(GLOBL);
			pputs(p->p_name);
			pline();
		}
	}
}

glo_check () {	/* at EOF */
	register glob_t *glb;

	for(glb=globlabel;glb < &globlabel[MAXLABEL];glb++)
		if(glb->g_status&(IMP|EXP)) {
			pputs(GLOBL);
			pputs(glb->g_name);
			pline();
		}
}
