#include	"../h/local.h"
#include "pdp00.h"
#include "pdpex.h"
#include "../h/em1.h"

line_t	*freeline;
line_t	*currline;
line_t	*peekline;
line_t	line1;
line_t	line2;
line_t	nulline;

translate () {

	init_pro();
	do
		process_compact();
	while (!end_seen);
	check_labels();
	debug_dump();
}

init_pro () {

	nextline = currline = &line1;
	freeline = &line2;
	peekline = 0;
	zero(chp_cast loclabel,MAXLOCLABEL*sizeof loclabel[0]);
	nlocs = 0;
	end_seen = 0;
	clearegs();
	fsp=coco=fake;
	stk.type=STK;
}

process_compact () {

	if (nextline != currline)	/* forward called and used */
		peekline = 0;
	if (peekline) {			/* forward called, not used */
		freeline = currline;
		currline = peekline;
		peekline = 0;
	} else
		do_compact(currline);
	if (currline->instr_num != op_nul) { /* : no pseudo */
		dump_line(complines,currline);
		make_code(nextline=currline);
		dump_fake();
		dump_regs();
	}
}

line_t *forward () {
	register mode;

	if (peekline) return(peekline); /* already called */
	mode=curr_mode;
	do {
		do_compact(freeline);
		dump_line(complines,freeline);
	} while(freeline->instr_num == op_nul && !end_seen);
	set_mode(mode);
	if (!end_seen)
		return(peekline=freeline);
	else {
		peekline = 0;
		return(&nulline);
	}
}

check_labels(){
	register locl_t *lp;

	for(lp=loclabel;lp < &loclabel[MAXLOCLABEL];lp++)
		if(lp->l_num
		 && (lp->l_status&DEF)==0 )
			error("local label missing",0);
}
